/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.cursor.RawCursor;
import org.neo4j.helpers.Exceptions;
import org.neo4j.index.internal.gbptree.CleanupJob;
import org.neo4j.index.internal.gbptree.ConsistencyChecker;
import org.neo4j.index.internal.gbptree.CrashGenerationCleaner;
import org.neo4j.index.internal.gbptree.FreeListIdProvider;
import org.neo4j.index.internal.gbptree.GBPTreeCleanupJob;
import org.neo4j.index.internal.gbptree.GBPTreeLock;
import org.neo4j.index.internal.gbptree.Generation;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.InternalTreeLogic;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.SeekCursor;
import org.neo4j.index.internal.gbptree.StructurePropagation;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreePrinter;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.index.internal.gbptree.TreeStatePair;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.ValueMergers;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;

public class GBPTree<KEY, VALUE>
implements Closeable {
    static final int FORMAT_VERSION = 2;
    public static final Monitor NO_MONITOR = new Monitor.Adaptor();
    public static final Header.Reader NO_HEADER = headerData -> {};
    private final PagedFile pagedFile;
    private final File indexFile;
    private final Layout<KEY, VALUE> layout;
    private final TreeNode<KEY, VALUE> bTreeNode;
    private final FreeListIdProvider freeList;
    private final SingleWriter writer;
    private volatile boolean changesSinceLastCheckpoint;
    private final GBPTreeLock lock = new GBPTreeLock();
    private int pageSize;
    private boolean created;
    private volatile long generation;
    private volatile Root root;
    private final Supplier<Root> rootCatchup = () -> this.root;
    private final LongSupplier generationSupplier = () -> this.generation;
    private final Monitor monitor;
    private boolean closed;
    private boolean clean;
    private final CleanupJob cleaning;

    public GBPTree(PageCache pageCache, File indexFile, Layout<KEY, VALUE> layout, int tentativePageSize, Monitor monitor, Header.Reader headerReader, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) throws IOException {
        this.indexFile = indexFile;
        this.monitor = monitor;
        this.generation = Generation.generation(1L, 2L);
        long rootId = 3L;
        this.setRoot(rootId, Generation.unstableGeneration(this.generation));
        this.layout = layout;
        this.pagedFile = this.openOrCreate(pageCache, indexFile, tentativePageSize, layout);
        this.bTreeNode = new TreeNode<KEY, VALUE>(this.pageSize, layout);
        this.freeList = new FreeListIdProvider(this.pagedFile, this.pageSize, rootId, FreeListIdProvider.NO_MONITOR);
        this.writer = new SingleWriter(new InternalTreeLogic<KEY, VALUE>(this.freeList, this.bTreeNode, layout));
        try {
            if (this.created) {
                this.initializeAfterCreation(layout);
            } else {
                this.loadState(this.pagedFile, headerReader);
            }
            this.monitor.startupState(this.clean);
            boolean needsCleaning = !this.clean;
            this.clean = false;
            this.bumpUnstableGeneration();
            this.forceState();
            this.cleaning = this.createCleanupJob(needsCleaning);
            recoveryCleanupWorkCollector.add(this.cleaning);
        }
        catch (Throwable t) {
            try {
                this.close();
            }
            catch (Throwable e) {
                t.addSuppressed(e);
            }
            throw t;
        }
    }

    private void initializeAfterCreation(Layout<KEY, VALUE> layout) throws IOException {
        this.writeMeta(layout, this.pagedFile);
        try (PageCursor cursor = this.pagedFile.io(0L, 2);){
            TreeStatePair.initializeStatePages(cursor);
        }
        cursor = this.openRootCursor(2);
        var3_3 = null;
        try {
            long stableGeneration = Generation.stableGeneration(this.generation);
            long unstableGeneration = Generation.unstableGeneration(this.generation);
            TreeNode.initializeLeaf(cursor, stableGeneration, unstableGeneration);
            PageCursorUtil.checkOutOfBounds(cursor);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (cursor != null) {
                if (var3_3 != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        this.freeList.initializeAfterCreation();
        this.changesSinceLastCheckpoint = true;
        this.checkpoint(IOLimiter.unlimited());
        this.clean = true;
    }

    private PagedFile openOrCreate(PageCache pageCache, File indexFile, int pageSizeForCreation, Layout<KEY, VALUE> layout) throws IOException {
        try {
            PagedFile pagedFile = pageCache.map(indexFile, pageCache.pageSize(), new OpenOption[0]);
            try {
                this.readMeta(indexFile, layout, pagedFile);
                pagedFile = this.mapWithCorrectPageSize(pageCache, indexFile, pagedFile);
                return pagedFile;
            }
            catch (Throwable t) {
                try {
                    pagedFile.close();
                }
                catch (IOException e) {
                    t.addSuppressed(e);
                }
                throw t;
            }
        }
        catch (NoSuchFileException e) {
            this.monitor.noStoreFile();
            int n = this.pageSize = pageSizeForCreation == 0 ? pageCache.pageSize() : pageSizeForCreation;
            if (this.pageSize > pageCache.pageSize()) {
                throw new MetadataMismatchException("Tree in " + indexFile.getAbsolutePath() + " was about to be created with page size:" + this.pageSize + ", but page cache used to create it has a smaller page size:" + pageCache.pageSize() + " so cannot be created");
            }
            PagedFile pagedFile = pageCache.map(indexFile, this.pageSize, new OpenOption[]{StandardOpenOption.CREATE});
            this.created = true;
            return pagedFile;
        }
    }

    private void loadState(PagedFile pagedFile, Header.Reader headerReader) throws IOException {
        Pair<TreeState, TreeState> states = GBPTree.readStatePages(pagedFile);
        TreeState state = TreeStatePair.selectNewestValidState(states);
        try (PageCursor cursor = pagedFile.io(state.pageId(), 1);){
            PageCursorUtil.goTo(cursor, "header data", state.pageId());
            GBPTree.readHeader(headerReader, cursor);
        }
        this.generation = Generation.generation(state.stableGeneration(), state.unstableGeneration());
        this.setRoot(state.rootId(), state.rootGeneration());
        long lastId = state.lastId();
        long freeListWritePageId = state.freeListWritePageId();
        long freeListReadPageId = state.freeListReadPageId();
        int freeListWritePos = state.freeListWritePos();
        int freeListReadPos = state.freeListReadPos();
        this.freeList.initialize(lastId, freeListWritePageId, freeListReadPageId, freeListWritePos, freeListReadPos);
        this.clean = state.isClean();
    }

    private static void readHeader(Header.Reader headerReader, PageCursor cursor) throws IOException {
        int headerDataLength;
        do {
            TreeState.read(cursor);
            headerDataLength = cursor.getInt();
        } while (cursor.shouldRetry());
        int headerDataOffset = cursor.getOffset();
        byte[] headerDataBytes = new byte[headerDataLength];
        do {
            cursor.setOffset(headerDataOffset);
            cursor.getBytes(headerDataBytes);
        } while (cursor.shouldRetry());
        headerReader.read(ByteBuffer.wrap(headerDataBytes));
    }

    private void writeState(PagedFile pagedFile, Header.Writer headerWriter) throws IOException {
        Pair<TreeState, TreeState> states = GBPTree.readStatePages(pagedFile);
        TreeState oldestState = TreeStatePair.selectOldestOrInvalid(states);
        long pageToOverwrite = oldestState.pageId();
        Root root = this.root;
        try (PageCursor cursor = pagedFile.io(pageToOverwrite, 2);){
            PageCursorUtil.goTo(cursor, "state page", pageToOverwrite);
            TreeState.write(cursor, Generation.stableGeneration(this.generation), Generation.unstableGeneration(this.generation), root.id(), root.generation(), this.freeList.lastId(), this.freeList.writePageId(), this.freeList.readPageId(), this.freeList.writePos(), this.freeList.readPos(), this.clean);
            GBPTree.writerHeader(pagedFile, headerWriter, GBPTree.other(states, oldestState), cursor);
            PageCursorUtil.checkOutOfBounds(cursor);
        }
    }

    private static void writerHeader(PagedFile pagedFile, Header.Writer headerWriter, TreeState otherState, PageCursor cursor) throws IOException {
        int headerOffset = cursor.getOffset();
        int headerDataOffset = headerOffset + 4;
        if (otherState.isValid()) {
            PageCursor previousCursor = pagedFile.io(otherState.pageId(), 1);
            PageCursorUtil.goTo(previousCursor, "previous state page", otherState.pageId());
            PageCursorUtil.checkOutOfBounds(cursor);
            do {
                cursor.checkAndClearBoundsFlag();
                TreeState.read(previousCursor);
                int previousLength = previousCursor.getInt();
                cursor.setOffset(headerDataOffset);
                headerWriter.write(previousCursor, previousLength, cursor);
            } while (previousCursor.shouldRetry());
            PageCursorUtil.checkOutOfBounds(previousCursor);
            PageCursorUtil.checkOutOfBounds(cursor);
            int length = cursor.getOffset() - headerDataOffset;
            cursor.putInt(headerOffset, length);
        }
    }

    private static TreeState other(Pair<TreeState, TreeState> states, TreeState state) {
        return states.getLeft() == state ? (TreeState)states.getRight() : (TreeState)states.getLeft();
    }

    private static Pair<TreeState, TreeState> readStatePages(PagedFile pagedFile) throws IOException {
        Pair<TreeState, TreeState> states;
        try (PageCursor cursor = pagedFile.io(0L, 1);){
            states = TreeStatePair.readStatePages(cursor, 1L, 2L);
        }
        return states;
    }

    private static PageCursor openMetaPageCursor(PagedFile pagedFile, int pfFlags) throws IOException {
        PageCursor metaCursor = pagedFile.io(0L, pfFlags);
        PageCursorUtil.goTo(metaCursor, "meta page", 0L);
        return metaCursor;
    }

    private void readMeta(File indexFile, Layout<KEY, VALUE> layout, PagedFile pagedFile) throws IOException {
        int minorVersion;
        int majorVersion;
        long layoutIdentifier;
        int formatVersion;
        try (PageCursor metaCursor = GBPTree.openMetaPageCursor(pagedFile, 1);){
            do {
                formatVersion = metaCursor.getInt();
                this.pageSize = metaCursor.getInt();
                layoutIdentifier = metaCursor.getLong();
                majorVersion = metaCursor.getInt();
                minorVersion = metaCursor.getInt();
                layout.readMetaData(metaCursor);
            } while (metaCursor.shouldRetry());
            PageCursorUtil.checkOutOfBounds(metaCursor);
            metaCursor.checkAndClearCursorException();
        }
        catch (CursorException e) {
            throw new MetadataMismatchException(String.format("Tried to open %s, but caught an error while reading meta data. File is expected to be corrupt, try to rebuild.", indexFile), new Object[]{e});
        }
        if (formatVersion != 2) {
            throw new MetadataMismatchException("Tried to open %s with a different format version than what it was created with. Created with:%d, opened with %d", indexFile, formatVersion, 2);
        }
        if (layoutIdentifier != layout.identifier()) {
            throw new MetadataMismatchException("Tried to open " + indexFile + " using different layout identifier than what it was created with. Created with:" + layoutIdentifier + ", opened with " + layout.identifier());
        }
        if (majorVersion != layout.majorVersion() || minorVersion != layout.minorVersion()) {
            throw new MetadataMismatchException("Tried to open " + indexFile + " using different layout version than what it was created with. Created with:" + majorVersion + "." + minorVersion + ", opened with " + layout.majorVersion() + "." + layout.minorVersion());
        }
    }

    private void writeMeta(Layout<KEY, VALUE> layout, PagedFile pagedFile) throws IOException {
        try (PageCursor metaCursor = GBPTree.openMetaPageCursor(pagedFile, 2);){
            metaCursor.putInt(2);
            metaCursor.putInt(this.pageSize);
            metaCursor.putLong(layout.identifier());
            metaCursor.putInt(layout.majorVersion());
            metaCursor.putInt(layout.minorVersion());
            layout.writeMetaData(metaCursor);
            PageCursorUtil.checkOutOfBounds(metaCursor);
        }
    }

    private PagedFile mapWithCorrectPageSize(PageCache pageCache, File indexFile, PagedFile pagedFile) throws IOException {
        if (this.pageSize != pageCache.pageSize()) {
            if (this.pageSize > pageCache.pageSize()) {
                throw new MetadataMismatchException("Tree in " + indexFile.getAbsolutePath() + " was created with page size:" + this.pageSize + ", but page cache used to open it this time has a smaller page size:" + pageCache.pageSize() + " so cannot be opened");
            }
            pagedFile.close();
            return pageCache.map(indexFile, this.pageSize, new OpenOption[0]);
        }
        return pagedFile;
    }

    private PageCursor openRootCursor(int pfFlags) throws IOException {
        PageCursor cursor = this.pagedFile.io(0L, pfFlags);
        this.root.goTo(cursor);
        return cursor;
    }

    public RawCursor<Hit<KEY, VALUE>, IOException> seek(KEY fromInclusive, KEY toExclusive) throws IOException {
        long generation = this.generation;
        long stableGeneration = Generation.stableGeneration(generation);
        long unstableGeneration = Generation.unstableGeneration(generation);
        PageCursor cursor = this.pagedFile.io(0L, 1);
        long rootGeneration = this.root.goTo(cursor);
        return new SeekCursor<KEY, VALUE>(cursor, this.bTreeNode, fromInclusive, toExclusive, this.layout, stableGeneration, unstableGeneration, this.generationSupplier, this.rootCatchup, rootGeneration);
    }

    public void checkpoint(IOLimiter ioLimiter, Consumer<PageCursor> headerWriter) throws IOException {
        this.checkpoint(ioLimiter, Header.replace(headerWriter));
    }

    public void checkpoint(IOLimiter ioLimiter) throws IOException {
        this.checkpoint(ioLimiter, Header.CARRY_OVER_PREVIOUS_HEADER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpoint(IOLimiter ioLimiter, Header.Writer headerWriter) throws IOException {
        if (!this.changesSinceLastCheckpoint && headerWriter == Header.CARRY_OVER_PREVIOUS_HEADER) {
            return;
        }
        this.pagedFile.flushAndForce(ioLimiter);
        this.lock.writerAndCleanerLock();
        try {
            this.assertRecoveryCleanSuccessful();
            this.pagedFile.flushAndForce();
            long unstableGeneration = Generation.unstableGeneration(this.generation);
            this.generation = Generation.generation(unstableGeneration, unstableGeneration + 1L);
            this.writeState(this.pagedFile, headerWriter);
            this.pagedFile.flushAndForce();
            this.monitor.checkpointCompleted();
            this.changesSinceLastCheckpoint = false;
        }
        finally {
            this.lock.writerAndCleanerUnlock();
        }
    }

    private void assertRecoveryCleanSuccessful() throws IOException {
        if (this.cleaning != null && this.cleaning.hasFailed()) {
            throw new IOException("Pointer cleaning during recovery failed", this.cleaning.getCause());
        }
    }

    @Override
    public void close() throws IOException {
        this.lock.writerLock();
        try {
            if (this.closed) {
                return;
            }
            this.internalIndexClose();
        }
        catch (IOException ioe) {
            try {
                this.pagedFile.flushAndForce();
                this.internalIndexClose();
            }
            catch (IOException e) {
                ioe.addSuppressed(e);
                throw ioe;
            }
        }
        finally {
            this.lock.writerUnlock();
        }
    }

    private void internalIndexClose() throws IOException {
        if (!this.changesSinceLastCheckpoint && !this.cleaning.needed()) {
            this.clean = true;
            this.forceState();
        }
        this.pagedFile.close();
        this.closed = true;
    }

    public Writer<KEY, VALUE> writer() throws IOException {
        this.assertRecoveryCleanSuccessful();
        this.writer.initialize();
        this.changesSinceLastCheckpoint = true;
        return this.writer;
    }

    private void setRoot(long rootId, long rootGeneration) {
        this.root = new Root(rootId, rootGeneration);
    }

    private void bumpUnstableGeneration() throws IOException {
        this.generation = Generation.generation(Generation.stableGeneration(this.generation), Generation.unstableGeneration(this.generation) + 1L);
    }

    private void forceState() throws IOException {
        if (this.changesSinceLastCheckpoint) {
            throw new IllegalStateException("It seems that this method has been called in the wrong state. It's expected that this is called after opening this tree, but before any changes have been made");
        }
        this.writeState(this.pagedFile, Header.CARRY_OVER_PREVIOUS_HEADER);
        this.pagedFile.flushAndForce();
    }

    private CleanupJob createCleanupJob(boolean needsCleaning) throws IOException {
        if (!needsCleaning) {
            return CleanupJob.CLEAN;
        }
        this.lock.cleanerLock();
        long generation = this.generation;
        long stableGeneration = Generation.stableGeneration(generation);
        long unstableGeneration = Generation.unstableGeneration(generation);
        long highTreeNodeId = this.freeList.lastId() + 1L;
        CrashGenerationCleaner crashGenerationCleaner = new CrashGenerationCleaner(this.pagedFile, this.bTreeNode, 3L, highTreeNodeId, stableGeneration, unstableGeneration, this.monitor);
        return new GBPTreeCleanupJob(crashGenerationCleaner, this.lock);
    }

    void printTree() throws IOException {
        this.printTree(true, true, true);
    }

    public void printTree(boolean printValues, boolean printPosition, boolean printState) throws IOException {
        try (PageCursor cursor = this.openRootCursor(1);){
            new TreePrinter<KEY, VALUE>(this.bTreeNode, this.layout, Generation.stableGeneration(this.generation), Generation.unstableGeneration(this.generation)).printTree(cursor, System.out, printValues, printPosition, printState);
        }
    }

    boolean consistencyCheck() throws IOException {
        try (PageCursor cursor = this.pagedFile.io(0L, 1);){
            long unstableGeneration = Generation.unstableGeneration(this.generation);
            ConsistencyChecker<KEY> consistencyChecker = new ConsistencyChecker<KEY>(this.bTreeNode, this.layout, Generation.stableGeneration(this.generation), unstableGeneration);
            long rootGeneration = this.root.goTo(cursor);
            boolean check = consistencyChecker.check(cursor, rootGeneration);
            this.root.goTo(cursor);
            PrimitiveLongSet freelistIds = Primitive.longSet();
            this.freeList.visitFreelistPageIds(arg_0 -> ((PrimitiveLongSet)freelistIds).add(arg_0));
            this.freeList.visitUnacquiredIds(arg_0 -> ((PrimitiveLongSet)freelistIds).add(arg_0), unstableGeneration);
            boolean checkSpace = consistencyChecker.checkSpace(cursor, this.freeList.lastId(), freelistIds.iterator());
            boolean bl = check & checkSpace;
            return bl;
        }
    }

    public String toString() {
        long generation = this.generation;
        return String.format("GB+Tree[file:%s, layout:%s, generation:%d/%d]", this.indexFile.getAbsolutePath(), this.layout, Generation.stableGeneration(generation), Generation.unstableGeneration(generation));
    }

    private TreeInconsistencyException appendTreeInformation(TreeInconsistencyException e) {
        return (TreeInconsistencyException)Exceptions.withMessage((Throwable)e, (String)(e.getMessage() + " | " + this.toString()));
    }

    private class SingleWriter
    implements Writer<KEY, VALUE> {
        private final AtomicBoolean writerTaken = new AtomicBoolean();
        private final InternalTreeLogic<KEY, VALUE> treeLogic;
        private final StructurePropagation<KEY> structurePropagation;
        private PageCursor cursor;
        private long stableGeneration;
        private long unstableGeneration;

        SingleWriter(InternalTreeLogic<KEY, VALUE> treeLogic) {
            this.structurePropagation = new StructurePropagation(GBPTree.this.layout.newKey(), GBPTree.this.layout.newKey(), GBPTree.this.layout.newKey());
            this.treeLogic = treeLogic;
        }

        void initialize() throws IOException {
            if (!this.writerTaken.compareAndSet(false, true)) {
                throw new IllegalStateException("Writer in " + this + " is already acquired by someone else. Only a single writer is allowed. The writer will become available as soon as acquired writer is closed");
            }
            boolean success = false;
            try {
                GBPTree.this.lock.writerLock();
                this.cursor = GBPTree.this.openRootCursor(2);
                this.stableGeneration = Generation.stableGeneration(GBPTree.this.generation);
                this.unstableGeneration = Generation.unstableGeneration(GBPTree.this.generation);
                PointerChecking.assertNoSuccessor(this.cursor, this.stableGeneration, this.unstableGeneration);
                this.treeLogic.initialize(this.cursor);
                success = true;
            }
            catch (TreeInconsistencyException e) {
                throw GBPTree.this.appendTreeInformation(e);
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        @Override
        public void put(KEY key, VALUE value) throws IOException {
            this.merge(key, value, ValueMergers.overwrite());
        }

        @Override
        public void merge(KEY key, VALUE value, ValueMerger<VALUE> valueMerger) throws IOException {
            try {
                this.treeLogic.insert(this.cursor, this.structurePropagation, key, value, valueMerger, this.stableGeneration, this.unstableGeneration);
            }
            catch (TreeInconsistencyException e) {
                throw GBPTree.this.appendTreeInformation(e);
            }
            if (this.structurePropagation.hasRightKeyInsert) {
                long newRootId = GBPTree.this.freeList.acquireNewId(this.stableGeneration, this.unstableGeneration);
                PageCursorUtil.goTo(this.cursor, "new root", newRootId);
                TreeNode.initializeInternal(this.cursor, this.stableGeneration, this.unstableGeneration);
                GBPTree.this.bTreeNode.insertKeyAt(this.cursor, this.structurePropagation.rightKey, 0, 0);
                TreeNode.setKeyCount(this.cursor, 1);
                GBPTree.this.bTreeNode.setChildAt(this.cursor, this.structurePropagation.midChild, 0, this.stableGeneration, this.unstableGeneration);
                GBPTree.this.bTreeNode.setChildAt(this.cursor, this.structurePropagation.rightChild, 1, this.stableGeneration, this.unstableGeneration);
                this.setRoot(newRootId);
            } else if (this.structurePropagation.hasMidChildUpdate) {
                this.setRoot(this.structurePropagation.midChild);
            }
            this.structurePropagation.clear();
            PageCursorUtil.checkOutOfBounds(this.cursor);
        }

        private void setRoot(long rootPointer) {
            long rootId = GenerationSafePointerPair.pointer(rootPointer);
            GBPTree.this.setRoot(rootId, this.unstableGeneration);
            this.treeLogic.initialize(this.cursor);
        }

        @Override
        public VALUE remove(KEY key) throws IOException {
            Object result;
            try {
                result = this.treeLogic.remove(this.cursor, this.structurePropagation, key, GBPTree.this.layout.newValue(), this.stableGeneration, this.unstableGeneration);
            }
            catch (TreeInconsistencyException e) {
                throw GBPTree.this.appendTreeInformation(e);
            }
            if (this.structurePropagation.hasMidChildUpdate) {
                this.setRoot(this.structurePropagation.midChild);
            }
            this.structurePropagation.clear();
            PageCursorUtil.checkOutOfBounds(this.cursor);
            return result;
        }

        @Override
        public void close() throws IOException {
            if (!this.writerTaken.compareAndSet(true, false)) {
                throw new IllegalStateException("Tried to close writer of " + GBPTree.this + ", but writer is already closed.");
            }
            this.closeCursor();
            GBPTree.this.lock.writerUnlock();
        }

        private void closeCursor() {
            if (this.cursor != null) {
                this.cursor.close();
                this.cursor = null;
            }
        }
    }

    public static interface Monitor {
        public void checkpointCompleted();

        public void noStoreFile();

        public void cleanupFinished(long var1, long var3, long var5);

        public void startupState(boolean var1);

        public static class Adaptor
        implements Monitor {
            @Override
            public void checkpointCompleted() {
            }

            @Override
            public void noStoreFile() {
            }

            @Override
            public void cleanupFinished(long numberOfPagesVisited, long numberOfCleanedCrashPointers, long durationMillis) {
            }

            @Override
            public void startupState(boolean clean) {
            }
        }
    }
}

