/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.io.pagecache.PageCursor;

class PageCursorUtil {
    static final int _2B_MASK = 65535;
    static final long _4B_MASK = 0xFFFFFFFFL;
    static final long _6B_MASK = 0xFFFFFFFFFFFFL;

    private PageCursorUtil() {
    }

    static void put6BLong(PageCursor cursor, long value) {
        if ((value & 0xFFFF000000000000L) != 0L) {
            throw new IllegalArgumentException("Illegal 6B value " + value);
        }
        int lsb = (int)value;
        short msb = (short)(value >>> 32);
        cursor.putInt(lsb);
        cursor.putShort(msb);
    }

    static long get6BLong(PageCursor cursor) {
        long lsb = PageCursorUtil.getUnsignedInt(cursor);
        long msb = PageCursorUtil.getUnsignedShort(cursor);
        return lsb | msb << 32;
    }

    static int getUnsignedShort(PageCursor cursor) {
        return cursor.getShort() & 0xFFFF;
    }

    static long getUnsignedInt(PageCursor cursor) {
        return (long)cursor.getInt() & 0xFFFFFFFFL;
    }

    static void checkOutOfBounds(PageCursor cursor) {
        if (cursor.checkAndClearBoundsFlag()) {
            throw new TreeInconsistencyException("Some internal problem causing out of bounds: pageId:" + cursor.getCurrentPageId());
        }
    }

    static void goTo(PageCursor cursor, String messageOnError, long pageId) throws IOException {
        if (!cursor.next(pageId)) {
            throw new IllegalStateException("Could not go to page:" + pageId + " [" + messageOnError + "]");
        }
    }
}

