/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.concurrent.locks.StampedLock;
import org.neo4j.index.internal.gbptree.CleanupJob;
import org.neo4j.index.internal.gbptree.CrashGenerationCleaner;

class GBPTreeCleanupJob
implements CleanupJob {
    private final CrashGenerationCleaner crashGenerationCleaner;
    private final StampedLock stampedLock;
    private final long stamp;
    private volatile boolean needed;
    private volatile Exception failure;

    GBPTreeCleanupJob(CrashGenerationCleaner crashGenerationCleaner, StampedLock lock, long stamp) {
        this.crashGenerationCleaner = crashGenerationCleaner;
        this.stampedLock = lock;
        this.stamp = stamp;
        this.needed = true;
    }

    @Override
    public boolean needed() {
        return this.needed;
    }

    @Override
    public boolean hasFailed() {
        return this.failure != null;
    }

    @Override
    public Exception getCause() {
        return this.failure;
    }

    @Override
    public void run() {
        try {
            this.crashGenerationCleaner.clean();
            this.needed = false;
        }
        catch (IOException e) {
            this.failure = e;
        }
        finally {
            this.stampedLock.unlockWrite(this.stamp);
        }
    }
}

