/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.GenSafePointerPair;
import org.neo4j.index.internal.gbptree.Generation;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.KeySearch;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.PageCursor;

class SeekCursor<KEY, VALUE>
implements RawCursor<Hit<KEY, VALUE>, IOException>,
Hit<KEY, VALUE> {
    private final PageCursor cursor;
    private final KEY mutableKey;
    private final VALUE mutableValue;
    private final KEY fromInclusive;
    private final KEY toExclusive;
    private final Layout<KEY, VALUE> layout;
    private final TreeNode<KEY, VALUE> bTreeNode;
    private final KEY prevKey;
    private final LongSupplier generationSupplier;
    private final Supplier<Root> rootCatchup;
    private final int maxKeyCount;
    private boolean first = true;
    private long stableGeneration;
    private long unstableGeneration;
    private int pos;
    private int keyCount;
    private boolean concurrentWriteHappened;
    private long currentNodeGen;
    private long lastFollowedPointerGen;
    private long expectedCurrentNodeGen;
    private final boolean seekForward;
    private final int stride;
    private byte nodeType;
    private long newGen;
    private long newGenGen;
    private boolean isInternal;
    private long pointerId;
    private long pointerGen;
    private int searchResult;
    private long prevSiblingId;
    private long prevSiblingGen;
    private final KEY expectedFirstAfterGoToNext;
    private final KEY firstKeyInNode;
    private boolean verifyExpectedFirstAfterGoToNext;

    SeekCursor(PageCursor cursor, TreeNode<KEY, VALUE> bTreeNode, KEY fromInclusive, KEY toExclusive, Layout<KEY, VALUE> layout, long stableGeneration, long unstableGeneration, LongSupplier generationSupplier, Supplier<Root> rootCatchup, long lastFollowedPointerGen) throws IOException {
        this.cursor = cursor;
        this.fromInclusive = fromInclusive;
        this.toExclusive = toExclusive;
        this.layout = layout;
        this.stableGeneration = stableGeneration;
        this.unstableGeneration = unstableGeneration;
        this.generationSupplier = generationSupplier;
        this.bTreeNode = bTreeNode;
        this.rootCatchup = rootCatchup;
        this.lastFollowedPointerGen = lastFollowedPointerGen;
        this.mutableKey = layout.newKey();
        this.mutableValue = layout.newValue();
        this.prevKey = layout.newKey();
        this.maxKeyCount = Integer.max(bTreeNode.internalMaxKeyCount(), bTreeNode.leafMaxKeyCount());
        this.seekForward = layout.compare(fromInclusive, toExclusive) <= 0;
        this.stride = this.seekForward ? 1 : -1;
        this.expectedFirstAfterGoToNext = layout.newKey();
        this.firstKeyInNode = layout.newKey();
        this.traverseDownToFirstLeaf();
    }

    private void traverseDownToFirstLeaf() throws IOException {
        while (true) {
            if (this.readHeader()) {
                this.searchResult = this.searchKey(this.fromInclusive);
                if (KeySearch.isSuccess(this.searchResult)) {
                    this.pos = this.positionOf(this.searchResult);
                    if (this.isInternal) {
                        this.pointerId = this.bTreeNode.childAt(this.cursor, this.pos, this.stableGeneration, this.unstableGeneration);
                        this.pointerGen = this.readPointerGenOnSuccess(this.pointerId);
                    }
                }
            }
            if (this.cursor.shouldRetry()) continue;
            PageCursorUtil.checkOutOfBounds(this.cursor);
            if (!this.endedUpOnExpectedNode()) {
                this.prepareToStartFromRoot();
                this.isInternal = true;
            } else {
                if (!this.saneRead()) {
                    throw new TreeInconsistencyException("Read inconsistent tree node %d%n  nodeType:%d%n  currentNodeGen:%d%n  newGen:%d%n  newGenGen:%d%n  isInternal:%b%n  keyCount:%d%n  maxKeyCount:%d%n  searchResult:%d%n  pos:%d%n  childId:%d%n  childIdGen:%d", this.cursor.getCurrentPageId(), this.nodeType, this.currentNodeGen, this.newGen, this.newGenGen, this.isInternal, this.keyCount, this.maxKeyCount, this.searchResult, this.pos, this.pointerId, this.pointerGen);
                }
                if (!this.goToNewGen() && this.isInternal) {
                    this.goTo(this.pointerId, this.pointerGen, "child", false);
                }
            }
            if (!this.isInternal) break;
        }
        this.pos -= this.stride;
        if (!this.seekForward) {
            this.concurrentWriteHappened = true;
        }
    }

    public boolean next() throws IOException {
        block11: {
            while (true) {
                this.pos += this.stride;
                do {
                    if (!this.readHeader()) continue;
                    if (this.verifyExpectedFirstAfterGoToNext) {
                        this.pos = this.seekForward ? 0 : this.keyCount - 1;
                        this.bTreeNode.keyAt(this.cursor, this.firstKeyInNode, this.pos);
                    }
                    if (this.concurrentWriteHappened) {
                        this.searchResult = this.searchKey(this.first ? this.fromInclusive : this.prevKey);
                        if (!KeySearch.isSuccess(this.searchResult)) continue;
                        this.pos = this.positionOf(this.searchResult);
                        if (!this.seekForward && this.pos >= this.keyCount) {
                            this.prevSiblingId = this.readPrevSibling();
                            this.prevSiblingGen = this.readPointerGenOnSuccess(this.prevSiblingId);
                        }
                    }
                    if (this.seekForward && this.pos >= this.keyCount || !this.seekForward && this.pos <= 0) {
                        this.pointerId = this.readNextSibling();
                        this.pointerGen = this.readPointerGenOnSuccess(this.pointerId);
                    }
                    if (0 > this.pos || this.pos >= this.keyCount) continue;
                    this.bTreeNode.keyAt(this.cursor, this.mutableKey, this.pos);
                    this.bTreeNode.valueAt(this.cursor, this.mutableValue, this.pos);
                } while (this.concurrentWriteHappened = this.cursor.shouldRetry());
                PageCursorUtil.checkOutOfBounds(this.cursor);
                if (!this.endedUpOnExpectedNode()) {
                    this.prepareToStartFromRoot();
                    this.traverseDownToFirstLeaf();
                    continue;
                }
                if (!this.saneRead()) {
                    throw new TreeInconsistencyException("Read inconsistent tree node %d%n  nodeType:%d%n  currentNodeGen:%d%n  newGen:%d%n  newGenGen:%d%n  keyCount:%d%n  maxKeyCount:%d%n  searchResult:%d%n  pos:%d%n  rightSibling:%d%n  rightSiblingGen:%d", this.cursor.getCurrentPageId(), this.nodeType, this.currentNodeGen, this.newGen, this.newGenGen, this.keyCount, this.maxKeyCount, this.searchResult, this.pos, this.pointerId, this.pointerGen);
                }
                if (!this.verifyFirstKeyInNodeIsExpectedAfterGoTo() || this.goToNewGen()) continue;
                if (!this.seekForward && this.pos >= this.keyCount) {
                    this.goTo(this.prevSiblingId, this.prevSiblingGen, "prev sibling", true);
                    continue;
                }
                if (this.seekForward && this.pos >= this.keyCount || !this.seekForward && this.pos <= 0 && !this.insidePrevKey()) {
                    if (this.goToNextSibling()) {
                        continue;
                    }
                    break block11;
                }
                if (0 > this.pos || this.pos >= this.keyCount || !this.insideEndRange()) break block11;
                if (this.isResultKey()) break;
            }
            this.layout.copyKey(this.mutableKey, this.prevKey);
            return true;
        }
        return false;
    }

    private boolean insideEndRange() {
        return this.seekForward ? this.layout.compare(this.mutableKey, this.toExclusive) < 0 : this.layout.compare(this.mutableKey, this.toExclusive) > 0;
    }

    private boolean insideStartRange() {
        return this.seekForward ? this.layout.compare(this.mutableKey, this.fromInclusive) >= 0 : this.layout.compare(this.mutableKey, this.fromInclusive) <= 0;
    }

    private boolean insidePrevKey() {
        if (this.first) {
            return this.insideStartRange();
        }
        return this.seekForward ? this.layout.compare(this.mutableKey, this.prevKey) > 0 : this.layout.compare(this.mutableKey, this.prevKey) < 0;
    }

    private boolean goTo(long pointerId, long pointerGen, String type, boolean allowNoNode) throws IOException {
        if (this.pointerCheckingWithGenerationCatchup(pointerId, allowNoNode)) {
            this.concurrentWriteHappened = true;
            return true;
        }
        if (!allowNoNode || TreeNode.isNode(pointerId)) {
            this.bTreeNode.goTo(this.cursor, type, pointerId);
            this.lastFollowedPointerGen = pointerGen;
            this.concurrentWriteHappened = true;
            return true;
        }
        return false;
    }

    private boolean goToNewGen() throws IOException {
        return this.goTo(this.newGen, this.newGenGen, "new gen", true);
    }

    private long readPointerGenOnSuccess(long pointerId) {
        if (GenSafePointerPair.isSuccess(pointerId)) {
            return this.bTreeNode.pointerGen(this.cursor, pointerId);
        }
        return -1L;
    }

    private boolean verifyFirstKeyInNodeIsExpectedAfterGoTo() {
        boolean result = true;
        if (this.verifyExpectedFirstAfterGoToNext && this.layout.compare(this.firstKeyInNode, this.expectedFirstAfterGoToNext) != 0) {
            this.concurrentWriteHappened = true;
            result = false;
        }
        this.verifyExpectedFirstAfterGoToNext = false;
        return result;
    }

    private long readPrevSibling() {
        return this.seekForward ? this.bTreeNode.leftSibling(this.cursor, this.stableGeneration, this.unstableGeneration) : this.bTreeNode.rightSibling(this.cursor, this.stableGeneration, this.unstableGeneration);
    }

    private long readNextSibling() {
        return this.seekForward ? this.bTreeNode.rightSibling(this.cursor, this.stableGeneration, this.unstableGeneration) : this.bTreeNode.leftSibling(this.cursor, this.stableGeneration, this.unstableGeneration);
    }

    private int searchKey(KEY key) {
        return KeySearch.search(this.cursor, this.bTreeNode, key, this.mutableKey, this.keyCount);
    }

    private int positionOf(int searchResult) {
        int pos = KeySearch.positionOf(searchResult);
        if (this.isInternal && KeySearch.isHit(searchResult)) {
            ++pos;
        }
        return pos;
    }

    private boolean readHeader() {
        this.nodeType = TreeNode.nodeType(this.cursor);
        if (this.nodeType != 1) {
            return false;
        }
        this.currentNodeGen = this.bTreeNode.gen(this.cursor);
        this.newGen = this.bTreeNode.newGen(this.cursor, this.stableGeneration, this.unstableGeneration);
        if (GenSafePointerPair.isSuccess(this.newGen)) {
            this.newGenGen = this.bTreeNode.pointerGen(this.cursor, this.newGen);
        }
        this.isInternal = TreeNode.isInternal(this.cursor);
        this.keyCount = this.bTreeNode.keyCount(this.cursor);
        return this.keyCountIsSane(this.keyCount);
    }

    private boolean endedUpOnExpectedNode() {
        return this.nodeType == 1 && this.verifyNodeGenInvariants();
    }

    public Hit<KEY, VALUE> get() {
        if (this.first) {
            throw new IllegalStateException("There has been no successful call to next() yet");
        }
        return this;
    }

    private boolean goToNextSibling() throws IOException {
        if (this.pointerCheckingWithGenerationCatchup(this.pointerId, true)) {
            this.concurrentWriteHappened = true;
            return true;
        }
        if (TreeNode.isNode(this.pointerId)) {
            if (this.seekForward) {
                this.bTreeNode.goTo(this.cursor, "sibling", this.pointerId);
                this.lastFollowedPointerGen = this.pointerGen;
                if (this.first) {
                    this.concurrentWriteHappened = true;
                } else {
                    this.pos = -1;
                }
                return true;
            }
            if (this.scoutNextSibling()) {
                this.bTreeNode.goTo(this.cursor, "sibling", this.pointerId);
                this.verifyExpectedFirstAfterGoToNext = true;
                this.lastFollowedPointerGen = this.pointerGen;
            } else {
                this.concurrentWriteHappened = true;
            }
            return true;
        }
        return false;
    }

    private boolean scoutNextSibling() throws IOException {
        byte nodeType;
        int keyCount = -1;
        try (PageCursor scout = this.cursor.openLinkedCursor(GenSafePointerPair.pointer(this.pointerId));){
            scout.next();
            nodeType = TreeNode.nodeType(scout);
            if (nodeType == 1 && this.keyCountIsSane(keyCount = this.bTreeNode.keyCount(scout))) {
                int firstPos = this.seekForward ? 0 : keyCount - 1;
                this.bTreeNode.keyAt(scout, this.expectedFirstAfterGoToNext, firstPos);
            }
            if (this.cursor.shouldRetry()) {
                boolean bl = false;
                return bl;
            }
            PageCursorUtil.checkOutOfBounds(this.cursor);
        }
        return nodeType == 1 && this.keyCountIsSane(keyCount);
    }

    private boolean isResultKey() {
        if (!this.insideStartRange()) {
            this.concurrentWriteHappened = true;
            return false;
        }
        if (!this.first && !this.insidePrevKey()) {
            return false;
        }
        if (this.first) {
            this.first = false;
        }
        return true;
    }

    private boolean keyCountIsSane(int keyCount) {
        return keyCount >= 0 && keyCount <= this.maxKeyCount;
    }

    private boolean saneRead() {
        return this.keyCountIsSane(this.keyCount) && KeySearch.isSuccess(this.searchResult);
    }

    private void prepareToStartFromRoot() throws IOException {
        this.generationCatchup();
        this.lastFollowedPointerGen = this.rootCatchup.get().goTo(this.cursor);
        if (!this.first) {
            this.layout.copyKey(this.prevKey, this.fromInclusive);
        }
    }

    private boolean verifyNodeGenInvariants() {
        if (this.lastFollowedPointerGen != 0L) {
            if (this.currentNodeGen > this.lastFollowedPointerGen) {
                return false;
            }
            this.lastFollowedPointerGen = 0L;
            this.expectedCurrentNodeGen = this.currentNodeGen;
        } else if (this.currentNodeGen != this.expectedCurrentNodeGen) {
            return false;
        }
        return true;
    }

    private boolean pointerCheckingWithGenerationCatchup(long pointer, boolean allowNoNode) {
        if (!GenSafePointerPair.isSuccess(pointer)) {
            if (this.generationCatchup()) {
                return true;
            }
            PointerChecking.checkPointer(pointer, allowNoNode);
        }
        return false;
    }

    private boolean generationCatchup() {
        long newGeneration = this.generationSupplier.getAsLong();
        long newStableGeneration = Generation.stableGeneration(newGeneration);
        long newUnstableGeneration = Generation.unstableGeneration(newGeneration);
        if (newStableGeneration != this.stableGeneration || newUnstableGeneration != this.unstableGeneration) {
            this.stableGeneration = newStableGeneration;
            this.unstableGeneration = newUnstableGeneration;
            return true;
        }
        return false;
    }

    @Override
    public KEY key() {
        return this.mutableKey;
    }

    @Override
    public VALUE value() {
        return this.mutableValue;
    }

    public void close() {
        this.cursor.close();
    }
}

