/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.io.pagecache.PageCursor;

class RightmostInChain {
    private long currentRightmostNode = 0L;
    private long currentRightmostRightSiblingPointer = 0L;
    private long currentRightmostRightSiblingPointerGen;
    private long currentRightmostNodeGen;

    RightmostInChain() {
    }

    void assertNext(PageCursor cursor, long newRightmostNodeGen, long newRightmostLeftSiblingPointer, long newRightmostLeftSiblingPointerGen, long newRightmostRightSiblingPointer, long newRightmostRightSiblingPointerGen) {
        String errorMessage;
        long newRightmostNode = cursor.getCurrentPageId();
        StringBuilder errorMessageBuilder = new StringBuilder();
        if (newRightmostLeftSiblingPointer != this.currentRightmostNode) {
            errorMessageBuilder.append(String.format("Sibling pointer does align with tree structure%n", new Object[0]));
        }
        if (this.currentRightmostNodeGen > newRightmostLeftSiblingPointerGen && this.currentRightmostNode != 0L) {
            errorMessageBuilder.append(String.format("Sibling pointer gen differs from expected%n", new Object[0]));
        }
        if (newRightmostNode != this.currentRightmostRightSiblingPointer && (this.currentRightmostRightSiblingPointer != 0L || this.currentRightmostNode != 0L)) {
            errorMessageBuilder.append(String.format("Sibling pointer does not align with tree structure%n", new Object[0]));
        }
        if (this.currentRightmostRightSiblingPointerGen < newRightmostNodeGen && this.currentRightmostRightSiblingPointer != 0L) {
            errorMessageBuilder.append(String.format("Sibling pointer gen differs from expected%n", new Object[0]));
        }
        if (!(errorMessage = errorMessageBuilder.toString()).equals("")) {
            this.setPatternException(cursor, newRightmostNodeGen, newRightmostLeftSiblingPointer, newRightmostLeftSiblingPointerGen, newRightmostNode, errorMessage);
        }
        this.currentRightmostNode = newRightmostNode;
        this.currentRightmostNodeGen = newRightmostNodeGen;
        this.currentRightmostRightSiblingPointer = newRightmostRightSiblingPointer;
        this.currentRightmostRightSiblingPointerGen = newRightmostRightSiblingPointerGen;
    }

    private void setPatternException(PageCursor cursor, long newRightmostGen, long leftSibling, long leftSiblingGen, long newRightmost, String errorMessage) {
        cursor.setCursorException(String.format("%s  Left siblings view:  %s%n  Right siblings view: %s%n", errorMessage, this.leftPattern(this.currentRightmostNode, this.currentRightmostNodeGen, this.currentRightmostRightSiblingPointerGen, this.currentRightmostRightSiblingPointer), this.rightPattern(newRightmost, newRightmostGen, leftSiblingGen, leftSibling)));
    }

    private String leftPattern(long actualLeftSibling, long actualLeftSiblingGen, long expectedRightSiblingGen, long expectedRightSibling) {
        return String.format("{%d(%d)}-(%d)->{%d}", actualLeftSibling, actualLeftSiblingGen, expectedRightSiblingGen, expectedRightSibling);
    }

    private String rightPattern(long actualRightSibling, long actualRightSiblingGen, long expectedLeftSiblingGen, long expectedLeftSibling) {
        return String.format("{%d}<-(%d)-{%d(%d)}", expectedLeftSibling, expectedLeftSiblingGen, actualRightSibling, actualRightSiblingGen);
    }

    void assertLast() {
        assert (this.currentRightmostRightSiblingPointer == 0L) : "Expected rightmost right sibling to be 0 but was " + this.currentRightmostRightSiblingPointer;
    }
}

