/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.index.internal.gbptree.GenSafePointer;
import org.neo4j.index.internal.gbptree.GenSafePointerPair;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.RightmostInChain;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;

class ConsistencyChecker<KEY> {
    private final TreeNode<KEY, ?> node;
    private final KEY readKey;
    private final Comparator<KEY> comparator;
    private final Layout<KEY, ?> layout;
    private final List<RightmostInChain> rightmostPerLevel = new ArrayList<RightmostInChain>();
    private final long stableGeneration;
    private final long unstableGeneration;

    ConsistencyChecker(TreeNode<KEY, ?> node, Layout<KEY, ?> layout, long stableGeneration, long unstableGeneration) {
        this.node = node;
        this.readKey = layout.newKey();
        this.comparator = node.keyComparator();
        this.layout = layout;
        this.stableGeneration = stableGeneration;
        this.unstableGeneration = unstableGeneration;
    }

    public boolean check(PageCursor cursor, long expectedGen) throws IOException {
        ConsistencyChecker.assertOnTreeNode(cursor);
        KeyRange openRange = new KeyRange(this.comparator, null, null, this.layout, null);
        boolean result = this.checkSubtree(cursor, openRange, expectedGen, 0);
        this.rightmostPerLevel.forEach(RightmostInChain::assertLast);
        return result;
    }

    public boolean checkSpace(PageCursor cursor, long lastId, PrimitiveLongIterator freelistIds) throws IOException {
        ConsistencyChecker.assertOnTreeNode(cursor);
        long highId = lastId + 1L;
        BitSet seenIds = new BitSet(Math.toIntExact(highId));
        while (freelistIds.hasNext()) {
            ConsistencyChecker.addToSeenList(seenIds, freelistIds.next(), lastId);
        }
        do {
            long leftmostSibling = cursor.getCurrentPageId();
            ConsistencyChecker.addToSeenList(seenIds, leftmostSibling, lastId);
            this.traverseAndAddRightSiblings(cursor, seenIds, lastId);
            this.node.goTo(cursor, "back", leftmostSibling);
        } while (this.goToLeftmostChild(cursor));
        ConsistencyChecker.assertAllIdsOccupied(highId, seenIds);
        return true;
    }

    private boolean goToLeftmostChild(PageCursor cursor) throws IOException {
        boolean isInternal;
        long leftmostSibling = -1L;
        do {
            isInternal = TreeNode.isInternal(cursor);
            if (!isInternal) continue;
            leftmostSibling = this.node.childAt(cursor, 0, this.stableGeneration, this.unstableGeneration);
        } while (cursor.shouldRetry());
        if (isInternal) {
            this.node.goTo(cursor, "child", leftmostSibling);
        }
        return isInternal;
    }

    private static void assertAllIdsOccupied(long highId, BitSet seenIds) {
        long expectedNumberOfPages = highId - 3L;
        if ((long)seenIds.cardinality() != expectedNumberOfPages) {
            StringBuilder builder = new StringBuilder("[");
            int index = 3;
            int count = 0;
            while (index >= 0 && (long)index < highId) {
                if ((index = seenIds.nextClearBit(index)) == -1) continue;
                if (count++ > 0) {
                    builder.append(",");
                }
                builder.append(index);
                ++index;
            }
            builder.append("]");
            throw new RuntimeException("There are " + count + " unused pages in the store:" + builder);
        }
    }

    private void traverseAndAddRightSiblings(PageCursor cursor, BitSet seenIds, long lastId) throws IOException {
        while (true) {
            long rightSibling = this.node.rightSibling(cursor, this.stableGeneration, this.unstableGeneration);
            if (cursor.shouldRetry()) continue;
            if (TreeNode.isNode(rightSibling)) {
                this.node.goTo(cursor, "right sibling", rightSibling);
                ConsistencyChecker.addToSeenList(seenIds, GenSafePointerPair.pointer(rightSibling), lastId);
            }
            if (!TreeNode.isNode(rightSibling)) break;
        }
    }

    private static void addToSeenList(BitSet target, long id, long lastId) {
        int index = Math.toIntExact(id);
        if (target.get(index)) {
            throw new IllegalStateException(id + " already seen");
        }
        if (id > lastId) {
            throw new IllegalStateException("Unexpectedly high id " + id + " seen when last id is " + lastId);
        }
        target.set(index);
    }

    static void assertOnTreeNode(PageCursor cursor) throws IOException {
        boolean isLeaf;
        boolean isInternal;
        byte nodeType;
        do {
            nodeType = TreeNode.nodeType(cursor);
            isInternal = TreeNode.isInternal(cursor);
            isLeaf = TreeNode.isLeaf(cursor);
        } while (cursor.shouldRetry());
        if (nodeType != 1) {
            throw new IllegalArgumentException("Cursor is not pinned to a tree node page. pageId:" + cursor.getCurrentPageId());
        }
        if (!isInternal && !isLeaf) {
            throw new IllegalArgumentException("Cursor is not pinned to a page containing a tree node. pageId:" + cursor.getCurrentPageId());
        }
    }

    private boolean checkSubtree(PageCursor cursor, KeyRange<KEY> range, long expectedGen, int level) throws IOException {
        int keyCount;
        long newGenGen;
        long newGen;
        long currentNodeGen;
        long rightSiblingPointerGen;
        long leftSiblingPointerGen;
        long rightSiblingPointer;
        long leftSiblingPointer;
        boolean isInternal = false;
        boolean isLeaf = false;
        do {
            ConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(cursor, this.stableGeneration, this.unstableGeneration, "LeftSibling", 34, this.node);
            ConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(cursor, this.stableGeneration, this.unstableGeneration, "RightSibling", 10, this.node);
            ConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(cursor, this.stableGeneration, this.unstableGeneration, "NewGen", 58, this.node);
            leftSiblingPointer = this.node.leftSibling(cursor, this.stableGeneration, this.unstableGeneration);
            rightSiblingPointer = this.node.rightSibling(cursor, this.stableGeneration, this.unstableGeneration);
            leftSiblingPointerGen = this.node.pointerGen(cursor, leftSiblingPointer);
            rightSiblingPointerGen = this.node.pointerGen(cursor, rightSiblingPointer);
            leftSiblingPointer = GenSafePointerPair.pointer(leftSiblingPointer);
            rightSiblingPointer = GenSafePointerPair.pointer(rightSiblingPointer);
            currentNodeGen = this.node.gen(cursor);
            newGen = this.node.newGen(cursor, this.stableGeneration, this.unstableGeneration);
            newGenGen = this.node.pointerGen(cursor, newGen);
            keyCount = this.node.keyCount(cursor);
            if (keyCount > this.node.internalMaxKeyCount() && keyCount > this.node.leafMaxKeyCount()) {
                cursor.setCursorException("Unexpected keyCount:" + keyCount);
                continue;
            }
            this.assertKeyOrder(cursor, range, keyCount);
            isInternal = TreeNode.isInternal(cursor);
            isLeaf = TreeNode.isLeaf(cursor);
        } while (cursor.shouldRetry());
        ConsistencyChecker.checkAfterShouldRetry(cursor);
        if (!isInternal && !isLeaf) {
            throw new TreeInconsistencyException("Page:" + cursor.getCurrentPageId() + " at level:" + level + " isn't a tree node, parent expected range " + range);
        }
        ConsistencyChecker.assertPointerGenMatchesGen(cursor, currentNodeGen, expectedGen);
        this.assertSiblings(cursor, currentNodeGen, leftSiblingPointer, leftSiblingPointerGen, rightSiblingPointer, rightSiblingPointerGen, level);
        this.checkNewGenPointerGen(cursor, newGen, newGenGen);
        if (isInternal) {
            this.assertSubtrees(cursor, range, keyCount, level);
        }
        return true;
    }

    private static void assertPointerGenMatchesGen(PageCursor cursor, long nodeGen, long expectedGen) {
        assert (nodeGen <= expectedGen) : "Expected node:" + cursor.getCurrentPageId() + " gen:" + nodeGen + " to be \u2264 pointer gen:" + expectedGen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNewGenPointerGen(PageCursor cursor, long newGen, long newGenGen) throws IOException {
        if (TreeNode.isNode(newGen)) {
            cursor.setCursorException("WARNING: we ended up on an old generation " + cursor.getCurrentPageId() + " which had newGen:" + GenSafePointerPair.pointer(newGen));
            long origin = cursor.getCurrentPageId();
            this.node.goTo(cursor, "newGen", newGen);
            try {
                long nodeGen;
                do {
                    nodeGen = this.node.gen(cursor);
                } while (cursor.shouldRetry());
                ConsistencyChecker.assertPointerGenMatchesGen(cursor, nodeGen, newGenGen);
            }
            finally {
                this.node.goTo(cursor, "back", origin);
            }
        }
    }

    private void assertSiblings(PageCursor cursor, long currentNodeGen, long leftSiblingPointer, long leftSiblingPointerGen, long rightSiblingPointer, long rightSiblingPointerGen, int level) {
        for (int i = this.rightmostPerLevel.size(); i <= level; ++i) {
            this.rightmostPerLevel.add(i, new RightmostInChain());
        }
        RightmostInChain rightmost = this.rightmostPerLevel.get(level);
        rightmost.assertNext(cursor, currentNodeGen, leftSiblingPointer, leftSiblingPointerGen, rightSiblingPointer, rightSiblingPointerGen);
    }

    private void assertSubtrees(PageCursor cursor, KeyRange<KEY> range, int keyCount, int level) throws IOException {
        KeyRange<KEY> childRange;
        long childGen;
        long child;
        int pos;
        long pageId = cursor.getCurrentPageId();
        KEY prev = this.layout.newKey();
        for (pos = 0; pos < keyCount; ++pos) {
            do {
                child = this.childAt(cursor, pos);
                childGen = this.node.pointerGen(cursor, child);
                this.node.keyAt(cursor, this.readKey, pos);
            } while (cursor.shouldRetry());
            ConsistencyChecker.checkAfterShouldRetry(cursor);
            childRange = range.restrictRight(this.readKey);
            if (pos > 0) {
                childRange = range.restrictLeft(prev);
            }
            this.node.goTo(cursor, "child at pos " + pos, child);
            this.checkSubtree(cursor, childRange, childGen, level + 1);
            this.node.goTo(cursor, "parent", pageId);
            this.layout.copyKey(this.readKey, prev);
        }
        do {
            child = this.childAt(cursor, pos);
            childGen = this.node.pointerGen(cursor, child);
        } while (cursor.shouldRetry());
        ConsistencyChecker.checkAfterShouldRetry(cursor);
        this.node.goTo(cursor, "child at pos " + pos, child);
        childRange = range.restrictLeft(prev);
        this.checkSubtree(cursor, childRange, childGen, level + 1);
        this.node.goTo(cursor, "parent", pageId);
    }

    private static void checkAfterShouldRetry(PageCursor cursor) throws CursorException {
        PageCursorUtil.checkOutOfBounds(cursor);
        cursor.checkAndClearCursorException();
    }

    private long childAt(PageCursor cursor, int pos) {
        ConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(cursor, this.stableGeneration, this.unstableGeneration, "Child", this.node.childOffset(pos), this.node);
        return this.node.childAt(cursor, pos, this.stableGeneration, this.unstableGeneration);
    }

    private void assertKeyOrder(PageCursor cursor, KeyRange<KEY> range, int keyCount) {
        KEY prev = this.layout.newKey();
        boolean first = true;
        for (int pos = 0; pos < keyCount; ++pos) {
            this.node.keyAt(cursor, this.readKey, pos);
            if (!range.inRange(this.readKey)) {
                cursor.setCursorException("Expected range for this node is " + range + " but found " + this.readKey + " in position " + pos + ", with key count " + keyCount);
            }
            if (!first) {
                if (this.comparator.compare(prev, this.readKey) >= 0) {
                    cursor.setCursorException("Non-unique key " + this.readKey);
                }
            } else {
                first = false;
            }
            this.layout.copyKey(this.readKey, prev);
        }
    }

    static void assertNoCrashOrBrokenPointerInGSPP(PageCursor cursor, long stableGeneration, long unstableGeneration, String pointerFieldName, int offset, TreeNode<?, ?> treeNode) {
        boolean okB;
        cursor.setOffset(offset);
        long currentNodeId = cursor.getCurrentPageId();
        long generationA = GenSafePointer.readGeneration(cursor);
        long pointerA = GenSafePointer.readPointer(cursor);
        short checksumA = GenSafePointer.readChecksum(cursor);
        boolean correctChecksumA = GenSafePointer.checksumOf(generationA, pointerA) == checksumA;
        byte stateA = GenSafePointerPair.pointerState(stableGeneration, unstableGeneration, generationA, pointerA, correctChecksumA);
        boolean okA = stateA != 3 && stateA != 2;
        long generationB = GenSafePointer.readGeneration(cursor);
        long pointerB = GenSafePointer.readPointer(cursor);
        short checksumB = GenSafePointer.readChecksum(cursor);
        boolean correctChecksumB = GenSafePointer.checksumOf(generationB, pointerB) == checksumB;
        byte stateB = GenSafePointerPair.pointerState(stableGeneration, unstableGeneration, generationB, pointerB, correctChecksumB);
        boolean bl = okB = stateB != 3 && stateB != 2;
        if (!okA || !okB) {
            boolean isInternal = TreeNode.isInternal(cursor);
            String type = isInternal ? "internal" : "leaf";
            cursor.setCursorException(String.format("GSPP state found that was not ok in %s field in %s node with id %d%n  slotA[%s]%n  slotB[%s]", pointerFieldName, type, currentNodeId, ConsistencyChecker.stateToString(generationA, pointerA, stateA), ConsistencyChecker.stateToString(generationB, pointerB, stateB)));
        }
    }

    private static String stateToString(long generationA, long pointerA, byte stateA) {
        return String.format("generation=%d, pointer=%d, state=%s", generationA, pointerA, GenSafePointerPair.pointerStateName(stateA));
    }

    private static class KeyRange<KEY> {
        private final Comparator<KEY> comparator;
        private final KEY fromInclusive;
        private final KEY toExclusive;
        private final Layout<KEY, ?> layout;
        private final KeyRange<KEY> superRange;

        private KeyRange(Comparator<KEY> comparator, KEY fromInclusive, KEY toExclusive, Layout<KEY, ?> layout, KeyRange<KEY> superRange) {
            this.comparator = comparator;
            this.superRange = superRange;
            this.fromInclusive = fromInclusive == null ? null : layout.copyKey(fromInclusive, layout.newKey());
            this.toExclusive = toExclusive == null ? null : layout.copyKey(toExclusive, layout.newKey());
            this.layout = layout;
        }

        boolean inRange(KEY key) {
            if (this.fromInclusive != null) {
                if (this.toExclusive != null) {
                    return this.comparator.compare(key, this.fromInclusive) >= 0 && this.comparator.compare(key, this.toExclusive) < 0;
                }
                return this.comparator.compare(key, this.fromInclusive) >= 0;
            }
            return this.toExclusive == null || this.comparator.compare(key, this.toExclusive) < 0;
        }

        KeyRange<KEY> restrictLeft(KEY left) {
            if (this.fromInclusive == null || this.comparator.compare(this.fromInclusive, left) < 0) {
                return new KeyRange<KEY>(this.comparator, left, this.toExclusive, this.layout, this);
            }
            return new KeyRange<KEY>(this.comparator, this.fromInclusive, this.toExclusive, this.layout, this);
        }

        KeyRange<KEY> restrictRight(KEY right) {
            if (this.toExclusive == null || this.comparator.compare(this.toExclusive, right) > 0) {
                return new KeyRange<KEY>(this.comparator, this.fromInclusive, right, this.layout, this);
            }
            return new KeyRange<KEY>(this.comparator, this.fromInclusive, this.toExclusive, this.layout, this);
        }

        public String toString() {
            return (this.superRange != null ? String.format("%s%n", this.superRange) : "") + this.fromInclusive + " \u2264 key < " + this.toExclusive;
        }
    }
}

