/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.io.PrintStream;
import org.neo4j.index.internal.gbptree.ConsistencyChecker;
import org.neo4j.index.internal.gbptree.GenSafePointerPair;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.PageCursor;

class TreePrinter<KEY, VALUE> {
    private final TreeNode<KEY, VALUE> node;
    private final Layout<KEY, VALUE> layout;
    private final long stableGeneration;
    private final long unstableGeneration;

    TreePrinter(TreeNode<KEY, VALUE> node, Layout<KEY, VALUE> layout, long stableGeneration, long unstableGeneration) {
        this.node = node;
        this.layout = layout;
        this.stableGeneration = stableGeneration;
        this.unstableGeneration = unstableGeneration;
    }

    void printTree(PageCursor cursor, PrintStream out, boolean printValues, boolean printPosition) throws IOException {
        ConsistencyChecker.assertOnTreeNode(cursor);
        int level = 0;
        do {
            out.println("Level " + level++);
            long leftmostSibling = cursor.getCurrentPageId();
            this.printLevel(cursor, out, printValues, printPosition);
            this.node.goTo(cursor, "back", leftmostSibling);
        } while (this.goToLeftmostChild(cursor));
    }

    private void printTreeNode(PageCursor cursor, int keyCount, boolean isLeaf, PrintStream out, boolean printValues, boolean printPosition) throws IOException {
        out.print("{" + cursor.getCurrentPageId() + "} ");
        KEY key = this.layout.newKey();
        VALUE value = this.layout.newValue();
        for (int i = 0; i < keyCount; ++i) {
            long child = -1L;
            do {
                this.node.keyAt(cursor, key, i);
                if (isLeaf) {
                    this.node.valueAt(cursor, value, i);
                    continue;
                }
                child = GenSafePointerPair.pointer(this.node.childAt(cursor, i, this.stableGeneration, this.unstableGeneration));
            } while (cursor.shouldRetry());
            if (printPosition) {
                out.print("#" + i + " ");
            }
            if (isLeaf) {
                out.print(key);
                if (printValues) {
                    out.print("=" + value);
                }
            } else {
                out.print("/" + child + "\\ [" + key + "]");
            }
            out.print(" ");
        }
        if (!isLeaf) {
            long child;
            do {
                child = GenSafePointerPair.pointer(this.node.childAt(cursor, keyCount, this.stableGeneration, this.unstableGeneration));
            } while (cursor.shouldRetry());
            if (printPosition) {
                out.print("#" + keyCount + " ");
            }
            out.print("/" + child + "\\");
        }
        out.println();
    }

    private boolean goToLeftmostChild(PageCursor cursor) throws IOException {
        boolean isInternal;
        long leftmostSibling = -1L;
        do {
            if (!(isInternal = TreeNode.isInternal(cursor))) continue;
            leftmostSibling = this.node.childAt(cursor, 0, this.stableGeneration, this.unstableGeneration);
        } while (cursor.shouldRetry());
        if (isInternal) {
            this.node.goTo(cursor, "child", leftmostSibling);
        }
        return isInternal;
    }

    private void printLevel(PageCursor cursor, PrintStream out, boolean printValues, boolean printPosition) throws IOException {
        long rightSibling = -1L;
        while (true) {
            boolean isLeaf = TreeNode.isLeaf(cursor);
            int keyCount = this.node.keyCount(cursor);
            if (keyCount < 0 || keyCount > this.node.internalMaxKeyCount() && keyCount > this.node.leafMaxKeyCount()) {
                cursor.setCursorException("Unexpected keyCount " + keyCount);
            } else {
                rightSibling = this.node.rightSibling(cursor, this.stableGeneration, this.unstableGeneration);
            }
            if (cursor.shouldRetry()) continue;
            this.printTreeNode(cursor, keyCount, isLeaf, out, printValues, printPosition);
            if (TreeNode.isNode(rightSibling)) {
                this.node.goTo(cursor, "right sibling", rightSibling);
            }
            if (!TreeNode.isNode(rightSibling)) break;
        }
    }
}

