/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.index.internal.gbptree.IdProvider;
import org.neo4j.index.internal.gbptree.KeySearch;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.StructurePropagation;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.io.pagecache.PageCursor;

class InternalTreeLogic<KEY, VALUE> {
    private final IdProvider idProvider;
    private final TreeNode<KEY, VALUE> bTreeNode;
    private final Layout<KEY, VALUE> layout;
    private final KEY primKeyPlaceHolder;
    private final KEY readKey;
    private final VALUE readValue;
    private Level<KEY>[] levels = new Level[0];
    private int currentLevel = -1;

    InternalTreeLogic(IdProvider idProvider, TreeNode<KEY, VALUE> bTreeNode, Layout<KEY, VALUE> layout) {
        this.idProvider = idProvider;
        this.bTreeNode = bTreeNode;
        this.layout = layout;
        this.primKeyPlaceHolder = layout.newKey();
        this.readKey = layout.newKey();
        this.readValue = layout.newValue();
        this.ensureStackCapacity(10);
    }

    private void ensureStackCapacity(int depth) {
        if (depth > this.levels.length) {
            int oldStackLength = this.levels.length;
            this.levels = Arrays.copyOf(this.levels, depth);
            for (int i = oldStackLength; i < depth; ++i) {
                this.levels[i] = new Level<KEY>(this.layout);
            }
        }
    }

    protected void initialize(PageCursor cursorAtRoot) {
        this.currentLevel = 0;
        Level<KEY> level = this.levels[this.currentLevel];
        ((Level)level).treeNodeId = cursorAtRoot.getCurrentPageId();
        ((Level)level).lowerIsOpenEnded = true;
        ((Level)level).upperIsOpenEnded = true;
    }

    private boolean popLevel(PageCursor cursor) throws IOException {
        --this.currentLevel;
        if (this.currentLevel >= 0) {
            Level<KEY> level = this.levels[this.currentLevel];
            this.bTreeNode.goTo(cursor, "parent", ((Level)level).treeNodeId);
            return true;
        }
        return false;
    }

    private void moveToCorrectLeaf(PageCursor cursor, KEY key, long stableGeneration, long unstableGeneration) throws IOException {
        int previousLevel = this.currentLevel;
        while (!this.levels[this.currentLevel].covers(key)) {
            --this.currentLevel;
        }
        if (this.currentLevel != previousLevel) {
            PageCursorUtil.goTo(cursor, "parent", ((Level)this.levels[this.currentLevel]).treeNodeId);
        }
        while (true) {
            if (!TreeNode.isInternal(cursor)) break;
            int keyCount = this.bTreeNode.keyCount(cursor);
            int searchResult = this.search(cursor, key, this.readKey, keyCount);
            int childPos = KeySearch.positionOf(searchResult);
            if (KeySearch.isHit(searchResult)) {
                ++childPos;
            }
            Level<KEY> parentLevel = this.levels[this.currentLevel];
            ++this.currentLevel;
            this.ensureStackCapacity(this.currentLevel + 1);
            Level<KEY> level = this.levels[this.currentLevel];
            ((Level)level).childPos = childPos;
            ((Level)level).lowerIsOpenEnded = childPos == 0 && !TreeNode.isNode(this.bTreeNode.leftSibling(cursor, stableGeneration, unstableGeneration));
            if (!((Level)level).lowerIsOpenEnded) {
                if (childPos == 0) {
                    this.layout.copyKey(((Level)parentLevel).lower, ((Level)level).lower);
                    ((Level)level).lowerIsOpenEnded = ((Level)parentLevel).lowerIsOpenEnded;
                } else {
                    this.bTreeNode.keyAt(cursor, ((Level)level).lower, childPos - 1);
                }
            }
            ((Level)level).upperIsOpenEnded = childPos >= keyCount && !TreeNode.isNode(this.bTreeNode.rightSibling(cursor, stableGeneration, unstableGeneration));
            if (!((Level)level).upperIsOpenEnded) {
                if (childPos == keyCount) {
                    this.layout.copyKey(((Level)parentLevel).upper, ((Level)level).upper);
                    ((Level)level).upperIsOpenEnded = ((Level)parentLevel).upperIsOpenEnded;
                } else {
                    this.bTreeNode.keyAt(cursor, ((Level)level).upper, childPos);
                }
            }
            long childId = this.bTreeNode.childAt(cursor, childPos, stableGeneration, unstableGeneration);
            PointerChecking.checkPointer(childId, false);
            this.bTreeNode.goTo(cursor, "child", childId);
            ((Level)level).treeNodeId = cursor.getCurrentPageId();
        }
        assert (TreeNode.isLeaf(cursor)) : "Ended up on a tree node which isn't a leaf after moving cursor towards " + key + ", cursor is at " + cursor.getCurrentPageId();
    }

    void insert(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE value, ValueMerger<VALUE> valueMerger, long stableGeneration, long unstableGeneration) throws IOException {
        assert (this.cursorIsAtExpectedLocation(cursor));
        this.moveToCorrectLeaf(cursor, key, stableGeneration, unstableGeneration);
        this.insertInLeaf(cursor, structurePropagation, key, value, valueMerger, stableGeneration, unstableGeneration);
        while (structurePropagation.hasNewGen || structurePropagation.hasSplit) {
            int pos = ((Level)this.levels[this.currentLevel]).childPos;
            if (!this.popLevel(cursor)) break;
            if (structurePropagation.hasNewGen) {
                structurePropagation.hasNewGen = false;
                this.bTreeNode.setChildAt(cursor, structurePropagation.left, pos, stableGeneration, unstableGeneration);
            }
            if (!structurePropagation.hasSplit) continue;
            structurePropagation.hasSplit = false;
            this.insertInInternal(cursor, structurePropagation, this.bTreeNode.keyCount(cursor), structurePropagation.primKey, structurePropagation.right, stableGeneration, unstableGeneration);
        }
    }

    private int search(PageCursor cursor, KEY key, KEY readKey, int keyCount) {
        int searchResult = KeySearch.search(cursor, this.bTreeNode, key, readKey, keyCount);
        KeySearch.assertSuccess(searchResult);
        return searchResult;
    }

    private boolean cursorIsAtExpectedLocation(PageCursor cursor) {
        assert (this.currentLevel >= 0) : "Uninitialized tree logic, currentLevel:" + this.currentLevel;
        assert (cursor.getCurrentPageId() == ((Level)this.levels[this.currentLevel]).treeNodeId) : "Expected cursor to be at page:" + Level.access$000(this.levels[this.currentLevel]) + " at level:" + this.currentLevel + ", but was at page:" + cursor.getCurrentPageId();
        return true;
    }

    private void insertInInternal(PageCursor cursor, StructurePropagation<KEY> structurePropagation, int keyCount, KEY primKey, long rightChild, long stableGeneration, long unstableGeneration) throws IOException {
        this.createUnstableVersionIfNeeded(cursor, structurePropagation, stableGeneration, unstableGeneration);
        if (keyCount < this.bTreeNode.internalMaxKeyCount()) {
            int pos = KeySearch.positionOf(this.search(cursor, primKey, this.readKey, keyCount));
            this.bTreeNode.insertKeyAt(cursor, primKey, pos, keyCount);
            this.bTreeNode.insertChildAt(cursor, rightChild, pos + 1, keyCount, stableGeneration, unstableGeneration);
            this.bTreeNode.setKeyCount(cursor, keyCount + 1);
            return;
        }
        this.layout.copyKey(structurePropagation.primKey, this.primKeyPlaceHolder);
        this.splitInternal(cursor, structurePropagation, this.primKeyPlaceHolder, rightChild, keyCount, stableGeneration, unstableGeneration);
    }

    private void splitInternal(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY primKey, long newRightChild, int keyCount, long stableGeneration, long unstableGeneration) throws IOException {
        long current = cursor.getCurrentPageId();
        long oldRight = this.bTreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(oldRight, true);
        long newRight = this.idProvider.acquireNewId(stableGeneration, unstableGeneration);
        int pos = KeySearch.positionOf(this.search(cursor, primKey, this.readKey, keyCount));
        int keyCountAfterInsert = keyCount + 1;
        int middlePos = InternalTreeLogic.middle(keyCountAfterInsert);
        structurePropagation.hasSplit = true;
        structurePropagation.left = current;
        structurePropagation.right = newRight;
        if (middlePos == pos) {
            this.layout.copyKey(primKey, structurePropagation.primKey);
        } else {
            this.bTreeNode.keyAt(cursor, structurePropagation.primKey, pos < middlePos ? middlePos - 1 : middlePos);
        }
        try (PageCursor rightCursor = cursor.openLinkedCursor(newRight);){
            PageCursorUtil.goTo(rightCursor, "new right sibling in split", newRight);
            this.bTreeNode.initializeInternal(rightCursor, stableGeneration, unstableGeneration);
            this.bTreeNode.setRightSibling(rightCursor, oldRight, stableGeneration, unstableGeneration);
            this.bTreeNode.setLeftSibling(rightCursor, current, stableGeneration, unstableGeneration);
            int rightKeyCount = keyCountAfterInsert - middlePos - 1;
            if (pos < middlePos) {
                cursor.copyTo(this.bTreeNode.keyOffset(middlePos), rightCursor, this.bTreeNode.keyOffset(0), rightKeyCount * this.bTreeNode.keySize());
                cursor.copyTo(this.bTreeNode.childOffset(middlePos), rightCursor, this.bTreeNode.childOffset(0), (rightKeyCount + 1) * this.bTreeNode.childSize());
            } else {
                int countAfterPos;
                int countBeforePos = pos - (middlePos + 1);
                if (countBeforePos > 0) {
                    cursor.copyTo(this.bTreeNode.keyOffset(middlePos + 1), rightCursor, this.bTreeNode.keyOffset(0), countBeforePos * this.bTreeNode.keySize());
                }
                if (countBeforePos >= 0) {
                    this.bTreeNode.insertKeyAt(rightCursor, primKey, countBeforePos, countBeforePos);
                }
                if ((countAfterPos = keyCount - pos) > 0) {
                    cursor.copyTo(this.bTreeNode.keyOffset(pos), rightCursor, this.bTreeNode.keyOffset(countBeforePos + 1), countAfterPos * this.bTreeNode.keySize());
                }
                if ((countBeforePos = pos - middlePos) > 0) {
                    cursor.copyTo(this.bTreeNode.childOffset(middlePos + 1), rightCursor, this.bTreeNode.childOffset(0), countBeforePos * this.bTreeNode.childSize());
                }
                this.bTreeNode.insertChildAt(rightCursor, newRightChild, countBeforePos, countBeforePos, stableGeneration, unstableGeneration);
                if (countAfterPos > 0) {
                    cursor.copyTo(this.bTreeNode.childOffset(pos + 1), rightCursor, this.bTreeNode.childOffset(countBeforePos + 1), countAfterPos * this.bTreeNode.childSize());
                }
            }
            this.bTreeNode.setKeyCount(rightCursor, rightKeyCount);
        }
        if (TreeNode.isNode(oldRight)) {
            this.bTreeNode.goTo(cursor, "old right sibling", oldRight);
            this.bTreeNode.setLeftSibling(cursor, newRight, stableGeneration, unstableGeneration);
        }
        this.bTreeNode.goTo(cursor, "left", current);
        this.bTreeNode.setKeyCount(cursor, middlePos);
        if (pos < middlePos) {
            this.bTreeNode.insertKeyAt(cursor, primKey, pos, middlePos - 1);
            this.bTreeNode.insertChildAt(cursor, newRightChild, pos + 1, middlePos - 1, stableGeneration, unstableGeneration);
        }
        this.bTreeNode.setRightSibling(cursor, newRight, stableGeneration, unstableGeneration);
    }

    private static int middle(int keyCountAfterInsert) {
        return keyCountAfterInsert / 2;
    }

    private void insertInLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE value, ValueMerger<VALUE> valueMerger, long stableGeneration, long unstableGeneration) throws IOException {
        int keyCount = this.bTreeNode.keyCount(cursor);
        int search = this.search(cursor, key, this.readKey, keyCount);
        int pos = KeySearch.positionOf(search);
        if (KeySearch.isHit(search)) {
            this.bTreeNode.valueAt(cursor, this.readValue, pos);
            VALUE mergedValue = valueMerger.merge(this.readValue, value);
            if (mergedValue != null) {
                this.createUnstableVersionIfNeeded(cursor, structurePropagation, stableGeneration, unstableGeneration);
                this.bTreeNode.setValueAt(cursor, mergedValue, pos);
            }
            return;
        }
        this.createUnstableVersionIfNeeded(cursor, structurePropagation, stableGeneration, unstableGeneration);
        if (keyCount < this.bTreeNode.leafMaxKeyCount()) {
            this.bTreeNode.insertKeyAt(cursor, key, pos, keyCount);
            this.bTreeNode.insertValueAt(cursor, value, pos, keyCount);
            this.bTreeNode.setKeyCount(cursor, keyCount + 1);
            return;
        }
        this.splitLeaf(cursor, structurePropagation, key, value, keyCount, stableGeneration, unstableGeneration);
    }

    private void splitLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY newKey, VALUE newValue, int keyCount, long stableGeneration, long unstableGeneration) throws IOException {
        long current = cursor.getCurrentPageId();
        long oldRight = this.bTreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(oldRight, true);
        long newRight = this.idProvider.acquireNewId(stableGeneration, unstableGeneration);
        int pos = KeySearch.positionOf(this.search(cursor, newKey, this.readKey, keyCount));
        int keyCountAfterInsert = keyCount + 1;
        int middlePos = InternalTreeLogic.middle(keyCountAfterInsert);
        structurePropagation.hasSplit = true;
        structurePropagation.left = current;
        structurePropagation.right = newRight;
        if (middlePos == pos) {
            this.layout.copyKey(newKey, structurePropagation.primKey);
        } else {
            this.bTreeNode.keyAt(cursor, structurePropagation.primKey, pos < middlePos ? middlePos - 1 : middlePos);
        }
        try (PageCursor rightCursor = cursor.openLinkedCursor(newRight);){
            PageCursorUtil.goTo(rightCursor, "new right sibling in split", newRight);
            this.bTreeNode.initializeLeaf(rightCursor, stableGeneration, unstableGeneration);
            this.bTreeNode.setRightSibling(rightCursor, oldRight, stableGeneration, unstableGeneration);
            this.bTreeNode.setLeftSibling(rightCursor, current, stableGeneration, unstableGeneration);
            int rightKeyCount = keyCountAfterInsert - middlePos;
            if (pos < middlePos) {
                this.copyKeysAndValues(cursor, middlePos - 1, rightCursor, 0, rightKeyCount);
            } else {
                int countBeforePos = pos - middlePos;
                if (countBeforePos > 0) {
                    this.copyKeysAndValues(cursor, middlePos, rightCursor, 0, countBeforePos);
                }
                this.bTreeNode.insertKeyAt(rightCursor, newKey, countBeforePos, countBeforePos);
                this.bTreeNode.insertValueAt(rightCursor, newValue, countBeforePos, countBeforePos);
                int countAfterPos = keyCount - pos;
                if (countAfterPos > 0) {
                    this.copyKeysAndValues(cursor, pos, rightCursor, countBeforePos + 1, countAfterPos);
                }
            }
            this.bTreeNode.setKeyCount(rightCursor, rightKeyCount);
        }
        if (TreeNode.isNode(oldRight)) {
            var20_15 = null;
            try (PageCursor oldRightCursor = cursor.openLinkedCursor(oldRight);){
                this.bTreeNode.goTo(oldRightCursor, "old right sibling", oldRight);
                this.bTreeNode.setLeftSibling(oldRightCursor, newRight, stableGeneration, unstableGeneration);
            }
            catch (Throwable throwable) {
                var20_15 = throwable;
                throw throwable;
            }
        }
        if (pos < middlePos) {
            this.bTreeNode.insertKeyAt(cursor, newKey, pos, middlePos - 1);
            this.bTreeNode.insertValueAt(cursor, newValue, pos, middlePos - 1);
        }
        this.bTreeNode.setKeyCount(cursor, middlePos);
        this.bTreeNode.setRightSibling(cursor, newRight, stableGeneration, unstableGeneration);
    }

    private void copyKeysAndValues(PageCursor cursor, int fromPos, PageCursor rightCursor, int toPos, int count) {
        cursor.copyTo(this.bTreeNode.keyOffset(fromPos), rightCursor, this.bTreeNode.keyOffset(toPos), count * this.bTreeNode.keySize());
        cursor.copyTo(this.bTreeNode.valueOffset(fromPos), rightCursor, this.bTreeNode.valueOffset(toPos), count * this.bTreeNode.valueSize());
    }

    VALUE remove(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE into, long stableGeneration, long unstableGeneration) throws IOException {
        assert (this.cursorIsAtExpectedLocation(cursor));
        this.moveToCorrectLeaf(cursor, key, stableGeneration, unstableGeneration);
        if (!this.removeFromLeaf(cursor, structurePropagation, key, into, stableGeneration, unstableGeneration)) {
            return null;
        }
        while (structurePropagation.hasNewGen) {
            int pos = ((Level)this.levels[this.currentLevel]).childPos;
            if (!this.popLevel(cursor)) break;
            if (!structurePropagation.hasNewGen) continue;
            structurePropagation.hasNewGen = false;
            this.bTreeNode.setChildAt(cursor, structurePropagation.left, pos, stableGeneration, unstableGeneration);
        }
        return into;
    }

    private boolean removeFromLeaf(PageCursor cursor, StructurePropagation<KEY> structurePropagation, KEY key, VALUE into, long stableGeneration, long unstableGeneration) throws IOException {
        int keyCount = this.bTreeNode.keyCount(cursor);
        int search = this.search(cursor, key, this.readKey, keyCount);
        int pos = KeySearch.positionOf(search);
        boolean hit = KeySearch.isHit(search);
        if (!hit) {
            return false;
        }
        this.createUnstableVersionIfNeeded(cursor, structurePropagation, stableGeneration, unstableGeneration);
        this.bTreeNode.removeKeyAt(cursor, pos, keyCount);
        this.bTreeNode.valueAt(cursor, into, pos);
        this.bTreeNode.removeValueAt(cursor, pos, keyCount);
        this.bTreeNode.setKeyCount(cursor, keyCount - 1);
        return true;
    }

    private void createUnstableVersionIfNeeded(PageCursor cursor, StructurePropagation<KEY> structurePropagation, long stableGeneration, long unstableGeneration) throws IOException {
        long oldGenId = cursor.getCurrentPageId();
        long nodeGen = this.bTreeNode.gen(cursor);
        if (nodeGen == unstableGeneration) {
            return;
        }
        long newGenId = this.idProvider.acquireNewId(stableGeneration, unstableGeneration);
        try (PageCursor newGenCursor = cursor.openLinkedCursor(newGenId);){
            PageCursorUtil.goTo(newGenCursor, "new gen", newGenId);
            cursor.copyTo(0, newGenCursor, 0, cursor.getCurrentPageSize());
            this.bTreeNode.setGen(newGenCursor, unstableGeneration);
            this.bTreeNode.setNewGen(newGenCursor, 0L, stableGeneration, unstableGeneration);
        }
        this.bTreeNode.setNewGen(cursor, newGenId, stableGeneration, unstableGeneration);
        long leftSibling = this.bTreeNode.leftSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(leftSibling, true);
        long rightSibling = this.bTreeNode.rightSibling(cursor, stableGeneration, unstableGeneration);
        PointerChecking.checkPointer(rightSibling, true);
        if (TreeNode.isNode(leftSibling)) {
            this.bTreeNode.goTo(cursor, "left sibling in split", leftSibling);
            this.bTreeNode.setRightSibling(cursor, newGenId, stableGeneration, unstableGeneration);
        }
        if (TreeNode.isNode(rightSibling)) {
            this.bTreeNode.goTo(cursor, "right sibling in split", rightSibling);
            this.bTreeNode.setLeftSibling(cursor, newGenId, stableGeneration, unstableGeneration);
        }
        this.bTreeNode.goTo(cursor, "new gen", newGenId);
        structurePropagation.hasNewGen = true;
        structurePropagation.left = newGenId;
        this.idProvider.releaseId(stableGeneration, unstableGeneration, oldGenId);
    }

    private static class Level<KEY> {
        private final Comparator<KEY> layout;
        private long treeNodeId;
        private int childPos;
        private final KEY lower;
        private boolean lowerIsOpenEnded;
        private final KEY upper;
        private boolean upperIsOpenEnded;

        Level(Layout<KEY, ?> layout) {
            this.layout = layout;
            this.lower = layout.newKey();
            this.upper = layout.newKey();
        }

        boolean covers(KEY key) {
            if (!this.lowerIsOpenEnded && this.layout.compare(key, this.lower) < 0) {
                return false;
            }
            return this.upperIsOpenEnded || this.layout.compare(key, this.upper) < 0;
        }
    }
}

