/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.Objects;
import org.neo4j.index.internal.gbptree.GenSafePointer;
import org.neo4j.io.pagecache.PageCursor;

class TreeState {
    private final long pageId;
    private final long stableGeneration;
    private final long unstableGeneration;
    private final long rootId;
    private final long rootGen;
    private final long lastId;
    private final long freeListWritePageId;
    private final long freeListReadPageId;
    private final int freeListWritePos;
    private final int freeListReadPos;
    private boolean valid;

    TreeState(long pageId, long stableGeneration, long unstableGeneration, long rootId, long rootGen, long lastId, long freeListWritePageId, long freeListReadPageId, int freeListWritePos, int freeListReadPos, boolean valid) {
        this.pageId = pageId;
        this.stableGeneration = stableGeneration;
        this.unstableGeneration = unstableGeneration;
        this.rootId = rootId;
        this.rootGen = rootGen;
        this.lastId = lastId;
        this.freeListWritePageId = freeListWritePageId;
        this.freeListReadPageId = freeListReadPageId;
        this.freeListWritePos = freeListWritePos;
        this.freeListReadPos = freeListReadPos;
        this.valid = valid;
    }

    long pageId() {
        return this.pageId;
    }

    long stableGeneration() {
        return this.stableGeneration;
    }

    long unstableGeneration() {
        return this.unstableGeneration;
    }

    long rootId() {
        return this.rootId;
    }

    long rootGen() {
        return this.rootGen;
    }

    long lastId() {
        return this.lastId;
    }

    long freeListWritePageId() {
        return this.freeListWritePageId;
    }

    long freeListReadPageId() {
        return this.freeListReadPageId;
    }

    int freeListWritePos() {
        return this.freeListWritePos;
    }

    int freeListReadPos() {
        return this.freeListReadPos;
    }

    boolean isValid() {
        return this.valid;
    }

    static void write(PageCursor cursor, long stableGeneration, long unstableGeneration, long rootId, long rootGen, long lastId, long freeListWritePageId, long freeListReadPageId, int freeListWritePos, int freeListReadPos) {
        GenSafePointer.assertGenerationOnWrite(stableGeneration);
        GenSafePointer.assertGenerationOnWrite(unstableGeneration);
        TreeState.writeStateOnce(cursor, stableGeneration, unstableGeneration, rootId, rootGen, lastId, freeListWritePageId, freeListReadPageId, freeListWritePos, freeListReadPos);
        TreeState.writeStateOnce(cursor, stableGeneration, unstableGeneration, rootId, rootGen, lastId, freeListWritePageId, freeListReadPageId, freeListWritePos, freeListReadPos);
    }

    static TreeState read(PageCursor cursor) {
        TreeState state = TreeState.readStateOnce(cursor);
        TreeState checksumState = TreeState.readStateOnce(cursor);
        boolean valid = state.equals(checksumState);
        boolean isEmpty = state.isEmpty();
        return state.setValid(valid &= !isEmpty);
    }

    private TreeState setValid(boolean valid) {
        this.valid = valid;
        return this;
    }

    private boolean isEmpty() {
        return this.stableGeneration == 0L && this.unstableGeneration == 0L && this.rootId == 0L && this.lastId == 0L && this.freeListWritePageId == 0L && this.freeListReadPageId == 0L && this.freeListWritePos == 0 && this.freeListReadPos == 0;
    }

    private static TreeState readStateOnce(PageCursor cursor) {
        long pageId = cursor.getCurrentPageId();
        long stableGeneration = (long)cursor.getInt() & 0xFFFFFFFFL;
        long unstableGeneration = (long)cursor.getInt() & 0xFFFFFFFFL;
        long rootId = cursor.getLong();
        long rootGen = cursor.getLong();
        long lastId = cursor.getLong();
        long freeListWritePageId = cursor.getLong();
        long freeListReadPageId = cursor.getLong();
        int freeListWritePos = cursor.getInt();
        int freeListReadPos = cursor.getInt();
        return new TreeState(pageId, stableGeneration, unstableGeneration, rootId, rootGen, lastId, freeListWritePageId, freeListReadPageId, freeListWritePos, freeListReadPos, true);
    }

    private static void writeStateOnce(PageCursor cursor, long stableGeneration, long unstableGeneration, long rootId, long rootGen, long lastId, long freeListWritePageId, long freeListReadPageId, int freeListWritePos, int freeListReadPos) {
        cursor.putInt((int)stableGeneration);
        cursor.putInt((int)unstableGeneration);
        cursor.putLong(rootId);
        cursor.putLong(rootGen);
        cursor.putLong(lastId);
        cursor.putLong(freeListWritePageId);
        cursor.putLong(freeListReadPageId);
        cursor.putInt(freeListWritePos);
        cursor.putInt(freeListReadPos);
    }

    public String toString() {
        return String.format("pageId=%d, stableGeneration=%d, unstableGeneration=%d, rootId=%d, rootGen=%dlastId=%d, freeListWritePageId=%d, freeListReadPageId=%d, freeListWritePos=%d, freeListReadPos=%d, valid=%b", this.pageId, this.stableGeneration, this.unstableGeneration, this.rootId, this.rootGen, this.lastId, this.freeListWritePageId, this.freeListReadPageId, this.freeListWritePos, this.freeListReadPos, this.valid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeState treeState = (TreeState)o;
        return this.pageId == treeState.pageId && this.stableGeneration == treeState.stableGeneration && this.unstableGeneration == treeState.unstableGeneration && this.rootId == treeState.rootId && this.rootGen == treeState.rootGen && this.lastId == treeState.lastId && this.freeListWritePageId == treeState.freeListWritePageId && this.freeListReadPageId == treeState.freeListReadPageId && this.freeListWritePos == treeState.freeListWritePos && this.freeListReadPos == treeState.freeListReadPos && this.valid == treeState.valid;
    }

    public int hashCode() {
        return Objects.hash(this.pageId, this.stableGeneration, this.unstableGeneration, this.rootId, this.rootGen, this.lastId, this.freeListWritePageId, this.freeListReadPageId, this.freeListWritePos, this.freeListReadPos, this.valid);
    }
}

