/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.io.pagecache.PageCursor;

class RightmostInChain {
    private long currentRightmost = 0L;
    private long expectedNextRightmost = 0L;
    private long expectedNextRightmostGen;
    private long currentRightmostGen;

    RightmostInChain() {
    }

    void assertNext(PageCursor cursor, long gen, long leftSibling, long leftSiblingGen, long rightSibling, long rightSiblingGen) {
        long pageId = cursor.getCurrentPageId();
        if (leftSibling != this.currentRightmost) {
            cursor.setCursorException("Sibling pointer does align with tree structure. Expected left sibling to be " + this.currentRightmost + " but was " + leftSibling);
        }
        if (leftSiblingGen > this.currentRightmostGen && this.currentRightmost != 0L) {
            cursor.setCursorException("Sibling pointer gen differs from expected. Expected left sigling gen to be " + this.currentRightmostGen + ", but was " + leftSiblingGen);
        }
        if (pageId != this.expectedNextRightmost && (this.expectedNextRightmost != 0L || this.currentRightmost != 0L)) {
            cursor.setCursorException("Sibling pointer does not align with tree structure. Expected right sibling to be " + this.expectedNextRightmost + " but was " + pageId);
        }
        if (gen > this.expectedNextRightmostGen && this.expectedNextRightmost != 0L) {
            cursor.setCursorException("Sibling pointer gen differs from expected. Expected right sigling gen to be " + this.expectedNextRightmostGen + ", but was " + gen);
        }
        this.currentRightmost = pageId;
        this.currentRightmostGen = gen;
        this.expectedNextRightmost = rightSibling;
        this.expectedNextRightmostGen = rightSiblingGen;
    }

    void assertLast() {
        assert (this.expectedNextRightmost == 0L) : "Expected rightmost right sibling to be 0 but was " + this.expectedNextRightmost;
    }
}

