/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.GenSafePointer;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.io.pagecache.PageCursor;

class GenSafePointerPair {
    static final int SIZE = 24;
    static final int NO_LOGICAL_POS = -1;
    static final String GEN_COMPARISON_NAME_B_BIG = "A < B";
    static final String GEN_COMPARISON_NAME_A_BIG = "A > B";
    static final String GEN_COMPARISON_NAME_EQUAL = "A == B";
    static final byte STABLE = 0;
    static final byte UNSTABLE = 1;
    static final byte CRASH = 2;
    static final byte BROKEN = 3;
    static final byte EMPTY = 4;
    static final long FLAG_SUCCESS = 0L;
    static final long FLAG_FAIL = Long.MIN_VALUE;
    static final long FLAG_READ = 0L;
    static final long FLAG_WRITE = 0x4000000000000000L;
    static final long FLAG_GEN_EQUAL = 0L;
    static final long FLAG_GEN_A_BIG = 0x800000000000000L;
    static final long FLAG_GEN_B_BIG = 0x1000000000000000L;
    static final long FLAG_SLOT_A = 0L;
    static final long FLAG_SLOT_B = 0x2000000000000000L;
    static final long FLAG_ABS_OFFSET = 0L;
    static final long FLAG_LOGICAL_POS = 0x1000000000000000L;
    static final int SHIFT_STATE_A = 56;
    static final int SHIFT_STATE_B = 53;
    static final int SHIFT_GEN_OFFSET = 48;
    static final long SUCCESS_WRITE_TO_B = 0x6000000000000000L;
    static final long SUCCESS_WRITE_TO_A = 0x4000000000000000L;
    static final long SUCCESS_MASK = Long.MIN_VALUE;
    static final long READ_OR_WRITE_MASK = 0x4000000000000000L;
    static final long SLOT_MASK = 0x2000000000000000L;
    static final long STATE_MASK = 7L;
    static final long GEN_COMPARISON_MASK = 0x1800000000000000L;
    static final long POINTER_MASK = 0xFFFFFFFFFFFFL;
    static final long GEN_OFFSET_MASK = 0xFFF000000000000L;
    static final long GEN_OFFSET_TYPE_MASK = 0x1000000000000000L;
    static final long HEADER_MASK = -281474976710656L;
    static final long MAX_GEN_OFFSET_MASK = 4095L;

    GenSafePointerPair() {
    }

    public static long read(PageCursor cursor, long stableGeneration, long unstableGeneration, int logicalPos) {
        short checksumA;
        int gsppOffset = cursor.getOffset();
        long generationA = GenSafePointer.readGeneration(cursor);
        long pointerA = GenSafePointer.readPointer(cursor);
        short readChecksumA = GenSafePointer.readChecksum(cursor);
        boolean correctChecksumA = readChecksumA == (checksumA = GenSafePointer.checksumOf(generationA, pointerA));
        long generationB = GenSafePointer.readGeneration(cursor);
        long pointerB = GenSafePointer.readPointer(cursor);
        short readChecksumB = GenSafePointer.readChecksum(cursor);
        short checksumB = GenSafePointer.checksumOf(generationB, pointerB);
        boolean correctChecksumB = readChecksumB == checksumB;
        byte pointerStateA = GenSafePointerPair.pointerState(stableGeneration, unstableGeneration, generationA, pointerA, correctChecksumA);
        byte pointerStateB = GenSafePointerPair.pointerState(stableGeneration, unstableGeneration, generationB, pointerB, correctChecksumB);
        if (pointerStateA == 1) {
            if (pointerStateB == 0 || pointerStateB == 4) {
                return GenSafePointerPair.buildSuccessfulReadResult(0L, logicalPos, gsppOffset, pointerA);
            }
        } else if (pointerStateB == 1) {
            if (pointerStateA == 0 || pointerStateA == 4) {
                return GenSafePointerPair.buildSuccessfulReadResult(0x2000000000000000L, logicalPos, gsppOffset, pointerB);
            }
        } else if (pointerStateA == 0 && pointerStateB == 0) {
            if (generationA > generationB) {
                return GenSafePointerPair.buildSuccessfulReadResult(0L, logicalPos, gsppOffset, pointerA);
            }
            if (generationB > generationA) {
                return GenSafePointerPair.buildSuccessfulReadResult(0x2000000000000000L, logicalPos, gsppOffset, pointerB);
            }
        } else {
            if (pointerStateA == 0) {
                return GenSafePointerPair.buildSuccessfulReadResult(0L, logicalPos, gsppOffset, pointerA);
            }
            if (pointerStateB == 0) {
                return GenSafePointerPair.buildSuccessfulReadResult(0x2000000000000000L, logicalPos, gsppOffset, pointerB);
            }
        }
        return Long.MIN_VALUE | GenSafePointerPair.generationState(generationA, generationB) | (long)pointerStateA << 56 | (long)pointerStateB << 53;
    }

    private static long buildSuccessfulReadResult(long slot, int logicalPos, int gsppOffset, long pointer) {
        long genOffset;
        boolean isLogicalPos = logicalPos != -1;
        long offsetType = isLogicalPos ? 0x1000000000000000L : 0L;
        long l = genOffset = isLogicalPos ? (long)logicalPos : (long)gsppOffset;
        if ((genOffset & 0xFFFFFFFFFFFFF000L) != 0L) {
            throw new IllegalArgumentException("Illegal genOffset:" + genOffset + ", it would be too large, max is " + 4095L);
        }
        return 0L | slot | offsetType | genOffset << 48 | pointer;
    }

    public static long write(PageCursor cursor, long pointer, long stableGeneration, long unstableGeneration) {
        byte pointerStateB;
        short checksumA;
        int offset = cursor.getOffset();
        pointer = GenSafePointerPair.pointer(pointer);
        long generationA = GenSafePointer.readGeneration(cursor);
        long pointerA = GenSafePointer.readPointer(cursor);
        short readChecksumA = GenSafePointer.readChecksum(cursor);
        boolean correctChecksumA = readChecksumA == (checksumA = GenSafePointer.checksumOf(generationA, pointerA));
        long generationB = GenSafePointer.readGeneration(cursor);
        long pointerB = GenSafePointer.readPointer(cursor);
        short readChecksumB = GenSafePointer.readChecksum(cursor);
        short checksumB = GenSafePointer.checksumOf(generationB, pointerB);
        boolean correctChecksumB = readChecksumB == checksumB;
        byte pointerStateA = GenSafePointerPair.pointerState(stableGeneration, unstableGeneration, generationA, pointerA, correctChecksumA);
        long writeResult = GenSafePointerPair.writeResult(pointerStateA, pointerStateB = GenSafePointerPair.pointerState(stableGeneration, unstableGeneration, generationB, pointerB, correctChecksumB), generationA, generationB);
        if (GenSafePointerPair.isSuccess(writeResult)) {
            boolean writeToA = (writeResult & 0x2000000000000000L) == 0L;
            int writeOffset = writeToA ? offset : offset + 12;
            cursor.setOffset(writeOffset);
            GenSafePointer.write(cursor, unstableGeneration, pointer);
        }
        return writeResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long writeResult(byte pointerStateA, byte pointerStateB, long generationA, long generationB) {
        if (pointerStateA == 0) {
            if (pointerStateB != 0) return 0x6000000000000000L;
            if (generationA > generationB) {
                return 0x6000000000000000L;
            }
            if (generationB <= generationA) return 0xC000000000000000L | GenSafePointerPair.generationState(generationA, generationB) | (long)pointerStateA << 56 | (long)pointerStateB << 53;
            return 0x4000000000000000L;
        }
        if (pointerStateB == 0) {
            return 0x4000000000000000L;
        }
        if (pointerStateA == 1) {
            if (pointerStateB != 4) return 0xC000000000000000L | GenSafePointerPair.generationState(generationA, generationB) | (long)pointerStateA << 56 | (long)pointerStateB << 53;
            return 0x4000000000000000L;
        }
        if (pointerStateB == 1) {
            if (pointerStateA != 4) return 0xC000000000000000L | GenSafePointerPair.generationState(generationA, generationB) | (long)pointerStateA << 56 | (long)pointerStateB << 53;
            return 0x6000000000000000L;
        }
        if (pointerStateA != 4 || pointerStateB != 4) return 0xC000000000000000L | GenSafePointerPair.generationState(generationA, generationB) | (long)pointerStateA << 56 | (long)pointerStateB << 53;
        return 0x4000000000000000L;
    }

    private static long generationState(long generationA, long generationB) {
        return generationA > generationB ? 0x800000000000000L : (generationB > generationA ? 0x1000000000000000L : 0L);
    }

    static byte pointerState(long stableGeneration, long unstableGeneration, long generation, long pointer, boolean checksumIsCorrect) {
        if (GenSafePointer.isEmpty(generation, pointer)) {
            return 4;
        }
        if (!checksumIsCorrect) {
            return 3;
        }
        if (generation < 1L) {
            return 3;
        }
        if (generation <= stableGeneration) {
            return 0;
        }
        if (generation == unstableGeneration) {
            return 1;
        }
        return 2;
    }

    static boolean isSuccess(long result) {
        return (result & Long.MIN_VALUE) == 0L;
    }

    static long pointer(long readResult) {
        return readResult & 0xFFFFFFFFFFFFL;
    }

    static String failureDescription(long result) {
        StringBuilder builder = new StringBuilder("GSPP " + (GenSafePointerPair.isRead(result) ? "READ" : "WRITE") + " failure");
        builder.append(String.format("%n  Pointer state A: %s", GenSafePointerPair.pointerStateName(GenSafePointerPair.pointerStateFromResult(result, 56))));
        builder.append(String.format("%n  Pointer state B: %s", GenSafePointerPair.pointerStateName(GenSafePointerPair.pointerStateFromResult(result, 53))));
        builder.append(String.format("%n  Generations: " + GenSafePointerPair.generationComparisonFromResult(result), new Object[0]));
        return builder.toString();
    }

    static boolean assertSuccess(long result) {
        if (!GenSafePointerPair.isSuccess(result)) {
            throw new TreeInconsistencyException(GenSafePointerPair.failureDescription(result));
        }
        return true;
    }

    private static String generationComparisonFromResult(long result) {
        long bits = result & 0x1800000000000000L;
        if (bits == 0L) {
            return GEN_COMPARISON_NAME_EQUAL;
        }
        if (bits == 0x800000000000000L) {
            return GEN_COMPARISON_NAME_A_BIG;
        }
        if (bits == 0x1000000000000000L) {
            return GEN_COMPARISON_NAME_B_BIG;
        }
        return "Unknown[" + bits + "]";
    }

    static String pointerStateName(byte pointerState) {
        switch (pointerState) {
            case 0: {
                return "STABLE";
            }
            case 1: {
                return "UNSTABLE";
            }
            case 2: {
                return "CRASH";
            }
            case 3: {
                return "BROKEN";
            }
            case 4: {
                return "EMPTY";
            }
        }
        return "Unknown[" + pointerState + "]";
    }

    static byte pointerStateFromResult(long result, int shift) {
        return (byte)(result >>> shift & 7L);
    }

    static boolean isRead(long result) {
        return (result & 0x4000000000000000L) == 0L;
    }

    static boolean resultIsFromSlotA(long result) {
        return (result & 0x2000000000000000L) == 0L;
    }

    static boolean isLogicalPos(long readResult) {
        return (readResult & 0x1000000000000000L) == 0x1000000000000000L;
    }

    static int genOffset(long readResult) {
        if ((readResult & 0xFFFF000000000000L) == 0L) {
            throw new IllegalArgumentException("Expected a header in read result, but read result was " + readResult);
        }
        return Math.toIntExact((readResult & 0xFFF000000000000L) >>> 48);
    }
}

