/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.common.DependencyResolver;
import org.neo4j.function.ThrowingAction;
import org.neo4j.index.internal.gbptree.CleanTrackingConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.CleanupJob;
import org.neo4j.index.internal.gbptree.CrashGenerationCleaner;
import org.neo4j.index.internal.gbptree.CursorCreator;
import org.neo4j.index.internal.gbptree.DataTree;
import org.neo4j.index.internal.gbptree.FreeListIdProvider;
import org.neo4j.index.internal.gbptree.GBPTreeCleanupJob;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyChecker;
import org.neo4j.index.internal.gbptree.GBPTreeOpenOptions;
import org.neo4j.index.internal.gbptree.GBPTreeStructure;
import org.neo4j.index.internal.gbptree.GBPTreeUnsafe;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Generation;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.IdProvider;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.Meta;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.OffloadIdValidator;
import org.neo4j.index.internal.gbptree.OffloadStoreImpl;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.PrintConfig;
import org.neo4j.index.internal.gbptree.PrintingGBPTreeVisitor;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.RootLayer;
import org.neo4j.index.internal.gbptree.RootLayerConfiguration;
import org.neo4j.index.internal.gbptree.RootLayerSupport;
import org.neo4j.index.internal.gbptree.StructureWriteLog;
import org.neo4j.index.internal.gbptree.TreeFileNotFoundException;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNodeLatchService;
import org.neo4j.index.internal.gbptree.TreeNodeLayoutFactory;
import org.neo4j.index.internal.gbptree.TreeNodeSelector;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.index.internal.gbptree.TreeStatePair;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.async.AsyncBlockAccessor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class MultiRootGBPTree<ROOT_KEY, KEY, VALUE>
implements Closeable {
    private static final String INDEX_INTERNAL_TAG = "indexInternal";
    public static final Monitor NO_MONITOR = new Monitor.Adaptor();
    public static final Header.Reader NO_HEADER_READER = headerData -> {};
    public static final Consumer<PageCursor> NO_HEADER_WRITER = pc -> {};
    protected final PagedFile pagedFile;
    private final Path indexFile;
    protected final Layout<KEY, VALUE> layout;
    protected final FreeListIdProvider freeList;
    private final AtomicBoolean changesSinceLastCheckpoint = new AtomicBoolean();
    private volatile CountDownLatch cleanerLock;
    private final ReadWriteLock checkpointLock = new ReentrantReadWriteLock();
    private final ReadWriteLock writerLock = new ReentrantReadWriteLock();
    protected final int payloadSize;
    private volatile long generation;
    protected final LongSupplier generationSupplier = () -> this.generation;
    private final Monitor monitor;
    private final boolean readOnly;
    private final CursorContextFactory contextFactory;
    private final PageCacheTracer pageCacheTracer;
    private final ImmutableSet<OpenOption> openOptions;
    private boolean closed = true;
    private boolean clean;
    private final boolean dirtyOnStartup;
    private final CleanupJob cleaning;
    protected final RootLayer<ROOT_KEY, KEY, VALUE> rootLayer;
    protected final RootLayerSupport rootLayerSupport;
    private volatile boolean writersMustEagerlyFlush;
    private final StructureWriteLog structureWriteLog;

    public MultiRootGBPTree(PageCache pageCache, FileSystemAbstraction fileSystem, Path indexFile, Layout<KEY, VALUE> layout, Monitor monitor, Header.Reader headerReader, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, ImmutableSet<OpenOption> engineOpenOptions, String databaseName, String name, CursorContextFactory contextFactory, RootLayerConfiguration<ROOT_KEY> rootLayerConfiguration, PageCacheTracer pageCacheTracer, DependencyResolver dependencyResolver, TreeNodeLayoutFactory treeNodeLayoutFactory, StructureWriteLog structureWriteLog) throws MetadataMismatchException {
        this.indexFile = indexFile;
        this.monitor = monitor;
        this.readOnly = readOnly;
        this.contextFactory = contextFactory;
        this.openOptions = MultiRootGBPTree.treeOpenOptions(engineOpenOptions);
        this.pageCacheTracer = pageCacheTracer;
        this.generation = Generation.generation(1L, 3L);
        this.layout = layout;
        this.structureWriteLog = structureWriteLog;
        try (CursorContext cursorContext = contextFactory.create(INDEX_INTERNAL_TAG);){
            OpenResult openResult = this.openOrCreate(fileSystem, pageCache, indexFile, databaseName, this.openOptions);
            boolean created = openResult.created;
            this.pagedFile = openResult.pagedFile;
            this.closed = false;
            if (!created) {
                MultiRootGBPTree.verifyPayloadSize(this.pagedFile, cursorContext);
                created = MultiRootGBPTree.needRecreation(this.pagedFile, cursorContext, monitor, readOnly);
            }
            this.payloadSize = this.pagedFile.payloadSize();
            this.freeList = new FreeListIdProvider(this.pagedFile.payloadSize());
            TreeNodeLatchService latchService = new TreeNodeLatchService();
            TreeNodeSelector treeNodeSelector = treeNodeLayoutFactory.createSelector(engineOpenOptions);
            this.rootLayerSupport = new RootLayerSupport(this.pagedFile, this.generationSupplier, this::appendTreeInformation, latchService, this.freeList, monitor, (ThrowingAction<IOException>)((ThrowingAction)this::awaitCleaner), this.checkpointLock, this.writerLock, this.changesSinceLastCheckpoint, name, readOnly, () -> this.writersMustEagerlyFlush, structureWriteLog);
            this.rootLayer = rootLayerConfiguration.buildRootLayer(this.rootLayerSupport, layout, treeNodeSelector, dependencyResolver, engineOpenOptions.contains((Object)PageCacheOpenOptions.MULTI_VERSIONED));
            if (created) {
                this.initializeAfterCreation(cursorContext);
                this.dirtyOnStartup = false;
                this.cleaning = CleanupJob.CLEAN;
            } else {
                this.initialize(this.pagedFile, headerReader, cursorContext);
                this.dirtyOnStartup = !this.clean;
                this.bumpUnstableGeneration();
                if (!readOnly) {
                    this.clean = false;
                    try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                        this.forceState(flushEvent, AsyncBlockAccessor.EMPTY_ASYNC_BLOCK_ACCESSOR, cursorContext);
                    }
                    this.cleaning = this.createCleanupJob(recoveryCleanupWorkCollector, this.dirtyOnStartup);
                } else {
                    this.cleaning = CleanupJob.CLEAN;
                }
            }
            this.monitor.startupState(!this.dirtyOnStartup);
        }
        catch (IOException e) {
            throw this.exitConstructor(new UncheckedIOException(e));
        }
        catch (Throwable e) {
            throw this.exitConstructor(e);
        }
    }

    private RuntimeException exitConstructor(Throwable throwable) {
        try {
            this.close();
        }
        catch (IOException e) {
            throwable = Exceptions.chain((Throwable)new UncheckedIOException(e), (Throwable)throwable);
        }
        this.appendTreeInformation(throwable);
        Exceptions.throwIfUnchecked((Throwable)throwable);
        return new RuntimeException(throwable);
    }

    private void initializeAfterCreation(CursorContext cursorContext) throws IOException {
        Root firstRoot = new Root(3L, Generation.unstableGeneration(this.generation));
        this.rootLayer.initializeAfterCreation(firstRoot, cursorContext);
        this.freeList.initializeAfterCreation(CursorCreator.bind(this.pagedFile, 2, cursorContext), 4L);
        this.structureWriteLog.createRoot(Generation.unstableGeneration(this.generation), firstRoot.id());
    }

    private OpenResult openOrCreate(FileSystemAbstraction fs, PageCache pageCache, Path indexFile, String databaseName, ImmutableSet<OpenOption> openOptions) throws IOException, TreeFileNotFoundException {
        openOptions = openOptions.newWithoutAll(Arrays.asList(GBPTreeOpenOptions.values()));
        if (!fs.fileExists(indexFile)) {
            if (this.readOnly) {
                throw new TreeFileNotFoundException("Can not create new tree file '" + String.valueOf(indexFile) + "' in read only mode.");
            }
            this.monitor.noStoreFile();
            openOptions = openOptions.newWith((Object)StandardOpenOption.CREATE);
            return new OpenResult(pageCache.map(indexFile, pageCache.pageSize(), databaseName, openOptions), true);
        }
        return new OpenResult(pageCache.map(indexFile, pageCache.pageSize(), databaseName, openOptions), false);
    }

    private static boolean needRecreation(PagedFile pagedFile, CursorContext cursorContext, Monitor monitor, boolean readOnly) throws IOException {
        try (PageCursor cursor = pagedFile.io(0L, readOnly ? 1 : 2, cursorContext);){
            boolean needRecreation;
            byte[] bytes = new byte[pagedFile.payloadSize()];
            boolean bl = needRecreation = MultiRootGBPTree.pageIsEmpty(cursor, bytes, 1L) && MultiRootGBPTree.pageIsEmpty(cursor, bytes, 2L);
            if (needRecreation) {
                if (readOnly) {
                    throw new TreeFileNotFoundException("Can not re-create tree file '" + String.valueOf(pagedFile.path()) + "' in read only mode.");
                }
                MultiRootGBPTree.zapPage(cursor, 0L);
                MultiRootGBPTree.zapPage(cursor, 1L);
                MultiRootGBPTree.zapPage(cursor, 2L);
                MultiRootGBPTree.zapPage(cursor, 3L);
                MultiRootGBPTree.zapPage(cursor, 4L);
                monitor.needRecreation();
            }
            boolean bl2 = needRecreation;
            return bl2;
        }
    }

    private static boolean pageIsEmpty(PageCursor cursor, byte[] bytes, long pageId) throws IOException {
        if (!cursor.next(pageId)) {
            return true;
        }
        do {
            Arrays.fill(bytes, (byte)0);
            cursor.getBytes(bytes);
        } while (cursor.shouldRetry());
        return MultiRootGBPTree.allZeroes(bytes);
    }

    private static void zapPage(PageCursor cursor, long pageId) throws IOException {
        cursor.next(pageId);
        cursor.zapPage();
    }

    private static boolean allZeroes(byte[] array) {
        for (byte b : array) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    private static PagedFile openExistingIndexFile(PageCache pageCache, Path indexFile, CursorContext cursorContext, String databaseName, ImmutableSet<OpenOption> openOptions) throws IOException, MetadataMismatchException {
        PagedFile pagedFile = pageCache.map(indexFile, pageCache.pageSize(), databaseName, MultiRootGBPTree.treeOpenOptions(openOptions));
        MutableBoolean pagedFileOpen = new MutableBoolean(true);
        boolean success = false;
        try {
            MultiRootGBPTree.verifyPayloadSize(pagedFile, cursorContext);
            success = true;
            PagedFile pagedFile2 = pagedFile;
            return pagedFile2;
        }
        catch (IllegalStateException e) {
            throw new MetadataMismatchException("Index is not fully initialized since it's missing the meta page", e);
        }
        finally {
            if (!success && pagedFileOpen.booleanValue()) {
                pagedFile.close();
            }
        }
    }

    private void initialize(PagedFile pagedFile, Header.Reader headerReader, CursorContext cursorContext) throws IOException {
        ImmutableSet<OpenOption> openOptions = this.openOptions;
        TreeState state = MultiRootGBPTree.readHeaderFromPagedFiled(pagedFile, headerReader, cursorContext, openOptions);
        this.generation = Generation.generation(state.stableGeneration(), state.unstableGeneration());
        Root root = new Root(state.rootId(), state.rootGeneration());
        this.rootLayer.initialize(root, cursorContext);
        long lastId = state.lastId();
        long freeListWritePageId = state.freeListWritePageId();
        long freeListReadPageId = state.freeListReadPageId();
        int freeListWritePos = state.freeListWritePos();
        int freeListReadPos = state.freeListReadPos();
        this.freeList.initialize(lastId, freeListWritePageId, freeListReadPageId, freeListWritePos, freeListReadPos);
        this.clean = state.isClean();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T extends Header.Reader> Optional<T> readHeader(FileSystemAbstraction fileSystem, Path indexFile, T headerReader, ImmutableSet<OpenOption> openOptions) {
        if (fileSystem.fileExists(indexFile)) {
            try (StoreChannel channel = fileSystem.read(indexFile);){
                Optional<T> optional;
                try (NativeScopedBuffer scopedBuffer = new NativeScopedBuffer(512, MultiRootGBPTree.getEndianness(openOptions), (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                    ByteBuffer buffer = scopedBuffer.getBuffer();
                    Meta meta = MultiRootGBPTree.getMeta(buffer, channel);
                    int pageSize = meta.getPayloadSize();
                    TreeState stateA = MultiRootGBPTree.getTreeState(buffer, channel, pageSize, 1L);
                    TreeState stateB = MultiRootGBPTree.getTreeState(buffer, channel, pageSize, 2L);
                    TreeState state = TreeStatePair.selectNewestValidState((Pair<TreeState, TreeState>)Pair.of((Object)stateA, (Object)stateB));
                    MultiRootGBPTree.readEmbeddedHeader(headerReader, channel, buffer, pageSize, state);
                    optional = Optional.of(headerReader);
                }
                return optional;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return Optional.empty();
    }

    private static void readEmbeddedHeader(Header.Reader headerReader, StoreChannel channel, ByteBuffer buffer, int pageSize, TreeState state) throws IOException {
        buffer.clear().limit(4);
        long headerPosition = state.pageId() * (long)pageSize + 114L;
        channel.position(headerPosition);
        channel.readAll(buffer);
        int headerSize = buffer.flip().getInt();
        buffer.clear().limit(headerSize);
        channel.readAll(buffer);
        buffer.flip();
        headerReader.read(buffer);
    }

    private static ByteOrder getEndianness(ImmutableSet<OpenOption> openOptions) {
        return openOptions.contains((Object)PageCacheOpenOptions.BIG_ENDIAN) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    private static Meta getMeta(ByteBuffer buffer, StoreChannel channel) throws IOException {
        buffer.clear().limit(40);
        channel.position(0L);
        channel.readAll(buffer);
        buffer.flip();
        return Meta.read(buffer);
    }

    private static TreeState getTreeState(ByteBuffer buffer, StoreChannel read, int pageSize, long statePage) throws IOException {
        buffer.clear().limit(114);
        read.position((long)pageSize * statePage);
        read.readAll(buffer);
        buffer.flip();
        return TreeState.read(statePage, buffer);
    }

    public static void readHeader(PageCache pageCache, Path indexFile, Header.Reader headerReader, String databaseName, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) throws IOException, MetadataMismatchException {
        try (PagedFile pagedFile = MultiRootGBPTree.openExistingIndexFile(pageCache, indexFile, cursorContext, databaseName, openOptions);){
            MultiRootGBPTree.readHeaderFromPagedFiled(pagedFile, headerReader, cursorContext, openOptions);
        }
        catch (Throwable t) {
            t.addSuppressed(new Exception(String.format("GBPTree[file:%s]", indexFile)));
            throw t;
        }
    }

    private static TreeState readHeaderFromPagedFiled(PagedFile pagedFile, Header.Reader headerReader, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) throws IOException {
        Pair<TreeState, TreeState> states = MultiRootGBPTree.loadStatePages(pagedFile, cursorContext);
        TreeState state = TreeStatePair.selectNewestValidState(states);
        try (PageCursor cursor = pagedFile.io(state.pageId(), 1, cursorContext);){
            PageCursorUtil.goTo((PageCursor)cursor, (String)"header data", (long)state.pageId());
            MultiRootGBPTree.doReadHeader(headerReader, cursor, MultiRootGBPTree.getEndianness(openOptions));
        }
        return state;
    }

    private static void doReadHeader(Header.Reader headerReader, PageCursor cursor, ByteOrder order) throws IOException {
        int headerDataLength;
        do {
            TreeState.read(cursor);
            headerDataLength = cursor.getInt();
        } while (cursor.shouldRetry());
        int headerDataOffset = cursor.getOffset();
        byte[] headerDataBytes = new byte[headerDataLength];
        do {
            cursor.setOffset(headerDataOffset);
            cursor.getBytes(headerDataBytes);
        } while (cursor.shouldRetry());
        headerReader.read(ByteBuffer.wrap(headerDataBytes).order(order));
    }

    private void writeState(PagedFile pagedFile, Header.Writer headerWriter, CursorContext cursorContext) throws IOException {
        Pair<TreeState, TreeState> states = MultiRootGBPTree.readStatePages(pagedFile, cursorContext);
        TreeState oldestState = TreeStatePair.selectOldestOrInvalid(states);
        long pageToOverwrite = oldestState.pageId();
        Root root = this.rootLayer.getRoot(cursorContext);
        try (PageCursor cursor = pagedFile.io(pageToOverwrite, 2, cursorContext);){
            PageCursorUtil.goTo((PageCursor)cursor, (String)"state page", (long)pageToOverwrite);
            FreeListIdProvider.FreelistMetaData freelistMetaData = this.freeList.metaData();
            TreeState.write(cursor, Generation.stableGeneration(this.generation), Generation.unstableGeneration(this.generation), root.id(), root.generation(), freelistMetaData.lastId(), freelistMetaData.writePageId(), freelistMetaData.readPageId(), freelistMetaData.writePos(), freelistMetaData.readPos(), this.clean);
            MultiRootGBPTree.writerHeader(pagedFile, headerWriter, MultiRootGBPTree.other(states, oldestState), cursor, cursorContext);
            PointerChecking.checkOutOfBounds(cursor);
        }
    }

    private static void writerHeader(PagedFile pagedFile, Header.Writer headerWriter, TreeState otherState, PageCursor cursor, CursorContext cursorContext) throws IOException {
        int headerOffset = cursor.getOffset();
        int headerDataOffset = MultiRootGBPTree.getHeaderDataOffset(headerOffset);
        if (otherState.isValid() || headerWriter != Header.CARRY_OVER_PREVIOUS_HEADER) {
            try (PageCursor previousCursor = pagedFile.io(otherState.pageId(), 1, cursorContext);){
                PageCursorUtil.goTo((PageCursor)previousCursor, (String)"previous state page", (long)otherState.pageId());
                PointerChecking.checkOutOfBounds(cursor);
                do {
                    cursor.checkAndClearBoundsFlag();
                    TreeState.read(previousCursor);
                    int previousLength = previousCursor.getInt();
                    cursor.setOffset(headerDataOffset);
                    headerWriter.write(previousCursor, previousLength, cursor);
                } while (previousCursor.shouldRetry());
                PointerChecking.checkOutOfBounds(previousCursor);
            }
            PointerChecking.checkOutOfBounds(cursor);
            int length = cursor.getOffset() - headerDataOffset;
            cursor.putInt(headerOffset, length);
        }
    }

    @VisibleForTesting
    public static void overwriteHeader(PageCache pageCache, Path indexFile, Consumer<PageCursor> headerWriter, String databaseName, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) throws IOException {
        Header.Writer writer = Header.replace(headerWriter);
        try (PagedFile pagedFile = MultiRootGBPTree.openExistingIndexFile(pageCache, indexFile, cursorContext, databaseName, openOptions);){
            Pair<TreeState, TreeState> states = MultiRootGBPTree.readStatePages(pagedFile, cursorContext);
            TreeState newestValidState = TreeStatePair.selectNewestValidState(states);
            long pageToOverwrite = newestValidState.pageId();
            try (PageCursor cursor = pagedFile.io(pageToOverwrite, 2, cursorContext);){
                PageCursorUtil.goTo((PageCursor)cursor, (String)"state page", (long)pageToOverwrite);
                cursor.setOffset(114);
                int headerOffset = cursor.getOffset();
                int headerDataOffset = MultiRootGBPTree.getHeaderDataOffset(headerOffset);
                cursor.setOffset(headerDataOffset);
                writer.write(null, 0, cursor);
                int length = cursor.getOffset() - headerDataOffset;
                cursor.putInt(headerOffset, length);
                PointerChecking.checkOutOfBounds(cursor);
            }
        }
    }

    private static int getHeaderDataOffset(int headerOffset) {
        return headerOffset + 4;
    }

    private static TreeState other(Pair<TreeState, TreeState> states, TreeState state) {
        return states.getLeft() == state ? (TreeState)states.getRight() : (TreeState)states.getLeft();
    }

    private static Pair<TreeState, TreeState> loadStatePages(PagedFile pagedFile, CursorContext cursorContext) throws MetadataMismatchException, IOException {
        try {
            Pair<TreeState, TreeState> states = MultiRootGBPTree.readStatePages(pagedFile, cursorContext);
            if (((TreeState)states.getLeft()).isEmpty() && ((TreeState)states.getRight()).isEmpty()) {
                throw new MetadataMismatchException("Index is not fully initialized since its state pages are empty");
            }
            return states;
        }
        catch (IllegalStateException e) {
            throw new MetadataMismatchException("Index is not fully initialized since it's missing state pages", e);
        }
    }

    private static Pair<TreeState, TreeState> readStatePages(PagedFile pagedFile, CursorContext cursorContext) throws IOException {
        Pair<TreeState, TreeState> states;
        try (PageCursor cursor = pagedFile.io(0L, 1, cursorContext);){
            states = TreeStatePair.readStatePages(cursor, 1L, 2L);
        }
        return states;
    }

    public void create(ROOT_KEY dataRootKey, CursorContext cursorContext) throws IOException {
        this.rootLayer.create(dataRootKey, cursorContext);
    }

    public void delete(ROOT_KEY dataRootKey, CursorContext cursorContext) throws IOException {
        this.rootLayer.delete(dataRootKey, cursorContext);
    }

    public DataTree<KEY, VALUE> access(ROOT_KEY dataRootKey) {
        return this.rootLayer.access(dataRootKey);
    }

    public void checkpoint(Consumer<PageCursor> headerWriter, FileFlushEvent flushEvent, AsyncBlockAccessor asyncBlockAccessor, CursorContext cursorContext) {
        try {
            this.checkpoint(Header.replace(headerWriter), flushEvent, asyncBlockAccessor, cursorContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void checkpoint(FileFlushEvent flushEvent, AsyncBlockAccessor asyncBlockAccessor, CursorContext cursorContext) {
        try {
            this.checkpoint(Header.CARRY_OVER_PREVIOUS_HEADER, flushEvent, asyncBlockAccessor, cursorContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkpoint(Header.Writer headerWriter, FileFlushEvent flushEvent, AsyncBlockAccessor asyncBlockAccessor, CursorContext cursorContext) throws IOException {
        if (this.readOnly) {
            return;
        }
        this.awaitCleaner();
        try {
            this.withCheckpointAndWriterLock((ThrowingAction<IOException>)((ThrowingAction)() -> {
                this.writersMustEagerlyFlush = true;
            }));
            this.monitor.checkpointStarted();
            this.pagedFile.flushAndForce(flushEvent, asyncBlockAccessor);
            this.withCheckpointAndWriterLock((ThrowingAction<IOException>)((ThrowingAction)() -> {
                this.writersMustEagerlyFlush = false;
                long generation = this.generation;
                long stableGeneration = Generation.stableGeneration(generation);
                long unstableGeneration = Generation.unstableGeneration(generation);
                this.freeList.flush(stableGeneration, unstableGeneration, CursorCreator.bind(this.pagedFile, 2, cursorContext));
                this.structureWriteLog.checkpoint(stableGeneration, unstableGeneration, unstableGeneration + 1L);
                this.pagedFile.flushAndForce(flushEvent, asyncBlockAccessor);
                this.generation = Generation.generation(unstableGeneration, unstableGeneration + 1L);
                this.writeState(this.pagedFile, headerWriter, cursorContext);
                this.pagedFile.flushAndForce(flushEvent, asyncBlockAccessor);
                this.monitor.checkpointCompleted();
                this.changesSinceLastCheckpoint.set(false);
            }));
        }
        finally {
            this.writersMustEagerlyFlush = false;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        try (CursorContext cursorContext = this.contextFactory.create(INDEX_INTERNAL_TAG);){
            if (this.openOptions.contains((Object)GBPTreeOpenOptions.NO_FLUSH_ON_CLOSE) || this.readOnly) {
                this.doClose();
                return;
            }
            this.withCheckpointAndWriterLock((ThrowingAction<IOException>)((ThrowingAction)() -> {
                if (this.closed) {
                    return;
                }
                AsyncBlockAccessor asyncBlockAccessor = AsyncBlockAccessor.EMPTY_ASYNC_BLOCK_ACCESSOR;
                try (FileFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush();){
                    this.maybeForceCleanState(flushEvent, asyncBlockAccessor, cursorContext);
                }
                catch (IOException ioe) {
                    try {
                        FileFlushEvent flushEvent2;
                        if (!this.pagedFile.isDeleteOnClose()) {
                            flushEvent2 = this.pageCacheTracer.beginFileFlush();
                            try {
                                this.pagedFile.flushAndForce(flushEvent2, asyncBlockAccessor);
                            }
                            finally {
                                if (flushEvent2 != null) {
                                    flushEvent2.close();
                                }
                            }
                        }
                        flushEvent2 = this.pageCacheTracer.beginFileFlush();
                        try {
                            this.maybeForceCleanState(flushEvent2, asyncBlockAccessor, cursorContext);
                        }
                        finally {
                            if (flushEvent2 != null) {
                                flushEvent2.close();
                            }
                        }
                        this.doClose();
                    }
                    catch (IOException e) {
                        ioe.addSuppressed(e);
                        throw ioe;
                    }
                }
                finally {
                    this.doClose();
                }
            }));
        }
    }

    private void withCheckpointAndWriterLock(ThrowingAction<IOException> task) throws IOException {
        this.checkpointLock.writeLock().lock();
        this.writerLock.writeLock().lock();
        try {
            task.apply();
        }
        finally {
            this.writerLock.writeLock().unlock();
            this.checkpointLock.writeLock().unlock();
        }
    }

    protected void awaitCleaner() throws IOException {
        if (this.cleanerLock != null) {
            try {
                this.cleanerLock.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Got interrupted while awaiting the cleaner lock, cannot continue execution beyond this point");
            }
        }
        if (this.cleaning != null && this.cleaning.hasFailed()) {
            throw new IOException("Pointer cleaning during recovery failed", this.cleaning.getCause());
        }
    }

    public void setDeleteOnClose(boolean deleteOnClose) {
        this.pagedFile.setDeleteOnClose(deleteOnClose);
    }

    private void maybeForceCleanState(FileFlushEvent flushEvent, AsyncBlockAccessor asyncBlockAccessor, CursorContext cursorContext) throws IOException {
        if (this.cleaning != null && !this.changesSinceLastCheckpoint.get() && !this.cleaning.needed()) {
            this.clean = true;
            if (!this.pagedFile.isDeleteOnClose()) {
                this.forceState(flushEvent, asyncBlockAccessor, cursorContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() {
        if (this.closed) {
            return;
        }
        try (PagedFile pagedFile = this.pagedFile;){
            StructureWriteLog structureWriteLog = this.structureWriteLog;
            if (structureWriteLog != null) {
                structureWriteLog.close();
            }
        }
        finally {
            this.closed = true;
        }
    }

    private void bumpUnstableGeneration() {
        this.generation = Generation.generation(Generation.stableGeneration(this.generation), Generation.unstableGeneration(this.generation) + 1L);
    }

    private void forceState(FileFlushEvent flushEvent, AsyncBlockAccessor asyncBlockAccessor, CursorContext cursorContext) throws IOException {
        if (this.changesSinceLastCheckpoint.get()) {
            throw new IllegalStateException("It seems that this method has been called in the wrong state. It's expected that this is called after opening this tree, but before any changes have been made");
        }
        this.writeState(this.pagedFile, Header.CARRY_OVER_PREVIOUS_HEADER, cursorContext);
        this.pagedFile.flushAndForce(flushEvent, asyncBlockAccessor);
    }

    private CleanupJob createCleanupJob(RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean needsCleaning) {
        if (!needsCleaning) {
            return CleanupJob.CLEAN;
        }
        this.cleanerLock = new CountDownLatch(1);
        this.monitor.cleanupRegistered();
        CrashGenerationCleaner crashGenerationCleaner = this.rootLayer.createCrashGenerationCleaner(this.contextFactory);
        GBPTreeCleanupJob cleanupJob = new GBPTreeCleanupJob(crashGenerationCleaner, this.cleanerLock, this.monitor, this.indexFile);
        recoveryCleanupWorkCollector.add(cleanupJob);
        return cleanupJob;
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContextFactory contextFactory, int numThreads, ProgressMonitorFactory progressMonitorFactory) {
        return this.consistencyCheck((GBPTreeConsistencyCheckVisitor)reporterFactory.getClass(GBPTreeConsistencyCheckVisitor.class), true, contextFactory, numThreads, progressMonitorFactory);
    }

    public boolean consistencyCheck(GBPTreeConsistencyCheckVisitor visitor, boolean reportDirty, CursorContextFactory contextFactory, int numThreads, ProgressMonitorFactory progressMonitorFactory) {
        CleanTrackingConsistencyCheckVisitor cleanTrackingVisitor = new CleanTrackingConsistencyCheckVisitor(visitor);
        try (CursorContext context = contextFactory.create("consistencyCheck");
             GBPTreeConsistencyChecker.ConsistencyCheckState state = new GBPTreeConsistencyChecker.ConsistencyCheckState(this.indexFile, this.freeList, visitor, CursorCreator.bind(this.pagedFile, 1, context), numThreads, progressMonitorFactory);){
            if (this.dirtyOnStartup && reportDirty) {
                cleanTrackingVisitor.dirtyOnStartup(this.indexFile);
            }
            this.rootLayer.consistencyCheck(state, cleanTrackingVisitor, reportDirty, contextFactory, numThreads);
        }
        catch (MetadataMismatchException | TreeInconsistencyException | CursorException e) {
            cleanTrackingVisitor.exception((Exception)e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return cleanTrackingVisitor.isConsistent();
    }

    @VisibleForTesting
    public <K, V> void unsafe(GBPTreeUnsafe<K, V> unsafe, CursorContext cursorContext) throws IOException {
        this.unsafe(unsafe, true, cursorContext);
    }

    @VisibleForTesting
    public <K, V> void unsafe(GBPTreeUnsafe<K, V> unsafe, boolean dataTree, CursorContext cursorContext) throws IOException {
        this.rootLayer.unsafe(unsafe, dataTree, cursorContext);
    }

    @VisibleForTesting
    public int leafMaxKeyCount() {
        return this.rootLayer.leafNodeMaxKeys();
    }

    public String toString() {
        long generation = this.generation;
        return String.format("GB+Tree[file:%s, layout:%s, generation:%d/%d]", this.indexFile.toAbsolutePath(), this.layout, Generation.stableGeneration(generation), Generation.unstableGeneration(generation));
    }

    private <E extends Throwable> void appendTreeInformation(E e) {
        e.addSuppressed(new Exception(e.getMessage() + " | " + String.valueOf(this)));
    }

    public int keyValueSizeCap() {
        return this.rootLayer.keyValueSizeCap();
    }

    @VisibleForTesting
    int inlineKeyValueSizeCap() {
        return this.rootLayer.inlineKeyValueSizeCap();
    }

    public long sizeInBytes() {
        try {
            return this.pagedFile.fileSize();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void visitAllRoots(CursorContext cursorContext, RootLayer.TreeRootsVisitor<ROOT_KEY> visitor) throws IOException {
        this.rootLayer.visitAllDataTreeRoots(cursorContext, visitor);
    }

    public void visitRoots(CursorContext cursorContext, RootLayer.TreeRootsVisitor<ROOT_KEY> visitor, ROOT_KEY fromInclusiveKey, ROOT_KEY toExclusiveKey) throws IOException {
        this.rootLayer.visitDataTreeRoots(cursorContext, visitor, fromInclusiveKey, toExclusiveKey);
    }

    @VisibleForTesting
    public <VISITOR extends GBPTreeVisitor<ROOT_KEY, KEY, VALUE>> VISITOR visit(VISITOR visitor, CursorContext cursorContext) throws IOException {
        this.rootLayer.visit(visitor, cursorContext);
        return visitor;
    }

    public void printTree(CursorContext cursorContext) throws IOException {
        this.printTree(PrintConfig.defaults(), cursorContext);
    }

    public void printTree(PrintConfig printConfig, CursorContext cursorContext) throws IOException {
        this.visit(new PrintingGBPTreeVisitor(printConfig), cursorContext);
    }

    public void printState(CursorContext cursorContext) throws IOException {
        try (PageCursor cursor = this.pagedFile.io(0L, 1, cursorContext);){
            GBPTreeStructure.visitTreeState(cursor, new PrintingGBPTreeVisitor(PrintConfig.defaults().printState()));
        }
    }

    void printNode(long id, CursorContext cursorContext) throws IOException {
        if (id <= this.freeList.lastId()) {
            try (PageCursor cursor = this.pagedFile.io(id, 2, cursorContext);){
                cursor.next();
                byte nodeType = TreeNodeUtil.nodeType(cursor);
                if (nodeType == 1) {
                    this.rootLayer.printNode(cursor, cursorContext);
                }
            }
        }
    }

    private static ImmutableSet<OpenOption> treeOpenOptions(ImmutableSet<OpenOption> openOptions) {
        return openOptions.newWithout((Object)PageCacheOpenOptions.MULTI_VERSIONED);
    }

    protected static <KEY, VALUE> OffloadStoreImpl<KEY, VALUE> buildOffload(Layout<KEY, VALUE> layout, IdProvider idProvider, PagedFile pagedFile, int pageSize) {
        OffloadIdValidator idValidator = id -> id >= 3L && id <= pagedFile.getLastPageId();
        return new OffloadStoreImpl<KEY, VALUE>(layout, idProvider, (arg_0, arg_1, arg_2) -> ((PagedFile)pagedFile).io(arg_0, arg_1, arg_2), idValidator, pageSize);
    }

    private static void verifyPayloadSize(PagedFile pagedFile, CursorContext cursorContext) throws IOException {
        int metaPayloadSize;
        if (pagedFile.getLastPageId() >= 0L && (metaPayloadSize = RootLayerSupport.readMeta(pagedFile, cursorContext).getPayloadSize()) != 0 && metaPayloadSize != pagedFile.payloadSize()) {
            throw new MetadataMismatchException(String.format("Tried to open the tree using page payload size %d, but the tree was original created with page payload size %d so cannot be opened.", pagedFile.payloadSize(), metaPayloadSize));
        }
    }

    public static interface Monitor {
        public void checkpointStarted();

        public void checkpointCompleted();

        public void noStoreFile();

        public void needRecreation();

        public void cleanupRegistered();

        public void cleanupStarted();

        public void cleanupFinished(long var1, long var3, long var5, long var7);

        public void cleanupClosed();

        public void cleanupFailed(Throwable var1);

        public void startupState(boolean var1);

        public void treeGrowth();

        public void treeShrink();

        public static class Delegate
        implements Monitor {
            private final Monitor delegate;

            public Delegate(Monitor delegate) {
                this.delegate = delegate;
            }

            @Override
            public void checkpointStarted() {
                this.delegate.checkpointStarted();
            }

            @Override
            public void checkpointCompleted() {
                this.delegate.checkpointCompleted();
            }

            @Override
            public void noStoreFile() {
                this.delegate.noStoreFile();
            }

            @Override
            public void needRecreation() {
                this.delegate.needRecreation();
            }

            @Override
            public void cleanupRegistered() {
                this.delegate.cleanupRegistered();
            }

            @Override
            public void cleanupStarted() {
                this.delegate.cleanupStarted();
            }

            @Override
            public void cleanupFinished(long numberOfPagesVisited, long numberOfTreeNodes, long numberOfCleanedCrashPointers, long durationMillis) {
                this.delegate.cleanupFinished(numberOfPagesVisited, numberOfTreeNodes, numberOfCleanedCrashPointers, durationMillis);
            }

            @Override
            public void cleanupClosed() {
                this.delegate.cleanupClosed();
            }

            @Override
            public void cleanupFailed(Throwable throwable) {
                this.delegate.cleanupFailed(throwable);
            }

            @Override
            public void startupState(boolean clean) {
                this.delegate.startupState(clean);
            }

            @Override
            public void treeGrowth() {
                this.delegate.treeGrowth();
            }

            @Override
            public void treeShrink() {
                this.delegate.treeShrink();
            }
        }

        public static class Adaptor
        implements Monitor {
            @Override
            public void checkpointStarted() {
            }

            @Override
            public void checkpointCompleted() {
            }

            @Override
            public void noStoreFile() {
            }

            @Override
            public void needRecreation() {
            }

            @Override
            public void cleanupRegistered() {
            }

            @Override
            public void cleanupStarted() {
            }

            @Override
            public void cleanupFinished(long numberOfPagesVisited, long numberOfTreeNodes, long numberOfCleanedCrashPointers, long durationMillis) {
            }

            @Override
            public void cleanupClosed() {
            }

            @Override
            public void cleanupFailed(Throwable throwable) {
            }

            @Override
            public void startupState(boolean clean) {
            }

            @Override
            public void treeGrowth() {
            }

            @Override
            public void treeShrink() {
            }
        }
    }

    private record OpenResult(PagedFile pagedFile, boolean created) {
    }
}

