/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.neo4j.index.internal.gbptree.Layout;

class KeyPartitioning {
    KeyPartitioning() {
    }

    public static <KEY> List<KEY> partition(Layout<KEY, ?> layout, SortedSet<KEY> keyCandidates, KEY fromInclusive, KEY toExclusive, int numberOfPartitions) {
        List<Object> keys = keyCandidates.stream().filter(key -> layout.compare(key, fromInclusive) > 0 && layout.compare(key, toExclusive) < 0).toList();
        ArrayList<Object> partitions = new ArrayList<Object>();
        partitions.add(fromInclusive);
        float stride = Math.max((1.0f + (float)keys.size()) / (float)numberOfPartitions, 1.0f);
        for (int i = 0; i < numberOfPartitions - 1 && i < keys.size(); ++i) {
            float pos = (float)(i + 1) * stride;
            Object split = keys.get(Math.round(pos) - 1);
            partitions.add(split);
        }
        partitions.add(toExclusive);
        return partitions;
    }
}

