/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import org.eclipse.collections.impl.map.mutable.primitive.IntIntHashMap;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.OffloadStoreImpl;
import org.neo4j.index.internal.gbptree.Overflow;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;
import org.neo4j.util.VisibleForTesting;

public class DynamicSizeUtil {
    public static final int OFFSET_SIZE = 2;
    public static final int KEY_OFFSET_AND_CHILD_SIZE = 26;
    public static final int BYTE_POS_ALLOC_OFFSET = 82;
    public static final int BYTE_POS_DEAD_SPACE = 84;
    public static final int HEADER_LENGTH_DYNAMIC = 86;
    static final int MIN_SIZE_KEY_VALUE_SIZE = 1;
    static final int MAX_SIZE_KEY_VALUE_SIZE = 4;
    static final int SIZE_OFFLOAD_ID = 8;
    @VisibleForTesting
    static final int SUPPORTED_PAGE_SIZE_LIMIT = (int)ByteUnit.kibiBytes((long)64L);
    private static final int FLAG_FIRST_BYTE_TOMBSTONE = 128;
    private static final int FLAG_SECOND_BYTE_OFFLOAD = 128;
    private static final long FLAG_READ_TOMBSTONE = Long.MIN_VALUE;
    private static final long FLAG_READ_OFFLOAD = 0x4000000000000000L;
    static final int MASK_ONE_BYTE_KEY_SIZE = 31;
    static final int MAX_TWO_BYTE_KEY_SIZE = 4095;
    static final int MASK_ONE_BYTE_VALUE_SIZE = 127;
    static final int MAX_TWO_BYTE_VALUE_SIZE = Short.MAX_VALUE;
    private static final int FLAG_HAS_VALUE_SIZE = 32;
    private static final int FLAG_ADDITIONAL_KEY_SIZE = 64;
    private static final int FLAG_ADDITIONAL_VALUE_SIZE = 128;
    private static final int SHIFT_LSB_KEY_SIZE = 5;
    private static final int SHIFT_LSB_VALUE_SIZE = 7;
    private static final int FIXED_MAX_KEY_VALUE_SIZE_CAP = 8175;
    static final int LEAST_NUMBER_OF_ENTRIES_PER_PAGE = 2;
    private static final int MINIMUM_ENTRY_SIZE_CAP = 8;

    public static void putKeyValueSize(PageCursor cursor, int keySize, int valueSize) {
        boolean hasAdditionalKeySize = keySize > 31;
        boolean hasValueSize = valueSize > 0;
        byte firstByte = (byte)(keySize & 0x1F);
        if (hasAdditionalKeySize) {
            firstByte = (byte)(firstByte | 0x40);
            if (keySize > 4095) {
                throw new IllegalArgumentException(String.format("Max supported inline key size is %d, but tried to store key of size %d.", 4095, keySize));
            }
        }
        if (hasValueSize) {
            firstByte = (byte)(firstByte | 0x20);
        }
        cursor.putByte(firstByte);
        if (hasAdditionalKeySize) {
            cursor.putByte((byte)(keySize >> 5));
        }
        if (hasValueSize) {
            boolean needsAdditionalValueSize = valueSize > 127;
            byte firstByte2 = (byte)(valueSize & 0x7F);
            if (needsAdditionalValueSize) {
                if (valueSize > Short.MAX_VALUE) {
                    throw new IllegalArgumentException(String.format("Max supported value size is %d, but tried to store value of size %d.", Short.MAX_VALUE, valueSize));
                }
                firstByte2 = (byte)(firstByte2 | 0x80);
            }
            cursor.putByte(firstByte2);
            if (needsAdditionalValueSize) {
                cursor.putByte((byte)(valueSize >> 7));
            }
        }
    }

    public static void putOffloadMarker(PageCursor cursor) {
        cursor.putByte((byte)64);
        cursor.putByte((byte)-128);
    }

    public static long readKeyValueSize(PageCursor cursor) {
        long valueSize;
        long keySize;
        byte firstByte = cursor.getByte();
        boolean hasTombstone = DynamicSizeUtil.hasTombstone(firstByte);
        boolean hasAdditionalKeySize = (firstByte & 0x40) != 0;
        boolean hasValueSize = (firstByte & 0x20) != 0;
        int keySizeLsb = firstByte & 0x1F;
        if (hasAdditionalKeySize) {
            byte secondByte = cursor.getByte();
            if (DynamicSizeUtil.hasOffload(secondByte)) {
                return (hasTombstone ? Long.MIN_VALUE : 0L) | 0x4000000000000000L;
            }
            int keySizeMsb = secondByte & 0xFF;
            keySize = keySizeMsb << 5 | keySizeLsb;
        } else {
            keySize = keySizeLsb;
        }
        if (hasValueSize) {
            boolean hasAdditionalValueSize;
            byte firstValueByte = cursor.getByte();
            int valueSizeLsb = firstValueByte & 0x7F;
            boolean bl = hasAdditionalValueSize = (firstValueByte & 0x80) != 0;
            if (hasAdditionalValueSize) {
                int valueSizeMsb = cursor.getByte() & 0xFF;
                valueSize = valueSizeMsb << 7 | valueSizeLsb;
            } else {
                valueSize = valueSizeLsb;
            }
        } else {
            valueSize = 0L;
        }
        return (hasTombstone ? Long.MIN_VALUE : 0L) | keySize << 32 | valueSize;
    }

    public static int extractValueSize(long keyValueSize) {
        return (int)keyValueSize;
    }

    public static int extractKeySize(long keyValueSize) {
        return (int)((keyValueSize & 0x3FFFFFFFFFFFFFFFL) >>> 32);
    }

    public static int getOverhead(int keySize, int valueSize, boolean offload) {
        if (offload) {
            return 10;
        }
        return 1 + (keySize > 31 ? 1 : 0) + (valueSize > 0 ? 1 : 0) + (valueSize > 127 ? 1 : 0);
    }

    static boolean extractTombstone(long keyValueSize) {
        return (keyValueSize & Long.MIN_VALUE) != 0L;
    }

    static boolean extractOffload(long keyValueSize) {
        return (keyValueSize & 0x4000000000000000L) != 0L;
    }

    static void putTombstone(PageCursor cursor) {
        int offset = cursor.getOffset();
        byte firstByte = cursor.getByte();
        firstByte = DynamicSizeUtil.withTombstoneFlag(firstByte);
        cursor.setOffset(offset);
        cursor.putByte(firstByte);
    }

    private static boolean hasTombstone(byte firstKeySizeByte) {
        return (firstKeySizeByte & 0x80) != 0;
    }

    private static byte withTombstoneFlag(byte firstByte) {
        assert ((firstByte & 0x80) == 0) : "First key size byte " + firstByte + " is too large to fit tombstone.";
        return (byte)(firstByte | 0x80);
    }

    private static boolean hasOffload(long secondByte) {
        return (secondByte & 0x80L) != 0L;
    }

    static long readOffloadId(PageCursor cursor) {
        return cursor.getLong();
    }

    static void putOffloadId(PageCursor cursor, long offloadId) {
        cursor.putLong(offloadId);
    }

    static long offloadIdAt(PageCursor cursor) {
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        if (offload) {
            return DynamicSizeUtil.readOffloadId(cursor);
        }
        return -1L;
    }

    static void redirectCursor(PageCursor cursor, int offset, int headerLength, int payloadSize) {
        cursor.setOffset(offset);
        int targetOffset = PageCursorUtil.getUnsignedShort((PageCursor)cursor);
        if (targetOffset >= payloadSize || targetOffset < headerLength) {
            cursor.setCursorException(String.format("Tried to read key on offset=%d, headerLength=%d, payloadSize=%d, offset=%d", targetOffset, headerLength, payloadSize, offset));
            return;
        }
        cursor.setOffset(targetOffset);
    }

    static int getDeadSpace(PageCursor cursor) {
        return PageCursorUtil.getUnsignedShort((PageCursor)cursor, (int)84);
    }

    static void setAllocOffset(PageCursor cursor, int allocOffset) {
        PageCursorUtil.putUnsignedShort((PageCursor)cursor, (int)82, (int)allocOffset);
    }

    static int getAllocOffset(PageCursor cursor) {
        return PageCursorUtil.getUnsignedShort((PageCursor)cursor, (int)82);
    }

    @VisibleForTesting
    static void setDeadSpace(PageCursor cursor, int deadSpace) {
        PageCursorUtil.putUnsignedShort((PageCursor)cursor, (int)84, (int)deadSpace);
    }

    static int getAllocSpace(PageCursor cursor, int endOfOffsetArray) {
        int allocOffset = DynamicSizeUtil.getAllocOffset(cursor);
        return allocOffset - endOfOffsetArray;
    }

    static Overflow calculateOverflow(int neededSpace, int deadSpace, int allocSpace) {
        return neededSpace <= allocSpace ? Overflow.NO : (neededSpace <= allocSpace + deadSpace ? Overflow.NO_NEED_DEFRAG : Overflow.YES);
    }

    static void compactToRight(PageCursor cursor, int count, int offsetCount, int[] offsets, int[] sizes, int rightBoundary, IntToIntFunction posToOffsetFunction) {
        IntIntHashMap remappedOffsets = DynamicSizeUtil.compactRight(cursor, count, offsets, sizes, rightBoundary);
        if (!remappedOffsets.isEmpty()) {
            DynamicSizeUtil.remapOffsets(cursor, offsetCount, remappedOffsets, posToOffsetFunction);
        }
    }

    private static void remapOffsets(PageCursor cursor, int keyCount, IntIntHashMap remappedOffsets, IntToIntFunction posToOffsetFunction) {
        for (int pos = 0; pos < keyCount; ++pos) {
            int keyPosOffset = posToOffsetFunction.valueOf(pos);
            cursor.setOffset(keyPosOffset);
            int keyOffset = PageCursorUtil.getUnsignedShort((PageCursor)cursor);
            int remappedKeyOffset = remappedOffsets.getIfAbsent(keyOffset, keyOffset);
            if (remappedKeyOffset == keyOffset) continue;
            cursor.setOffset(keyPosOffset);
            PageCursorUtil.putUnsignedShort((PageCursor)cursor, (int)remappedKeyOffset);
        }
    }

    private static IntIntHashMap compactRight(PageCursor cursor, int keyCount, int[] offsets, int[] sizes, int rightBoundary) {
        int targetOffset = rightBoundary;
        IntIntHashMap remappedOffsets = new IntIntHashMap();
        for (int index = keyCount - 1; index >= 0; --index) {
            int sourceOffset = offsets[index];
            int entrySize = sizes[index];
            if (sourceOffset == (targetOffset -= entrySize)) continue;
            cursor.copyTo(sourceOffset, cursor, targetOffset, entrySize);
            remappedOffsets.put(sourceOffset, targetOffset);
        }
        int prevAllocOffset = DynamicSizeUtil.getAllocOffset(cursor);
        DynamicSizeUtil.setAllocOffset(cursor, targetOffset);
        DynamicSizeUtil.zeroPad(cursor, prevAllocOffset, targetOffset - prevAllocOffset);
        return remappedOffsets;
    }

    private static void zeroPad(PageCursor fromCursor, int fromOffset, int lengthInBytes) {
        fromCursor.setOffset(fromOffset);
        fromCursor.putBytes(lengthInBytes, (byte)0);
    }

    static void recordAliveBlocks(PageCursor cursor, int keyCount, int[] offsets, int[] sizes, int payloadSize) {
        int entrySize;
        int index = 0;
        for (int currentOffset = DynamicSizeUtil.getAllocOffset(cursor); currentOffset < payloadSize && index < keyCount; currentOffset += entrySize) {
            cursor.setOffset(currentOffset);
            long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
            int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
            int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
            boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
            boolean dead = DynamicSizeUtil.extractTombstone(keyValueSize);
            entrySize = keySize + valueSize + DynamicSizeUtil.getOverhead(keySize, valueSize, offload);
            if (dead) continue;
            offsets[index] = currentOffset;
            sizes[index] = entrySize;
            ++index;
        }
        assert (index == keyCount) : "expected " + keyCount + " alive blocks, found only " + index;
    }

    public static int keyValueSizeCapFromPageSize(int pageSize) {
        return Math.min(8175, OffloadStoreImpl.keyValueSizeCapFromPageSize(pageSize));
    }

    static int inlineKeyValueSizeCapLeafNode(int payloadSize) {
        int totalOverhead = 6;
        int capToFitNumberOfEntriesPerPage = (payloadSize - 86) / 2 - totalOverhead;
        return Math.min(4095, capToFitNumberOfEntriesPerPage);
    }

    static int inlineKeyValueSizeCapInternalNode(int payloadSize) {
        int totalOverhead = 84;
        int capToFitNumberOfEntriesPerPage = (payloadSize - 86 - totalOverhead) / 2;
        return Math.min(4095, capToFitNumberOfEntriesPerPage);
    }

    static void validateInlineCap(int inlineKeyValueSizeCap, int payloadSize) {
        if (inlineKeyValueSizeCap < 8) {
            throw new MetadataMismatchException(String.format("We need to fit at least %d key-value entries per page in leaves. To do that a key-value entry can be at most %dB with current page size of %dB. We require this cap to be at least %dB.", 2, inlineKeyValueSizeCap, payloadSize, 8));
        }
    }
}

