/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import org.neo4j.common.DependencyResolver;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.index.internal.gbptree.CrashGenerationCleaner;
import org.neo4j.index.internal.gbptree.CursorCreator;
import org.neo4j.index.internal.gbptree.DataTree;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyChecker;
import org.neo4j.index.internal.gbptree.GBPTreeStructure;
import org.neo4j.index.internal.gbptree.GBPTreeUnsafe;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeWriter;
import org.neo4j.index.internal.gbptree.Generation;
import org.neo4j.index.internal.gbptree.InternalNodeBehaviour;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LeafNodeBehaviour;
import org.neo4j.index.internal.gbptree.OffloadStoreImpl;
import org.neo4j.index.internal.gbptree.PrintConfig;
import org.neo4j.index.internal.gbptree.PrintingGBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.RootLayer;
import org.neo4j.index.internal.gbptree.RootLayerSupport;
import org.neo4j.index.internal.gbptree.SeekCursor;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.SingleRoot;
import org.neo4j.index.internal.gbptree.TreeNodeSelector;
import org.neo4j.index.internal.gbptree.TreeWriterCoordination;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.util.Preconditions;

class SingleRootLayer<KEY, VALUE>
extends RootLayer<SingleRoot, KEY, VALUE> {
    private final Layout<KEY, VALUE> layout;
    private final LeafNodeBehaviour<KEY, VALUE> leafNode;
    private final InternalNodeBehaviour<KEY> internalNode;
    private final SingleDataTree singleRootAccess;

    SingleRootLayer(RootLayerSupport support, Layout<KEY, VALUE> layout, TreeNodeSelector treeNodeSelector, DependencyResolver dependencyResolver) {
        super(support, treeNodeSelector);
        this.layout = layout;
        TreeNodeSelector.Factory format = treeNodeSelector.selectByLayout(layout);
        OffloadStoreImpl<KEY, VALUE> offloadStore = support.buildOffload(layout);
        this.leafNode = format.createLeafBehaviour(support.payloadSize(), layout, offloadStore, dependencyResolver);
        this.internalNode = format.createInternalBehaviour(support.payloadSize(), layout, offloadStore, dependencyResolver);
        this.singleRootAccess = new SingleDataTree();
    }

    @Override
    public void initializeAfterCreation(Root firstRoot, CursorContext cursorContext) throws IOException {
        this.setRoot(firstRoot, cursorContext);
        this.support.writeMeta(null, this.layout, cursorContext, this.treeNodeSelector);
        this.support.initializeNewRoot(this.root, this.leafNode, (byte)0, cursorContext);
    }

    @Override
    void initialize(Root root, CursorContext cursorContext) throws IOException {
        this.setRoot(root, cursorContext);
        this.support.readMeta(cursorContext).verify(this.layout, (Layout)null, this.treeNodeSelector);
    }

    @Override
    public void create(SingleRoot dataRootKey, CursorContext cursorContext) {
        this.singleRootException();
    }

    @Override
    public void delete(SingleRoot dataRootKey, CursorContext cursorContext) {
        this.singleRootException();
    }

    private void singleRootException() {
        throw new UnsupportedOperationException("This is a single-data-tree GBPTree, which means it always has one data tree which cannot be deleted and no more data trees can be created");
    }

    @Override
    public DataTree<KEY, VALUE> access(SingleRoot dataRootKey) {
        return this.singleRootAccess;
    }

    @Override
    public void visit(GBPTreeVisitor<SingleRoot, KEY, VALUE> visitor, CursorContext cursorContext) throws IOException {
        try (PageCursor cursor = this.support.openRootCursor(this.root, 1, cursorContext);){
            long generation = this.support.generation();
            GBPTreeStructure<SingleRoot, KEY, VALUE> structure = new GBPTreeStructure<SingleRoot, KEY, VALUE>(null, null, null, this.layout, this.leafNode, this.internalNode, Generation.stableGeneration(generation), Generation.unstableGeneration(generation));
            structure.visitTree(cursor, visitor, cursorContext);
            this.support.idProvider().visitFreelist(visitor, CursorCreator.bind(this.support, 1, cursorContext));
        }
    }

    @Override
    public void consistencyCheck(GBPTreeConsistencyChecker.ConsistencyCheckState state, GBPTreeConsistencyCheckVisitor visitor, boolean reportDirty, CursorContextFactory contextFactory, int numThreads) throws IOException {
        long generation = this.support.generation();
        PagedFile pagedFile = this.support.pagedFile();
        new GBPTreeConsistencyChecker<KEY>(this.leafNode, this.internalNode, this.layout, state, numThreads, Generation.stableGeneration(generation), Generation.unstableGeneration(generation), reportDirty, pagedFile.path(), (ThrowingFunction<CursorContext, PageCursor, IOException>)((ThrowingFunction)ctx -> pagedFile.io(0L, 1, ctx)), this.root, contextFactory).check(visitor, state.progress, GBPTreeConsistencyChecker.NO_MONITOR);
        state.awaitAllSubtasks();
    }

    @Override
    public int keyValueSizeCap() {
        return this.leafNode.keyValueSizeCap();
    }

    @Override
    public int inlineKeyValueSizeCap() {
        return this.leafNode.inlineKeyValueSizeCap();
    }

    @Override
    int leafNodeMaxKeys() {
        return this.leafNode.maxKeyCount();
    }

    @Override
    void visitAllDataTreeRoots(CursorContext cursorContext, RootLayer.TreeRootsVisitor<SingleRoot> visitor) {
        visitor.accept(SingleRoot.SINGLE_ROOT);
    }

    @Override
    void unsafe(GBPTreeUnsafe unsafe, boolean dataTree, CursorContext cursorContext) throws IOException {
        Preconditions.checkState((boolean)dataTree, (String)"Can only operate on data tree");
        this.support.unsafe(unsafe, this.layout, this.leafNode, this.internalNode, cursorContext);
    }

    @Override
    CrashGenerationCleaner createCrashGenerationCleaner(CursorContextFactory contextFactory) {
        return this.support.createCrashGenerationCleaner(null, this.internalNode, contextFactory);
    }

    @Override
    void printNode(PageCursor cursor, CursorContext cursorContext) {
        try {
            long generation = this.support.generation();
            long stableGeneration = Generation.stableGeneration(generation);
            long unstableGeneration = Generation.unstableGeneration(generation);
            new GBPTreeStructure(null, null, null, this.layout, this.leafNode, this.internalNode, stableGeneration, unstableGeneration).visitTreeNode(cursor, new PrintingGBPTreeVisitor(PrintConfig.defaults()), cursorContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void clearCache() {
    }

    private class SingleDataTree
    implements DataTree<KEY, VALUE> {
        private final GBPTreeWriter<KEY, VALUE> batchedWriter;

        SingleDataTree() {
            this.batchedWriter = SingleRootLayer.this.support.newWriter(SingleRootLayer.this.layout, SingleRootLayer.this, SingleRootLayer.this.leafNode, SingleRootLayer.this.internalNode, TreeWriterCoordination.NO_COORDINATION, false, (byte)0);
        }

        @Override
        public Seeker<KEY, VALUE> allocateSeeker(CursorContext cursorContext) throws IOException {
            return SingleRootLayer.this.support.internalAllocateSeeker(SingleRootLayer.this.layout, cursorContext, SingleRootLayer.this.leafNode, SingleRootLayer.this.internalNode);
        }

        @Override
        public Seeker<KEY, VALUE> seek(Seeker<KEY, VALUE> seeker, KEY fromInclusive, KEY toExclusive) throws IOException {
            return SingleRootLayer.this.support.initializeSeeker(seeker, SingleRootLayer.this, fromInclusive, toExclusive, 20, Integer.MAX_VALUE, SeekCursor.NO_MONITOR);
        }

        @Override
        public List<KEY> partitionedSeek(KEY fromInclusive, KEY toExclusive, int numberOfPartitions, CursorContext cursorContext) throws IOException {
            return SingleRootLayer.this.support.internalPartitionedSeek(SingleRootLayer.this.layout, SingleRootLayer.this.leafNode, SingleRootLayer.this.internalNode, fromInclusive, toExclusive, numberOfPartitions, SingleRootLayer.this, cursorContext);
        }

        @Override
        public Writer<KEY, VALUE> writer(int flags, CursorContext cursorContext) throws IOException {
            double splitRatio = RootLayer.splitRatio(flags);
            if ((flags & 1) != 0) {
                return SingleRootLayer.this.support.initializeWriter(this.batchedWriter, splitRatio, cursorContext);
            }
            return SingleRootLayer.this.support.internalParallelWriter(SingleRootLayer.this.layout, SingleRootLayer.this.leafNode, SingleRootLayer.this.internalNode, splitRatio, cursorContext, SingleRootLayer.this, (byte)0);
        }

        @Override
        public long estimateNumberOfEntriesInTree(CursorContext cursorContext) throws IOException {
            return SingleRootLayer.this.support.estimateNumberOfEntriesInTree(SingleRootLayer.this.layout, SingleRootLayer.this.leafNode, SingleRootLayer.this.internalNode, SingleRootLayer.this, cursorContext);
        }

        @Override
        public boolean exists(CursorContext cursorContext) {
            return true;
        }
    }
}

