/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.CombiningIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.index.IndexHits;
import org.neo4j.index.ReadOnlyIndexException;
import org.neo4j.index.impl.GenericIndexService;
import org.neo4j.index.impl.IdToNodeIterator;
import org.neo4j.index.impl.SimpleIndexHits;
import org.neo4j.index.lucene.DocToIdIterator;
import org.neo4j.index.lucene.Hits;
import org.neo4j.index.lucene.HitsIterator;
import org.neo4j.index.lucene.LuceneReadOnlyDataSource;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.impl.cache.LruCache;

public class LuceneReadOnlyIndexService
extends GenericIndexService {
    protected static final String DOC_ID_KEY = "id";
    protected static final String DOC_INDEX_KEY = "index";
    private final LuceneReadOnlyDataSource xaDs;
    private int lazynessThreshold = 100;

    public LuceneReadOnlyIndexService(GraphDatabaseService graphDb) {
        super(graphDb);
        this.xaDs = new LuceneReadOnlyDataSource(((AbstractGraphDatabase)graphDb).getStoreDir() + "/" + this.getDirName());
    }

    protected String getDirName() {
        return "lucene";
    }

    protected Field.Index getIndexStrategy() {
        return Field.Index.NOT_ANALYZED;
    }

    public void enableCache(String key, int maxNumberOfCachedEntries) {
        this.xaDs.enableCache(key, maxNumberOfCachedEntries);
    }

    @Override
    protected void indexThisTx(Node node, String key, Object value) {
        throw new ReadOnlyIndexException();
    }

    public void setLazySearchResultThreshold(int numberOfHitsBeforeLazyLoading) {
        this.lazynessThreshold = numberOfHitsBeforeLazyLoading;
        this.xaDs.invalidateCache();
    }

    public int getLazySearchResultThreshold() {
        return this.lazynessThreshold;
    }

    @Override
    public IndexHits<Node> getNodes(String key, Object value) {
        return this.getNodes(key, value, null);
    }

    public IndexHits<Node> getNodes(String key, Object value, Sort sortingOrNull) {
        ArrayList<Long> nodeIds = new ArrayList<Long>();
        IndexSearcher searcher = this.xaDs.getIndexSearcher(key);
        CombiningIterator nodeIdIterator = null;
        Integer nodeIdIteratorSize = null;
        if (searcher != null) {
            Collection cachedNodes;
            LruCache<String, Collection<Long>> cachedNodesMap = this.xaDs.getFromCache(key);
            boolean foundInCache = false;
            String valueAsString = value.toString();
            if (cachedNodesMap != null && (cachedNodes = (Collection)cachedNodesMap.get((Object)valueAsString)) != null) {
                foundInCache = true;
                nodeIds.addAll(cachedNodes);
            }
            if (!foundInCache) {
                DocToIdIterator searchedNodeIds = this.searchForNodes(key, value, sortingOrNull);
                if (searchedNodeIds.size() >= this.lazynessThreshold) {
                    if (cachedNodesMap != null) {
                        cachedNodesMap.remove((Object)valueAsString);
                    }
                    ArrayList<Object> iterators = new ArrayList<Object>();
                    iterators.add(nodeIds.iterator());
                    iterators.add((Object)searchedNodeIds);
                    nodeIdIterator = new CombiningIterator(iterators);
                    nodeIdIteratorSize = nodeIds.size() + searchedNodeIds.size();
                } else {
                    ArrayList<Long> readNodeIds = new ArrayList<Long>();
                    while (searchedNodeIds.hasNext()) {
                        Long readNodeId = (Long)searchedNodeIds.next();
                        nodeIds.add(readNodeId);
                        readNodeIds.add(readNodeId);
                    }
                    if (cachedNodesMap != null) {
                        cachedNodesMap.put((Object)valueAsString, readNodeIds);
                    }
                }
            }
        }
        if (nodeIdIterator == null) {
            nodeIdIterator = nodeIds.iterator();
            nodeIdIteratorSize = nodeIds.size();
        }
        return new SimpleIndexHits<Node>(IteratorUtil.asIterable(this.instantiateIdToNodeIterator((Iterator<Long>)nodeIdIterator)), (int)nodeIdIteratorSize);
    }

    protected Iterator<Node> instantiateIdToNodeIterator(Iterator<Long> ids) {
        return new IdToNodeIterator(ids, this.getGraphDb());
    }

    protected Query formQuery(String key, Object value) {
        return new TermQuery(new Term(DOC_INDEX_KEY, value.toString()));
    }

    private DocToIdIterator searchForNodes(String key, Object value, Sort sortingOrNull) {
        Query query = this.formQuery(key, value);
        try {
            IndexSearcher searcher = this.xaDs.getIndexSearcher(key);
            Hits hits = new Hits((Searcher)searcher, query, null, sortingOrNull);
            return new DocToIdIterator((Iterator<Document>)((Object)new HitsIterator(hits)), Collections.<Long>emptyList(), null);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to search for " + key + "," + value, e);
        }
    }

    @Override
    public Node getSingleNode(String key, Object value) {
        Node node;
        Iterator nodes = this.getNodes(key, value).iterator();
        Node node2 = node = nodes.hasNext() ? (Node)nodes.next() : null;
        if (nodes.hasNext()) {
            throw new RuntimeException("More than one node for " + key + "=" + value);
        }
        return node;
    }

    @Override
    protected void removeIndexThisTx(Node node, String key, Object value) {
        throw new ReadOnlyIndexException();
    }

    @Override
    public void removeIndex(Node node, String key) {
        throw new ReadOnlyIndexException();
    }

    @Override
    public void removeIndex(String key) {
        throw new ReadOnlyIndexException();
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        this.xaDs.close();
    }
}

