/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.neo4j.kernel.impl.cache.LruCache;
import org.neo4j.kernel.impl.util.ArrayMap;

public class LuceneReadOnlyDataSource {
    private final ArrayMap<String, IndexSearcher> indexSearchers = new ArrayMap(6, true, true);
    private final String storeDir;
    private Map<String, LruCache<String, Collection<Long>>> caching = Collections.synchronizedMap(new HashMap());

    public LuceneReadOnlyDataSource(String directory) {
        String dir = this.storeDir = directory;
        File file = new File(dir);
        if (!file.exists()) {
            throw new RuntimeException("No such directory " + dir);
        }
    }

    public void close() {
        for (IndexSearcher searcher : this.indexSearchers.values()) {
            try {
                searcher.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.indexSearchers.clear();
    }

    IndexSearcher getIndexSearcher(String key) {
        IndexSearcher searcher = (IndexSearcher)this.indexSearchers.get((Object)key);
        if (searcher == null) {
            try {
                File fsDirectory = new File(this.storeDir, key);
                if (!fsDirectory.exists()) {
                    return null;
                }
                FSDirectory dir = FSDirectory.open((File)fsDirectory);
                if (dir.listAll().length == 0) {
                    return null;
                }
                searcher = new IndexSearcher((Directory)dir, true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.indexSearchers.put((Object)key, (Object)searcher);
        }
        return searcher;
    }

    LruCache<String, Collection<Long>> getFromCache(String key) {
        return this.caching.get(key);
    }

    void enableCache(String key, int maxNumberOfCachedEntries) {
        this.caching.put(key, (LruCache<String, Collection<Long>>)new LruCache(key, maxNumberOfCachedEntries, null));
    }

    void invalidateCache(String key, Object value) {
        LruCache<String, Collection<Long>> cache = this.caching.get(key);
        if (cache != null) {
            cache.remove((Object)value.toString());
        }
    }

    void invalidateCache() {
        this.caching.clear();
    }
}

