/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.util.Iterator;
import org.neo4j.index.IndexHits;
import org.neo4j.index.lucene.IndexSearcherRef;

class LazyIndexHits<T>
implements IndexHits<T> {
    private final IndexHits<T> hits;
    private final IndexSearcherRef searcher;

    LazyIndexHits(IndexHits<T> hits, IndexSearcherRef searcher) {
        this.hits = hits;
        this.searcher = searcher;
    }

    @Override
    public void close() {
        this.hits.close();
        if (this.searcher != null) {
            this.searcher.closeStrict();
        }
    }

    @Override
    public int size() {
        return this.hits.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.hits.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.hits.hasNext();
    }

    @Override
    public T next() {
        return (T)this.hits.next();
    }

    @Override
    public void remove() {
        this.hits.remove();
    }
}

