/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.map;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.index.impl.btree.BTree;
import org.neo4j.index.impl.btree.KeyEntry;

public class BTreeMap<K, V>
implements Map<K, V> {
    private static final Object GOTO_NODE = Long.MIN_VALUE;
    private static final String MAP_NAME = "map_name";
    private static final String MAP_KEY = "map_key";
    private static final String MAP_VALUE = "map_value";
    private final Node underlyingNode;
    private BTree bTree;
    private String name;
    private GraphDatabaseService graphDb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BTreeMap(String name, Node underlyingNode, GraphDatabaseService graphDb) {
        if (underlyingNode == null || graphDb == null) {
            throw new IllegalArgumentException("Null parameter underlyingNode=" + underlyingNode + " graphDb=" + graphDb);
        }
        this.underlyingNode = underlyingNode;
        this.graphDb = graphDb;
        Transaction tx = graphDb.beginTx();
        try {
            if (underlyingNode.hasProperty(MAP_NAME)) {
                String storedName = (String)underlyingNode.getProperty(MAP_NAME);
                if (name != null && !storedName.equals(name)) {
                    throw new IllegalArgumentException("Name of map for node=" + underlyingNode.getId() + "," + storedName + " is not same as passed in name=" + name);
                }
                this.name = name == null ? (String)underlyingNode.getProperty(MAP_NAME) : name;
            } else {
                underlyingNode.setProperty(MAP_NAME, (Object)name);
                this.name = name;
            }
            Relationship bTreeRel = underlyingNode.getSingleRelationship((RelationshipType)BTree.RelTypes.TREE_ROOT, Direction.OUTGOING);
            if (bTreeRel != null) {
                this.bTree = new BTree(graphDb, bTreeRel.getEndNode());
            } else {
                Node bTreeNode = graphDb.createNode();
                underlyingNode.createRelationshipTo(bTreeNode, (RelationshipType)BTree.RelTypes.TREE_ROOT);
                this.bTree = new BTree(graphDb, bTreeNode);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public String getName() {
        return this.name;
    }

    Node getUnderlyingNode() {
        return this.underlyingNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Null node");
        }
        Transaction tx = this.graphDb.beginTx();
        try {
            int hashCode = key.hashCode();
            KeyEntry entry = this.bTree.addIfAbsent(hashCode, value);
            if (entry != null) {
                entry.setKeyValue(key);
            } else {
                entry = this.bTree.getAsKeyEntry(hashCode);
                Object goOtherNode = entry.getKeyValue();
                Node bucketNode = null;
                if (!goOtherNode.equals(GOTO_NODE)) {
                    Object prevValue = entry.getValue();
                    Object prevKey = entry.getKeyValue();
                    if (prevKey.equals(key)) {
                        Object oldValue = entry.getValue();
                        entry.setValue(value);
                        tx.success();
                        Object object = oldValue;
                        return (V)object;
                    }
                    entry.setKeyValue(GOTO_NODE);
                    bucketNode = this.graphDb.createNode();
                    entry.setValue(bucketNode.getId());
                    Node prevEntry = this.graphDb.createNode();
                    bucketNode.createRelationshipTo(prevEntry, (RelationshipType)RelTypes.MAP_ENTRY);
                    prevEntry.setProperty(MAP_KEY, prevKey);
                    prevEntry.setProperty(MAP_VALUE, prevValue);
                    Node newEntry = this.graphDb.createNode();
                    bucketNode.createRelationshipTo(newEntry, (RelationshipType)RelTypes.MAP_ENTRY);
                    newEntry.setProperty(MAP_KEY, key);
                    newEntry.setProperty(MAP_VALUE, value);
                } else {
                    bucketNode = this.graphDb.getNodeById(((Long)entry.getValue()).longValue());
                    for (Relationship rel : bucketNode.getRelationships((RelationshipType)RelTypes.MAP_ENTRY, Direction.OUTGOING)) {
                        Node entryNode = rel.getEndNode();
                        if (!entryNode.getProperty(MAP_KEY).equals(key)) continue;
                        entryNode.setProperty(MAP_VALUE, value);
                        tx.success();
                        V v = null;
                        return v;
                    }
                    Node newEntry = this.graphDb.createNode();
                    bucketNode.createRelationshipTo(newEntry, (RelationshipType)RelTypes.MAP_ENTRY);
                    newEntry.setProperty(MAP_KEY, key);
                    newEntry.setProperty(MAP_VALUE, value);
                }
            }
            tx.success();
            V v = null;
            return v;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Transaction tx = this.graphDb.beginTx();
        try {
            int hashCode = key.hashCode();
            KeyEntry entry = this.bTree.getAsKeyEntry(hashCode);
            if (entry != null) {
                Object goOtherNode = entry.getKeyValue();
                if (!goOtherNode.equals(GOTO_NODE)) {
                    if (goOtherNode.equals(key)) {
                        Object value = entry.getValue();
                        entry.remove();
                        tx.success();
                        Object object = value;
                        return (V)object;
                    }
                } else {
                    Node bucketNode = this.graphDb.getNodeById(((Long)entry.getValue()).longValue());
                    for (Relationship rel : bucketNode.getRelationships((RelationshipType)RelTypes.MAP_ENTRY, Direction.OUTGOING)) {
                        Node entryNode = rel.getEndNode();
                        if (!entryNode.getProperty(MAP_KEY).equals(key)) continue;
                        Object value = entryNode.getProperty(MAP_VALUE);
                        rel.delete();
                        entryNode.delete();
                        tx.success();
                        Object object = value;
                        return (V)object;
                    }
                }
            }
            tx.success();
            V v = null;
            return v;
        }
        finally {
            tx.finish();
        }
    }

    void validate() {
        this.bTree.validateTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Transaction tx = this.graphDb.beginTx();
        try {
            int hashCode = key.hashCode();
            KeyEntry entry = this.bTree.getAsKeyEntry(hashCode);
            if (entry != null) {
                Object goOtherNode = entry.getKeyValue();
                if (!goOtherNode.equals(GOTO_NODE)) {
                    if (goOtherNode.equals(key)) {
                        tx.success();
                        Object object = entry.getValue();
                        return (V)object;
                    }
                } else {
                    Node bucketNode = this.graphDb.getNodeById(((Long)entry.getValue()).longValue());
                    for (Relationship rel : bucketNode.getRelationships((RelationshipType)RelTypes.MAP_ENTRY, Direction.OUTGOING)) {
                        Node entryNode = rel.getEndNode();
                        if (!entryNode.getProperty(MAP_KEY).equals(key)) continue;
                        tx.success();
                        Object object = entryNode.getProperty(MAP_VALUE);
                        return (V)object;
                    }
                }
            }
            tx.success();
            V v = null;
            return v;
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public void clear() {
        this.deleteBuckets();
        this.bTree.delete();
        Node bTreeNode = this.graphDb.createNode();
        this.underlyingNode.createRelationshipTo(bTreeNode, (RelationshipType)BTree.RelTypes.TREE_ROOT);
        this.bTree = new BTree(this.graphDb, bTreeNode);
    }

    public void delete() {
        this.deleteBuckets();
        this.bTree.delete();
        this.underlyingNode.delete();
    }

    private void deleteBuckets() {
        for (KeyEntry entry : this.bTree.entries()) {
            Object goOtherNode = entry.getKeyValue();
            if (!goOtherNode.equals(GOTO_NODE)) continue;
            Node bucketNode = this.graphDb.getNodeById(((Long)entry.getValue()).longValue());
            for (Relationship rel : bucketNode.getRelationships((RelationshipType)RelTypes.MAP_ENTRY, Direction.OUTGOING)) {
                Node entryNode = rel.getEndNode();
                rel.delete();
                entryNode.delete();
            }
            bucketNode.delete();
        }
    }

    public void delete(int commitInterval) {
        this.deleteBuckets();
        this.bTree.delete(commitInterval);
        this.underlyingNode.delete();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    static enum RelTypes implements RelationshipType
    {
        MAP_ENTRY;

    }
}

