/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.index.impl.AbstractIndex;
import org.neo4j.index.impl.btree.KeyEntry;

public class SingleValueIndex
extends AbstractIndex {
    public SingleValueIndex(String name, Node underlyingNode, GraphDatabaseService graphDb) {
        super(name, underlyingNode, graphDb);
    }

    @Override
    protected void addOrReplace(KeyEntry entry, long value) {
        entry.setValue(value);
    }

    @Override
    protected void addOrReplace(Node entryNode, long value) {
        entryNode.setProperty("index_values", (Object)value);
    }

    @Override
    protected String getIndexType() {
        return "single";
    }

    @Override
    protected long getSingleValue(KeyEntry entry) {
        return (Long)entry.getValue();
    }

    @Override
    protected long getSingleValue(Node entry) {
        return (Long)entry.getProperty("index_values");
    }

    @Override
    protected long[] getValues(KeyEntry entry) {
        return new long[]{(Long)entry.getValue()};
    }

    @Override
    protected long[] getValues(Node entry) {
        return new long[]{(Long)entry.getProperty("index_values")};
    }

    @Override
    protected boolean removeAllOrOne(KeyEntry entry, long value) {
        return true;
    }

    @Override
    protected boolean removeAllOrOne(Node entry, long value) {
        return true;
    }
}

