/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.helpers.collection.CombiningIterator;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.index.IndexHits;
import org.neo4j.index.impl.GenericIndexService;
import org.neo4j.index.impl.IdToNodeIterator;
import org.neo4j.index.impl.SimpleIndexHits;
import org.neo4j.index.lucene.DocToIdIterator;
import org.neo4j.index.lucene.Hits;
import org.neo4j.index.lucene.HitsIterator;
import org.neo4j.index.lucene.IndexSearcherRef;
import org.neo4j.index.lucene.LazyIndexHits;
import org.neo4j.index.lucene.LuceneDataSource;
import org.neo4j.index.lucene.LuceneTransaction;
import org.neo4j.index.lucene.LuceneXaConnection;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.impl.cache.LruCache;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TxModule;
import org.neo4j.kernel.impl.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndexService
extends GenericIndexService {
    public static final int DEFAULT_LAZY_SEARCH_RESULT_THRESHOLD = 100;
    protected static final String DOC_ID_KEY = "id";
    protected static final String DOC_INDEX_KEY = "index";
    protected static final String DIR_NAME = "lucene";
    private final TransactionManager txManager;
    private final ConnectionBroker broker;
    private final LuceneDataSource xaDs;
    private int lazynessThreshold = 100;

    public LuceneIndexService(GraphDatabaseService graphDb) {
        super(graphDb);
        Config config = ((AbstractGraphDatabase)graphDb).getConfig();
        String luceneDirectory = config.getTxModule().getTxLogDirectory() + "/" + this.getDirName();
        TxModule txModule = config.getTxModule();
        this.txManager = txModule.getTxManager();
        byte[] resourceId = this.getXaResourceId();
        HashMap<Object, Object> params = new HashMap<Object, Object>(config.getParams());
        params.put(LuceneIndexService.class, this);
        params.put("dir", luceneDirectory);
        params.put(LockManager.class, config.getLockManager());
        this.xaDs = (LuceneDataSource)txModule.registerDataSource(this.getDirName(), this.getDataSourceClass().getName(), resourceId, params, true);
        this.broker = new ConnectionBroker(this.txManager, this.xaDs);
        this.xaDs.setIndexService(this);
    }

    protected Class<? extends LuceneDataSource> getDataSourceClass() {
        return LuceneDataSource.class;
    }

    protected String getDirName() {
        return DIR_NAME;
    }

    protected byte[] getXaResourceId() {
        return "162373".getBytes();
    }

    public void enableCache(String key, int maxNumberOfCachedEntries) {
        this.xaDs.enableCache(key, maxNumberOfCachedEntries);
    }

    public Integer getEnabledCacheSize(String key) {
        return this.xaDs.getEnabledCacheSize(key);
    }

    public void setLazySearchResultThreshold(int numberOfHitsBeforeLazyLoading) {
        this.lazynessThreshold = numberOfHitsBeforeLazyLoading;
        this.xaDs.invalidateCache();
    }

    public int getLazySearchResultThreshold() {
        return this.lazynessThreshold;
    }

    @Override
    public void index(Node node, String key, Object value) {
        super.index(node, key, value);
    }

    @Override
    protected void indexThisTx(Node node, String key, Object value) {
        this.assertArgumentNotNull(node, "node");
        this.assertArgumentNotNull(key, "key");
        this.assertArgumentNotNull(value, "value");
        for (Object arrayItem : this.asArray(value)) {
            this.getConnection().index(node, key, arrayItem);
        }
    }

    @Override
    public IndexHits<Node> getNodes(String key, Object value) {
        return this.getNodes(key, value, null);
    }

    public IndexHits<Node> getNodes(String key, Object value, Sort sortingOrNull) {
        return this.getNodes(key, value, null, sortingOrNull);
    }

    public IndexHits<Node> getNodesExactMatch(String key, Object value) {
        return this.getNodes(key, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexHits<Node> getNodes(String key, Object value, Object matching, Sort sortingOrNull) {
        ArrayList<Long> nodeIds = new ArrayList<Long>();
        LuceneXaConnection con = this.getReadOnlyConnection();
        LuceneTransaction luceneTx = null;
        if (con != null) {
            luceneTx = this.getReadOnlyConnection().getLuceneTx();
        }
        Set<Object> addedNodes = Collections.emptySet();
        Set<Long> deletedNodes = Collections.emptySet();
        boolean deleted = false;
        if (luceneTx != null && luceneTx.hasModifications(key)) {
            addedNodes = luceneTx.getNodesFor(key, value, matching);
            nodeIds.addAll(addedNodes);
            deletedNodes = luceneTx.getDeletedNodesFor(key, value, matching);
            deleted = luceneTx.getIndexDeleted(key);
        }
        this.xaDs.getReadLock();
        CombiningIterator nodeIdIterator = null;
        Integer nodeIdIteratorSize = null;
        IndexSearcherRef searcher = null;
        boolean isLazy = false;
        try {
            String valueAsString;
            LruCache<String, Collection<Long>> cachedNodesMap;
            boolean foundInCache;
            searcher = this.xaDs.getIndexSearcher(key);
            if (searcher != null && !deleted && !(foundInCache = this.fillFromCache(cachedNodesMap = this.xaDs.getFromCache(key), nodeIds, key, valueAsString = value.toString(), deletedNodes))) {
                DocToIdIterator searchedNodeIds = this.searchForNodes(searcher, key, value, matching, sortingOrNull, deletedNodes);
                if (searchedNodeIds.size() >= this.lazynessThreshold) {
                    isLazy = true;
                    if (cachedNodesMap != null) {
                        cachedNodesMap.remove((Object)valueAsString);
                    }
                    ArrayList<Object> iterators = new ArrayList<Object>();
                    iterators.add(nodeIds.iterator());
                    iterators.add((Object)searchedNodeIds);
                    nodeIdIterator = new CombiningIterator(iterators);
                    nodeIdIteratorSize = nodeIds.size() + searchedNodeIds.size();
                } else {
                    this.readNodesFromHits(searchedNodeIds, nodeIds, cachedNodesMap, valueAsString);
                }
            }
        }
        finally {
            this.xaDs.releaseReadLock();
        }
        if (nodeIdIterator == null) {
            nodeIdIterator = nodeIds.iterator();
            nodeIdIteratorSize = nodeIds.size();
        }
        IndexHits<Node> hits = new SimpleIndexHits<Node>(IteratorUtil.asIterable((Iterator)FilteringIterator.noDuplicates(this.instantiateIdToNodeIterator((Iterator<Long>)nodeIdIterator))), (int)nodeIdIteratorSize);
        if (isLazy) {
            hits = new LazyIndexHits<Node>(hits, searcher);
        }
        return hits;
    }

    private void readNodesFromHits(DocToIdIterator searchedNodeIds, Collection<Long> nodeIds, LruCache<String, Collection<Long>> cachedNodesMap, String valueAsString) {
        ArrayList<Long> readNodeIds = new ArrayList<Long>();
        while (searchedNodeIds.hasNext()) {
            Long readNodeId = (Long)searchedNodeIds.next();
            nodeIds.add(readNodeId);
            readNodeIds.add(readNodeId);
        }
        if (cachedNodesMap != null) {
            cachedNodesMap.put((Object)valueAsString, readNodeIds);
        }
    }

    private boolean fillFromCache(LruCache<String, Collection<Long>> cachedNodesMap, List<Long> nodeIds, String key, String valueAsString, Set<Long> deletedNodes) {
        Collection cachedNodes;
        boolean found = false;
        if (cachedNodesMap != null && (cachedNodes = (Collection)cachedNodesMap.get((Object)valueAsString)) != null) {
            found = true;
            for (Long cachedNodeId : cachedNodes) {
                if (deletedNodes != null && deletedNodes.contains(cachedNodeId)) continue;
                nodeIds.add(cachedNodeId);
            }
        }
        return found;
    }

    protected Iterator<Node> instantiateIdToNodeIterator(Iterator<Long> ids) {
        return new IdToNodeIterator(ids, this.getGraphDb());
    }

    protected Query formQuery(String key, Object value, Object matching) {
        return new TermQuery(new Term(DOC_INDEX_KEY, value.toString()));
    }

    private DocToIdIterator searchForNodes(IndexSearcherRef searcher, String key, Object value, Object matching, Sort sortingOrNull, Set<Long> deletedNodes) {
        Query query = this.formQuery(key, value, matching);
        try {
            searcher.incRef();
            Hits hits = new Hits((Searcher)searcher.getSearcher(), query, null, sortingOrNull);
            return new DocToIdIterator((Iterator<Document>)((Object)new HitsIterator(hits)), deletedNodes, searcher);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to search for " + key + "," + value, e);
        }
    }

    public Node getSingleNodeExactMatch(String key, Object value) {
        return this.getSingleNode(key, value, null);
    }

    @Override
    public Node getSingleNode(String key, Object value) {
        return this.getSingleNode(key, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node getSingleNode(String key, Object value, Object matching) {
        IndexHits<Node> hits = null;
        try {
            Node node;
            hits = this.getNodes(key, value, matching, null);
            Iterator nodes = hits.iterator();
            Node node2 = node = nodes.hasNext() ? (Node)nodes.next() : null;
            if (nodes.hasNext()) {
                throw new RuntimeException("More than one node for " + key + "=" + value);
            }
            Node node3 = node;
            return node3;
        }
        finally {
            if (hits != null) {
                hits.close();
            }
        }
    }

    @Override
    protected void removeIndexThisTx(Node node, String key, Object value) {
        this.assertArgumentNotNull(node, "node");
        this.assertArgumentNotNull(key, "key");
        this.assertArgumentNotNull(value, "value");
        for (Object arrayItem : this.asArray(value)) {
            this.getConnection().removeIndex(node, key, arrayItem);
        }
    }

    private Object[] asArray(Object propertyValue) {
        if (propertyValue.getClass().isArray()) {
            int length = Array.getLength(propertyValue);
            Object[] result = new Object[length];
            for (int i = 0; i < length; ++i) {
                result[i] = Array.get(propertyValue, i);
            }
            return result;
        }
        return new Object[]{propertyValue};
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        TxModule txModule = ((AbstractGraphDatabase)this.getGraphDb()).getConfig().getTxModule();
        if (txModule.getXaDataSourceManager().hasDataSource(this.getDirName())) {
            txModule.getXaDataSourceManager().unregisterDataSource(this.getDirName());
        }
        this.xaDs.close();
    }

    LuceneXaConnection getConnection() {
        return this.broker.acquireResourceConnection();
    }

    LuceneXaConnection getReadOnlyConnection() {
        return this.broker.acquireReadOnlyResourceConnection();
    }

    @Override
    public void removeIndex(Node node, String key) {
        this.assertArgumentNotNull(node, "node");
        this.assertArgumentNotNull(key, "key");
        this.getConnection().removeIndex(node, key, null);
    }

    private void assertArgumentNotNull(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " is null");
        }
    }

    @Override
    public void removeIndex(String key) {
        this.assertArgumentNotNull(key, "key");
        this.getConnection().removeIndex(null, key, null);
    }

    private static class ConnectionBroker {
        private final ArrayMap<Transaction, LuceneXaConnection> txConnectionMap = new ArrayMap(5, true, true);
        private final TransactionManager transactionManager;
        private final LuceneDataSource xaDs;

        ConnectionBroker(TransactionManager transactionManager, LuceneDataSource xaDs) {
            this.transactionManager = transactionManager;
            this.xaDs = xaDs;
        }

        LuceneXaConnection acquireResourceConnection() {
            LuceneXaConnection con = null;
            Transaction tx = this.getCurrentTransaction();
            if (tx == null) {
                throw new NotInTransactionException();
            }
            con = (LuceneXaConnection)((Object)this.txConnectionMap.get((Object)tx));
            if (con == null) {
                try {
                    con = (LuceneXaConnection)this.xaDs.getXaConnection();
                    if (!tx.enlistResource(con.getXaResource())) {
                        throw new RuntimeException("Unable to enlist '" + con.getXaResource() + "' in " + tx);
                    }
                    tx.registerSynchronization((Synchronization)new TxCommitHook(tx));
                    this.txConnectionMap.put((Object)tx, (Object)con);
                }
                catch (RollbackException re) {
                    String msg = "The transaction is marked for rollback only.";
                    throw new RuntimeException(msg, re);
                }
                catch (SystemException se) {
                    String msg = "TM encountered an unexpected error condition.";
                    throw new RuntimeException(msg, se);
                }
            }
            return con;
        }

        LuceneXaConnection acquireReadOnlyResourceConnection() {
            Transaction tx = this.getCurrentTransaction();
            return tx != null ? (LuceneXaConnection)((Object)this.txConnectionMap.get((Object)tx)) : null;
        }

        void releaseResourceConnectionsForTransaction(Transaction tx) throws NotInTransactionException {
            LuceneXaConnection con = (LuceneXaConnection)((Object)this.txConnectionMap.remove((Object)tx));
            if (con != null) {
                con.destroy();
            }
        }

        void delistResourcesForTransaction() throws NotInTransactionException {
            Transaction tx = this.getCurrentTransaction();
            if (tx == null) {
                throw new NotInTransactionException();
            }
            LuceneXaConnection con = (LuceneXaConnection)((Object)this.txConnectionMap.get((Object)tx));
            if (con != null) {
                try {
                    tx.delistResource(con.getXaResource(), 0x4000000);
                }
                catch (IllegalStateException e) {
                    throw new RuntimeException("Unable to delist lucene resource from tx", e);
                }
                catch (SystemException e) {
                    throw new RuntimeException("Unable to delist lucene resource from tx", e);
                }
            }
        }

        private Transaction getCurrentTransaction() throws NotInTransactionException {
            try {
                return this.transactionManager.getTransaction();
            }
            catch (SystemException se) {
                throw new NotInTransactionException("Error fetching transaction for current thread", (Throwable)se);
            }
        }

        private class TxCommitHook
        implements Synchronization {
            private final Transaction tx;

            TxCommitHook(Transaction tx) {
                this.tx = tx;
            }

            public void afterCompletion(int param) {
                ConnectionBroker.this.releaseResourceConnectionsForTransaction(this.tx);
            }

            public void beforeCompletion() {
                ConnectionBroker.this.delistResourcesForTransaction();
            }
        }
    }
}

