/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.index.lucene.Hits;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HitsIterator
extends PrefetchingIterator<Document> {
    private final Hits hits;
    private final int size;
    private int index;

    HitsIterator(Hits hits) {
        this.hits = hits;
        this.size = hits.length();
    }

    protected Document fetchNextOrNull() {
        int i = this.index++;
        try {
            return i < this.size ? this.hits.doc(i) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int size() {
        return this.size;
    }
}

