/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.index.IndexHits;
import org.neo4j.index.IndexService;
import org.neo4j.index.impl.SimpleIndexHits;
import org.neo4j.index.lucene.Hits;
import org.neo4j.index.lucene.LuceneIndexBatchInserter;
import org.neo4j.kernel.impl.batchinsert.BatchInserter;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndexBatchInserterImpl
implements LuceneIndexBatchInserter {
    private final String storeDir;
    private final BatchInserter inserter;
    private final ArrayMap<String, IndexWriterContext> indexWriters = new ArrayMap(6, false, false);
    private final ArrayMap<String, IndexSearcher> indexSearchers = new ArrayMap(6, false, false);
    private final Analyzer fieldAnalyzer = new Analyzer(){

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return new LowerCaseFilter((TokenStream)new WhitespaceTokenizer(reader));
        }
    };
    private IndexService asIndexService;

    public LuceneIndexBatchInserterImpl(BatchInserter inserter) {
        this.inserter = inserter;
        this.storeDir = this.fixPath(inserter.getStore() + "/" + this.getDirName());
        this.asIndexService = new AsIndexService();
    }

    protected String getDirName() {
        return "lucene";
    }

    private String fixPath(String dir) {
        String store = FileUtils.fixSeparatorsInPath((String)dir);
        File directories = new File(dir);
        if (!directories.exists() && !directories.mkdirs()) {
            throw new RuntimeException("Unable to create directory path[" + this.storeDir + "] for Lucene index store.");
        }
        return store;
    }

    private Directory instantiateDirectory(String key) throws IOException {
        return FSDirectory.open((File)new File(this.storeDir + "/" + key));
    }

    private IndexWriterContext getWriter(String key, boolean allowCreate) throws IOException {
        IndexWriterContext writer = (IndexWriterContext)this.indexWriters.get((Object)key);
        Directory dir = this.instantiateDirectory(key);
        if (writer == null && (allowCreate || IndexReader.indexExists((Directory)dir))) {
            try {
                IndexWriter indexWriter = new IndexWriter(dir, this.fieldAnalyzer, IndexWriter.MaxFieldLength.UNLIMITED);
                writer = new IndexWriterContext(indexWriter);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.indexWriters.put((Object)key, (Object)writer);
        }
        return writer;
    }

    private IndexSearcher getSearcher(String key) {
        try {
            IndexSearcher oldSearcher;
            IndexWriterContext writer = this.getWriter(key, false);
            if (writer == null) {
                return null;
            }
            IndexSearcher result = oldSearcher = (IndexSearcher)this.indexSearchers.get((Object)key);
            if (oldSearcher == null || writer.modifiedFlag) {
                if (oldSearcher != null) {
                    oldSearcher.getIndexReader().close();
                    oldSearcher.close();
                }
                IndexReader newReader = writer.writer.getReader();
                result = new IndexSearcher(newReader);
                this.indexSearchers.put((Object)key, (Object)result);
                writer.modifiedFlag = false;
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void index(long node, String key, Object value) {
        try {
            IndexWriterContext writer = this.getWriter(key, true);
            Document document = new Document();
            this.fillDocument(document, node, key, value);
            writer.writer.addDocument(document);
            writer.modifiedFlag = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void fillDocument(Document document, long nodeId, String key, Object value) {
        document.add((Fieldable)new Field("id", String.valueOf(nodeId), Field.Store.YES, Field.Index.NOT_ANALYZED));
        document.add((Fieldable)new Field("index", value.toString(), Field.Store.NO, this.getIndexStrategy()));
    }

    protected Field.Index getIndexStrategy() {
        return Field.Index.NOT_ANALYZED;
    }

    @Override
    public void shutdown() {
        try {
            for (IndexSearcher searcher : this.indexSearchers.values()) {
                searcher.close();
            }
            this.indexSearchers.clear();
            this.optimize();
            for (IndexWriterContext writer : this.indexWriters.values()) {
                writer.writer.close();
            }
            this.indexWriters.clear();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IndexHits<Long> getNodes(String key, Object value) {
        HashSet<Long> nodeSet = new HashSet<Long>();
        try {
            Query query = this.formQuery(key, value);
            IndexSearcher searcher = this.getSearcher(key);
            if (searcher == null) {
                return new SimpleIndexHits<Long>(Collections.emptyList(), 0);
            }
            Hits hits = new Hits((Searcher)searcher, query, null);
            for (int i = 0; i < hits.length(); ++i) {
                Document document = hits.doc(i);
                long id = Long.parseLong(document.getField("id").stringValue());
                nodeSet.add(id);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new SimpleIndexHits<Long>(nodeSet, nodeSet.size());
    }

    protected Query formQuery(String key, Object value) {
        return new TermQuery(new Term("index", value.toString()));
    }

    @Override
    public void optimize() {
        try {
            for (IndexWriterContext writer : this.indexWriters.values()) {
                writer.writer.optimize(true);
                writer.modifiedFlag = true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getSingleNode(String key, Object value) {
        long node;
        Iterator nodes = this.getNodes(key, value).iterator();
        long l = node = nodes.hasNext() ? (Long)nodes.next() : -1L;
        if (nodes.hasNext()) {
            throw new RuntimeException("More than one node for " + key + "=" + value);
        }
        return node;
    }

    @Override
    public IndexService getIndexService() {
        return this.asIndexService;
    }

    @Override
    public BatchInserter getBatchInserter() {
        return this.inserter;
    }

    private static class IndexWriterContext {
        private final IndexWriter writer;
        private boolean modifiedFlag;

        IndexWriterContext(IndexWriter writer) {
            this.writer = writer;
            this.modifiedFlag = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsIndexService
    implements IndexService {
        private AsIndexService() {
        }

        @Override
        public IndexHits<Node> getNodes(String key, Object value) {
            IndexHits<Long> ids = LuceneIndexBatchInserterImpl.this.getNodes(key, value);
            IterableWrapper<Node, Long> nodes = new IterableWrapper<Node, Long>(ids){

                protected Node underlyingObjectToObject(Long id) {
                    return LuceneIndexBatchInserterImpl.this.inserter.getGraphDbService().getNodeById(id.longValue());
                }
            };
            return new SimpleIndexHits<Node>((Iterable<Node>)nodes, ids.size());
        }

        @Override
        public Node getSingleNode(String key, Object value) {
            long id = LuceneIndexBatchInserterImpl.this.getSingleNode(key, value);
            return id == -1L ? null : LuceneIndexBatchInserterImpl.this.inserter.getGraphDbService().getNodeById(id);
        }

        @Override
        public void index(Node node, String key, Object value) {
            LuceneIndexBatchInserterImpl.this.index(node.getId(), key, value);
        }

        @Override
        public void removeIndex(Node node, String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeIndex(Node node, String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeIndex(String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void shutdown() {
            LuceneIndexBatchInserterImpl.this.shutdown();
        }
    }
}

