/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.neo4j.index.lucene.LuceneIndexBatchInserterImpl;
import org.neo4j.kernel.impl.batchinsert.BatchInserter;

public class LuceneFulltextIndexBatchInserter
extends LuceneIndexBatchInserterImpl {
    public LuceneFulltextIndexBatchInserter(BatchInserter inserter) {
        super(inserter);
    }

    protected void fillDocument(Document document, long nodeId, String key, Object value) {
        super.fillDocument(document, nodeId, key, value);
        document.add((Fieldable)new Field("index_source", value.toString(), Field.Store.NO, Field.Index.NOT_ANALYZED));
    }

    protected Field.Index getIndexStrategy() {
        return Field.Index.ANALYZED;
    }

    protected String getDirName() {
        return super.getDirName() + "-fulltext";
    }

    protected Query formQuery(String key, Object value) {
        return new TermQuery(new Term("index", value.toString().toLowerCase()));
    }
}

