/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.sortedtree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.index.impl.sortedtree.NodeEntry;
import org.neo4j.index.impl.sortedtree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedTree {
    private final GraphDatabaseService graphDb;
    private final Comparator<Node> nodeComparator;
    private TreeNode treeRoot;

    public SortedTree(GraphDatabaseService graphDb, Node rootNode, Comparator<Node> nodeComparator) {
        this.graphDb = graphDb;
        this.nodeComparator = nodeComparator;
        this.treeRoot = new TreeNode(this, rootNode);
    }

    void makeRoot(TreeNode newRoot) {
        Relationship rel = this.treeRoot.getUnderlyingNode().getSingleRelationship((RelationshipType)RelTypes.TREE_ROOT, Direction.INCOMING);
        Node startNode = rel.getStartNode();
        rel.delete();
        startNode.createRelationshipTo(newRoot.getUnderlyingNode(), (RelationshipType)RelTypes.TREE_ROOT);
        this.treeRoot = newRoot;
    }

    public void delete() {
        Relationship rel = this.treeRoot.getUnderlyingNode().getSingleRelationship((RelationshipType)RelTypes.TREE_ROOT, Direction.INCOMING);
        this.treeRoot.delete();
        rel.delete();
    }

    public void delete(int commitInterval) {
        Relationship rel = this.treeRoot.getUnderlyingNode().getSingleRelationship((RelationshipType)RelTypes.TREE_ROOT, Direction.INCOMING);
        this.treeRoot.delete(commitInterval, 0);
        rel.delete();
    }

    public boolean addNode(Node node) {
        return this.treeRoot.addEntry(node, true);
    }

    public boolean containsNode(Node node) {
        return this.treeRoot.containsEntry(node);
    }

    public boolean removeNode(Node node) {
        return this.treeRoot.removeEntry(node);
    }

    int getOrder() {
        return 9;
    }

    GraphDatabaseService getGraphDb() {
        return this.graphDb;
    }

    public Comparator<Node> getComparator() {
        return this.nodeComparator;
    }

    public Iterable<Node> getSortedNodes() {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        this.traverseTreeNode(this.treeRoot, nodeList);
        return nodeList;
    }

    private void traverseTreeNode(TreeNode currentNode, List<Node> nodeList) {
        NodeEntry entry = currentNode.getFirstEntry();
        while (entry != null) {
            TreeNode afterTree;
            TreeNode beforeTree = entry.getBeforeSubTree();
            if (beforeTree != null) {
                this.traverseTreeNode(beforeTree, nodeList);
            }
            nodeList.add(entry.getTheNode());
            NodeEntry nextEntry = entry.getNextKey();
            if (nextEntry == null && (afterTree = entry.getAfterSubTree()) != null) {
                this.traverseTreeNode(afterTree, nodeList);
            }
            entry = nextEntry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RelTypes implements RelationshipType
    {
        TREE_ROOT,
        SUB_TREE,
        KEY_ENTRY;

    }
}

