/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.shell.kernel.apps.GraphDatabaseApp;

public class IndexServiceShellApp
extends GraphDatabaseApp {
    public static final String KEY_INDEX_CLASS_NAME = "INDEX_CLASS_NAME";
    private Map<String, Object> indexServices = new HashMap<String, Object>();
    private boolean firstRun = true;

    public IndexServiceShellApp() {
        this.addOptionDefinition("g", new OptionDefinition(OptionValueType.NONE, "Get nodes for the given key and value"));
        this.addOptionDefinition("i", new OptionDefinition(OptionValueType.NONE, "Index the current node with a key and (optionally) value. If no value is given the property value for the key is used"));
        this.addOptionDefinition("r", new OptionDefinition(OptionValueType.NONE, "Removes a key-value pair for the current node from the index. If no value is given the property value for the key is used"));
        this.addOptionDefinition("c", OPTION_DEF_FOR_C);
        this.addOptionDefinition("cd", new OptionDefinition(OptionValueType.NONE, "Does a 'cd' command to the returned node. Could also be done using the -c option. (Implies -g)"));
        this.addOptionDefinition("ls", new OptionDefinition(OptionValueType.NONE, "Does a 'ls' command on the returned nodes. Could also be done using the -c option. (Implies -g)"));
    }

    public String getName() {
        return "index";
    }

    public String getDescription() {
        return "Access the IndexService capabilities for your Neo4j graph database. Use -g for getting nodes, -i and -r to manipulate. Examples:\nindex -i name  (will index property 'name' with its value for current node)\nindex -g name \"Thomas A. Anderson\"  (will get nodes matching that name)\nindex --cd name \"Agent Smith\"  (will 'cd' to the 'Agent Smith' node).";
    }

    public void shutdown() {
        for (Object indexService : this.indexServices.values()) {
            try {
                indexService.getClass().getMethod("shutdown", new Class[0]).invoke(indexService, new Object[0]);
            }
            catch (Exception e) {
                System.out.println("Couldn't shut down index service " + indexService + ", " + indexService.getClass());
            }
        }
        this.indexServices.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String exec(AppCommandParser parser, Session session, Output out) throws Exception {
        if (this.firstRun && IndexServiceShellApp.safeGet((Session)session, (String)KEY_INDEX_CLASS_NAME) == null) {
            IndexServiceShellApp.safeSet((Session)session, (String)KEY_INDEX_CLASS_NAME, (Serializable)((Object)"org.neo4j.index.lucene.LuceneIndexService"));
        }
        try {
            boolean remove;
            boolean index;
            Object indexService = this.instantiateOrGetIndexServiceObject(session, out);
            if (indexService == null) {
                throw new ShellException("No IndexService given, use the INDEX_CLASS_NAME environment variable");
            }
            boolean get = parser.options().containsKey("g") || parser.options().containsKey("cd") || parser.options().containsKey("ls");
            int count = this.boolCount(get, index = parser.options().containsKey("i"), remove = parser.options().containsKey("r"));
            if (count != 1) {
                throw new ShellException("Supply one of: -g, -i, -r");
            }
            if (get) {
                this.get(indexService, parser, session, out);
            } else if (index) {
                this.index(indexService, parser, session, out);
            } else if (remove) {
                this.remove(indexService, parser, session, out);
            }
            String string = null;
            return string;
        }
        finally {
            this.firstRun = false;
        }
    }

    private void get(Object indexService, AppCommandParser parser, Session session, Output out) throws Exception {
        String key = (String)parser.arguments().get(0);
        String value = (String)parser.arguments().get(1);
        Iterable result = (Iterable)indexService.getClass().getMethod("getNodes", String.class, Object.class).invoke(indexService, key, value);
        boolean doCd = parser.options().containsKey("cd");
        boolean doLs = parser.options().containsKey("ls");
        String commandToRun = (String)parser.options().get("c");
        ArrayList<String> commandsToRun = new ArrayList<String>();
        boolean specialCommand = false;
        if (doCd || doLs) {
            specialCommand = true;
            if (doCd) {
                commandsToRun.add("cd -a $n");
            } else if (doLs) {
                commandsToRun.add("ls $n");
            }
        } else if (commandToRun != null) {
            commandsToRun.addAll(Arrays.asList(commandToRun.split(Pattern.quote("&&"))));
        }
        for (Node node : result) {
            IndexServiceShellApp.printAndInterpretTemplateLines(commandsToRun, (boolean)false, (!specialCommand ? 1 : 0) != 0, (Node)node, (GraphDatabaseShellServer)this.getServer(), (Session)session, (Output)out);
        }
    }

    private void index(Object indexService, AppCommandParser parser, Session session, Output out) throws Exception {
        Object value;
        Node node = this.getCurrent(session).asNode();
        String key = (String)parser.arguments().get(0);
        Object object = value = parser.arguments().size() > 1 ? parser.arguments().get(1) : node.getProperty(key, null);
        if (value == null) {
            throw new ShellException("No value to index");
        }
        indexService.getClass().getMethod("index", Node.class, String.class, Object.class).invoke(indexService, node, key, value);
    }

    private void remove(Object indexService, AppCommandParser parser, Session session, Output out) throws Exception {
        Object value;
        Node node = this.getCurrent(session).asNode();
        String key = (String)parser.arguments().get(0);
        Object object = value = parser.arguments().size() > 1 ? parser.arguments().get(1) : node.getProperty(key, null);
        if (value == null) {
            throw new ShellException("No value to remove");
        }
        indexService.getClass().getMethod("removeIndex", Node.class, String.class, Object.class).invoke(indexService, node, key, value);
    }

    private int boolCount(boolean ... bools) {
        int count = 0;
        for (boolean bool : bools) {
            if (!bool) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instantiateOrGetIndexServiceObject(Session session, Output out) throws Exception {
        try {
            Class.forName("org.neo4j.index.IndexService");
        }
        catch (Exception e) {
            throw new ShellException("No indexing capabilities on the classpath");
        }
        String className = (String)((Object)IndexServiceShellApp.safeGet((Session)session, (String)KEY_INDEX_CLASS_NAME));
        if (className == null) {
            return null;
        }
        Object indexService = null;
        Map<String, Object> map = this.indexServices;
        synchronized (map) {
            indexService = this.indexServices.get(className);
            if (indexService == null) {
                indexService = Class.forName(className).getConstructor(GraphDatabaseService.class).newInstance(this.getServer().getDb());
                this.indexServices.put(className, indexService);
            }
        }
        return indexService;
    }
}

