/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.index.IndexHits;
import org.neo4j.index.lucene.LuceneDataSource;
import org.neo4j.index.lucene.LuceneFulltextDataSource;
import org.neo4j.index.lucene.LuceneIndexService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneFulltextIndexService
extends LuceneIndexService {
    protected static final String DOC_INDEX_SOURCE_KEY = "index_source";
    protected static final String FULLTEXT_DIR_NAME_POSTFIX = "-fulltext";

    public LuceneFulltextIndexService(GraphDatabaseService graphDb) {
        super(graphDb);
    }

    @Override
    protected Class<? extends LuceneDataSource> getDataSourceClass() {
        return LuceneFulltextDataSource.class;
    }

    @Override
    protected String getDirName() {
        return super.getDirName() + FULLTEXT_DIR_NAME_POSTFIX;
    }

    @Override
    protected byte[] getXaResourceId() {
        return "262374".getBytes();
    }

    @Override
    public IndexHits<Node> getNodes(String key, Object value) {
        return super.getNodes(key, value);
    }

    @Override
    public IndexHits<Node> getNodesExactMatch(String key, Object value) {
        return this.getNodes(key, value, (Object)MatchingType.EXACT, null);
    }

    @Override
    public Node getSingleNodeExactMatch(String key, Object value) {
        return this.getSingleNode(key, value, (Object)MatchingType.EXACT);
    }

    @Override
    protected Query formQuery(String key, Object value, Object matching) {
        if (matching == MatchingType.EXACT) {
            return new TermQuery(new Term(DOC_INDEX_SOURCE_KEY, value.toString()));
        }
        TokenStream stream = LuceneFulltextDataSource.LOWER_CASE_WHITESPACE_ANALYZER.tokenStream("index", (Reader)new StringReader(value.toString().toLowerCase()));
        BooleanQuery booleanQuery = new BooleanQuery();
        try {
            while (stream.incrementToken()) {
                String term = ((TermAttribute)stream.getAttribute(TermAttribute.class)).term();
                booleanQuery.add((Query)new TermQuery(new Term("index", term)), BooleanClause.Occur.MUST);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return booleanQuery;
    }

    @Override
    public void enableCache(String key, int maxNumberOfCachedEntries) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MatchingType {
        DEFAULT,
        EXACT;

    }
}

