/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.index.IndexService;

public abstract class GenericIndexService
implements IndexService {
    private final GraphDatabaseService graphDb;

    protected abstract void removeIndexThisTx(Node var1, String var2, Object var3);

    protected abstract void indexThisTx(Node var1, String var2, Object var3);

    public GenericIndexService(GraphDatabaseService graphDb) {
        if (graphDb == null) {
            throw new IllegalArgumentException("Null graph database service");
        }
        this.graphDb = graphDb;
    }

    public void index(Node node, String key, Object value) {
        this.indexThisTx(node, key, value);
    }

    public void removeIndex(Node node, String key, Object value) {
        this.removeIndexThisTx(node, key, value);
    }

    protected GraphDatabaseService getGraphDb() {
        return this.graphDb;
    }

    protected Transaction beginTx() {
        return this.graphDb.beginTx();
    }

    public void shutdown() {
    }
}

