/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.IOException;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.InputEntityVisitor;
import org.neo4j.csv.reader.Chunker;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Source;
import org.neo4j.internal.batchimport.input.csv.CsvInputChunk;
import org.neo4j.internal.batchimport.input.csv.CsvInputIterator;
import org.neo4j.internal.batchimport.input.csv.CsvInputParser;
import org.neo4j.internal.batchimport.input.csv.Decorator;
import org.neo4j.internal.batchimport.input.csv.Header;

public class LazyCsvInputChunk
implements CsvInputChunk {
    private final IdType idType;
    private final int delimiter;
    private final Collector badCollector;
    private final Source.Chunk processingChunk;
    private final Configuration config;
    private final Decorator decorator;
    private final Header header;
    private final Extractors extractors;
    private CsvInputParser parser;
    private InputEntityVisitor previousVisitor;
    private InputEntityVisitor visitor;

    public LazyCsvInputChunk(IdType idType, int delimiter, Collector badCollector, Extractors extractors, Source.Chunk processingChunk, Configuration config, Decorator decorator, Header header) {
        this.idType = idType;
        this.badCollector = badCollector;
        this.extractors = extractors;
        this.delimiter = delimiter;
        this.processingChunk = processingChunk;
        this.config = config;
        this.decorator = decorator;
        this.header = header;
    }

    @Override
    public boolean fillFrom(Chunker chunker) throws IOException {
        if (chunker.nextChunk(this.processingChunk)) {
            this.closeCurrentParser();
            this.visitor = null;
            this.parser = new CsvInputParser(CsvInputIterator.seeker(this.processingChunk, this.config), this.delimiter, this.idType, this.header, this.badCollector, this.extractors);
            return this.header.entries().length != 0;
        }
        return false;
    }

    private void closeCurrentParser() throws IOException {
        if (this.parser != null) {
            this.parser.close();
        }
    }

    public boolean next(InputEntityVisitor nakedVisitor) throws IOException {
        if (this.visitor == null || nakedVisitor != this.previousVisitor) {
            this.decorateVisitor(nakedVisitor);
        }
        return this.parser.next(this.visitor);
    }

    private void decorateVisitor(InputEntityVisitor nakedVisitor) {
        this.visitor = (InputEntityVisitor)this.decorator.apply(nakedVisitor);
        this.previousVisitor = nakedVisitor;
    }

    public void close() throws IOException {
        this.closeCurrentParser();
    }
}

