/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.parquet;

import blue.strategic.parquet.Hydrator;
import blue.strategic.parquet.ParquetReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.parquet.io.InputFile;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.InputException;
import org.neo4j.internal.batchimport.input.parquet.ParquetColumn;
import org.neo4j.internal.batchimport.input.parquet.ParquetColumnType;
import org.neo4j.internal.batchimport.input.parquet.ParquetData;
import org.neo4j.internal.batchimport.input.parquet.ParquetLogicalColumnType;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;

class ParquetDataReader {
    private final Iterator<List<Object>> data;
    private final ParquetData parquetDataFile;
    private final Groups groups;
    private final IdType idType;
    private final Supplier<ZoneId> defaultTimezoneSupplier;
    private final String arrayDelimiter;
    private final String groupName;
    private final String relationshipStartIdGroupName;
    private final String relationshipEndIdGroupName;
    private final List<ParquetColumn> columns;

    ParquetDataReader(ParquetData parquetDataFile, Groups groups, IdType idType, Map<Path, List<ParquetColumn>> columnInfo, Supplier<ZoneId> defaultTimezoneSupplier, String arrayDelimiter) {
        this.parquetDataFile = parquetDataFile;
        this.groups = groups;
        this.idType = idType;
        this.defaultTimezoneSupplier = defaultTimezoneSupplier;
        this.arrayDelimiter = arrayDelimiter;
        Path path = parquetDataFile.file();
        this.columns = columnInfo.get(path);
        try {
            this.groupName = this.columns.stream().filter(ParquetColumn::isIdColumn).findFirst().map(ParquetColumn::groupName).orElse(null);
            this.relationshipStartIdGroupName = this.columns.stream().filter(ParquetColumn::isStartId).findFirst().map(ParquetColumn::groupName).orElse(null);
            this.relationshipEndIdGroupName = this.columns.stream().filter(ParquetColumn::isEndId).findFirst().map(ParquetColumn::groupName).orElse(null);
            this.data = ParquetReader.stream((ParquetReader)ParquetReader.spliterator((InputFile)ParquetReader.makeInputFile((File)path.toFile()), columns -> new Hydrator<List<Object>, List<Object>>(){

                public List<Object> start() {
                    return new ArrayList<Object>();
                }

                public List<Object> add(List<Object> target, String heading, Object value) {
                    target.add(value);
                    return target;
                }

                public List<Object> finish(List<Object> target) {
                    return target;
                }
            })).iterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasNext() {
        return this.data.hasNext();
    }

    public synchronized boolean next(InputEntityVisitor entityToHydrate) throws IOException {
        if (!this.data.hasNext()) {
            return false;
        }
        List<Object> readData = this.data.next();
        ArrayList<String> labels = new ArrayList<String>(this.filterEmptyLabelsAndTrim(this.parquetDataFile.labelsOrType()));
        StringBuilder idValue = new StringBuilder();
        Collection<String> typeCandidates = this.filterEmptyLabelsAndTrim(this.parquetDataFile.labelsOrType());
        String type = typeCandidates.isEmpty() ? "" : typeCandidates.iterator().next();
        for (int i = 0; i < readData.size(); ++i) {
            String typeColumnData;
            ParquetColumn parquetColumn = this.columns.get(i);
            Object readDatum = readData.get(i);
            if (readDatum == null || this.isEmptyString(readDatum) || parquetColumn.isIgnoredColumn()) continue;
            if (parquetColumn.isIdColumn()) {
                boolean isActualIdColumn;
                if (this.idType == IdType.STRING && (parquetColumn.columnIdType() == IdType.STRING || parquetColumn.columnIdType() == null)) {
                    idValue.append(this.resolveIdByType(readDatum, null));
                } else if (this.idType == IdType.INTEGER || parquetColumn.columnIdType() == IdType.INTEGER) {
                    entityToHydrate.id(this.resolveIdByType(readDatum, parquetColumn.columnIdType()), this.groups.get(this.groupName));
                } else {
                    entityToHydrate.id(((Long)this.resolveIdByType(readDatum, parquetColumn.columnIdType())).longValue());
                }
                boolean bl = isActualIdColumn = this.idType == IdType.ACTUAL && parquetColumn.isIdColumn();
                if (!isActualIdColumn && parquetColumn.hasPropertyName()) {
                    entityToHydrate.property(parquetColumn.propertyName(), this.convertType(readDatum, parquetColumn));
                }
            }
            if (parquetColumn.isLabelColumn()) {
                labels.addAll(this.readLabelFromEntry(readDatum));
            }
            if (parquetColumn.hasPropertyName() && parquetColumn.logicalColumnType() == ParquetLogicalColumnType.PROPERTY) {
                entityToHydrate.property(parquetColumn.propertyName(), this.convertType(readDatum, parquetColumn));
            }
            if (parquetColumn.isStartId()) {
                entityToHydrate.startId(this.resolveIdByType(readDatum, null), this.groups.get(this.relationshipStartIdGroupName));
            }
            if (parquetColumn.isEndId()) {
                entityToHydrate.endId(this.resolveIdByType(readDatum, null), this.groups.get(this.relationshipEndIdGroupName));
            }
            if (!parquetColumn.isType() || !(readDatum instanceof String) || (typeColumnData = (String)readDatum).isBlank()) continue;
            type = typeColumnData;
        }
        if (!labels.isEmpty()) {
            entityToHydrate.labels(labels.toArray(new String[0]));
        }
        if (type != null && !type.isBlank()) {
            entityToHydrate.type(type);
        }
        if (this.idType == IdType.STRING && !idValue.isEmpty()) {
            entityToHydrate.id((Object)idValue.toString(), this.groups.get(this.groupName));
        }
        entityToHydrate.endOfEntity();
        return true;
    }

    private Object convertType(Object object, ParquetColumn parquetColumn) {
        try {
            if (parquetColumn.isRaw()) {
                return object;
            }
            if (parquetColumn.isArray()) {
                String[] parts = object.toString().split(this.arrayDelimiter);
                Object[] values = new Object[parts.length];
                ParquetColumn nonArrayType = parquetColumn.withoutArray();
                for (int i = 0; i < parts.length; ++i) {
                    values[i] = this.convertType(parts[i], nonArrayType);
                }
                return values;
            }
            return switch (parquetColumn.columnType()) {
                case ParquetColumnType.POINT -> {
                    if (parquetColumn.hasConfiguration()) {
                        yield PointValue.parse((CharSequence)object.toString(), (CSVHeaderInformation)PointValue.parseHeaderInformation((CharSequence)parquetColumn.rawConfiguration()));
                    }
                    yield PointValue.parse((CharSequence)object.toString());
                }
                case ParquetColumnType.DATE -> DateValue.parse((CharSequence)object.toString());
                case ParquetColumnType.TIME -> TimeValue.parse((CharSequence)object.toString(), parquetColumn.getTimezone(this.defaultTimezoneSupplier), null);
                case ParquetColumnType.DATE_TIME -> DateTimeValue.parse((CharSequence)object.toString(), parquetColumn.getTimezone(this.defaultTimezoneSupplier), null);
                case ParquetColumnType.LOCAL_TIME -> LocalTimeValue.parse((CharSequence)object.toString());
                case ParquetColumnType.LOCAL_DATE_TIME -> LocalDateTimeValue.parse((CharSequence)object.toString());
                case ParquetColumnType.DURATION -> DurationValue.parse((CharSequence)object.toString());
                case ParquetColumnType.INT -> Integer.valueOf(object.toString());
                case ParquetColumnType.SHORT -> Short.valueOf(object.toString());
                case ParquetColumnType.STRING -> object.toString();
                case ParquetColumnType.LONG -> Long.valueOf(object.toString());
                case ParquetColumnType.BYTE -> Byte.parseByte(object.toString());
                case ParquetColumnType.DOUBLE -> Double.parseDouble(object.toString());
                case ParquetColumnType.FLOAT -> Float.valueOf(Float.parseFloat(object.toString()));
                default -> object;
            };
        }
        catch (RuntimeException e) {
            throw new InputException("could not convert %s to %s".formatted(new Object[]{object.toString(), parquetColumn.columnType()}), e);
        }
    }

    private boolean isEmptyString(Object object) {
        String stringValue;
        return object instanceof String && (stringValue = (String)object).isEmpty();
    }

    private Object resolveIdByType(Object id, IdType columnIdType) {
        if (id instanceof String) {
            String stringId = (String)id;
            return stringId;
        }
        if (id instanceof Long) {
            Long longId = (Long)id;
            return longId;
        }
        if (id instanceof Integer) {
            Integer intId = (Integer)id;
            if (columnIdType == IdType.INTEGER) {
                return intId;
            }
            return intId.longValue();
        }
        throw new IllegalArgumentException("Cannot convert id of type " + id.getClass());
    }

    private Collection<String> filterEmptyLabelsAndTrim(Collection<String> labels) {
        return labels.stream().filter(s -> !s.isEmpty()).map(String::trim).collect(Collectors.toSet());
    }

    private Collection<String> readLabelFromEntry(Object readDatum) {
        return this.filterEmptyLabelsAndTrim(Arrays.asList(readDatum.toString().split(this.arrayDelimiter)));
    }
}

