/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.parquet;

import java.nio.file.Path;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.internal.batchimport.input.parquet.ParquetData;

public final class ParquetDataFactory {
    private static final Supplier<ZoneId> defaultTimezoneSupplier = () -> ZoneOffset.UTC;
    private final Iterator<Map.Entry<Set<String>, List<Path>>> labelsOrTypeAndFilesIterator;
    private Iterator<Path> currentFileIterator;
    private Map.Entry<Set<String>, List<Path>> currentLabelsOrTypeAndFiles;

    public ParquetDataFactory(Map<Set<String>, List<Path>> labelsOrTypeAndFiles) {
        this.labelsOrTypeAndFilesIterator = labelsOrTypeAndFiles.entrySet().iterator();
    }

    ParquetData getNextFile() {
        if (this.currentFileIterator == null || !this.currentFileIterator.hasNext()) {
            this.currentLabelsOrTypeAndFiles = this.labelsOrTypeAndFilesIterator.next();
            this.currentFileIterator = this.currentLabelsOrTypeAndFiles.getValue().iterator();
        }
        return new ParquetData(this.currentLabelsOrTypeAndFiles.getKey(), this.currentFileIterator.next(), defaultTimezoneSupplier);
    }

    public boolean hasNextFile() {
        if (this.currentFileIterator == null && this.currentLabelsOrTypeAndFiles == null && !this.labelsOrTypeAndFilesIterator.hasNext()) {
            return false;
        }
        if (this.currentLabelsOrTypeAndFiles == null && this.labelsOrTypeAndFilesIterator.hasNext()) {
            this.currentLabelsOrTypeAndFiles = this.labelsOrTypeAndFilesIterator.next();
        }
        if (this.currentFileIterator == null) {
            this.currentFileIterator = this.currentLabelsOrTypeAndFiles.getValue().iterator();
        }
        if (!this.currentFileIterator.hasNext()) {
            return this.labelsOrTypeAndFilesIterator.hasNext();
        }
        return true;
    }
}

