/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Supplier;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.impl.factory.Lists;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.csv.reader.BufferedCharSeeker;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharReadableChunker;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Chunker;
import org.neo4j.csv.reader.ClosestNewLineChunker;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.HeaderSkipper;
import org.neo4j.csv.reader.Readables;
import org.neo4j.csv.reader.Source;
import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.csv.CsvInputChunk;
import org.neo4j.internal.batchimport.input.csv.CsvInputChunkProxy;
import org.neo4j.internal.batchimport.input.csv.DataFactories;
import org.neo4j.internal.batchimport.input.csv.Decorator;
import org.neo4j.internal.batchimport.input.csv.EagerCsvInputChunk;
import org.neo4j.internal.batchimport.input.csv.EagerParserChunker;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.batchimport.input.csv.LazyCsvInputChunk;
import org.neo4j.internal.batchimport.input.csv.Type;

class CsvInputIterator
implements SourceTraceability,
Closeable {
    private static final ImmutableMap<String, Type> TYPES = Lists.immutable.of((Object[])Type.values()).toMap(Enum::name, (Function & Serializable)t -> t).toImmutable();
    private final CharReadable stream;
    private final Chunker chunker;
    private final int groupId;
    private final Decorator decorator;
    private final Supplier<CsvInputChunk> realInputChunkSupplier;

    CsvInputIterator(CharReadable stream, Decorator decorator, Header header, Configuration config, IdType idType, Collector badCollector, Extractors extractors, int groupId, boolean autoSkipHeaders) {
        this.stream = stream;
        this.decorator = decorator;
        this.groupId = groupId;
        if (config.multilineFields()) {
            this.chunker = new EagerParserChunker(stream, idType, header, badCollector, extractors, 1000, config, decorator, autoSkipHeaders);
            this.realInputChunkSupplier = EagerCsvInputChunk::new;
        } else {
            this.chunker = new ClosestNewLineChunker(stream, config.bufferSize(), CsvInputIterator.headerSkip(autoSkipHeaders, config, idType));
            this.realInputChunkSupplier = () -> new LazyCsvInputChunk(idType, config.delimiter(), badCollector, extractors, this.chunker.newChunk(), config, decorator, header);
        }
    }

    CsvInputIterator(CharReadable stream, Decorator decorator, Header.Factory headerFactory, IdType idType, Configuration config, Groups groups, Collector badCollector, Extractors extractors, int groupId, boolean autoSkipHeader, Header.Monitor monitor) throws IOException {
        this(stream, decorator, CsvInputIterator.extractHeader(stream, headerFactory, idType, config, groups, monitor), config, idType, badCollector, extractors, groupId, autoSkipHeader);
    }

    static Header extractHeader(CharReadable stream, Header.Factory headerFactory, IdType idType, Configuration config, Groups groups, Header.Monitor monitor) throws IOException {
        if (!headerFactory.isDefined()) {
            CharSeeker headerSeeker = CsvInputIterator.seeker(stream.sourceDescription(), config, Readables.extractFirstLineFrom((CharReadable)stream));
            return headerFactory.create(headerSeeker, config, idType, groups, monitor);
        }
        return headerFactory.create(null, null, null, null, monitor);
    }

    private static CharSeeker seeker(String sourceDescription, Configuration config, char[] data) {
        CharReadableChunker.ChunkImpl firstChunk = new CharReadableChunker.ChunkImpl(Arrays.copyOf(data, data.length + 1));
        firstChunk.initialize(0, data.length, sourceDescription);
        return CsvInputIterator.seeker((Source.Chunk)firstChunk, config);
    }

    static HeaderSkipper headerSkip(boolean autoSkipHeaders, Configuration config, IdType idType) {
        if (!autoSkipHeaders) {
            return HeaderSkipper.NO_SKIP;
        }
        return (data, offset, length) -> {
            int initialEolSkipped = 0;
            while (BufferedCharSeeker.isEolChar((char)data[offset])) {
                ++offset;
                ++initialEolSkipped;
            }
            char[] firstLine = Readables.extractFirstLineFrom((char[])data, (int)offset, (int)length);
            if (firstLine.length > 0) {
                CharSeeker seeker = CsvInputIterator.seeker("", config, firstLine);
                try {
                    Header.Entry[] entries = DataFactories.parseHeaderEntries(seeker, config, idType, new Groups(), ZoneId::systemDefault, (sourceDescription, entryIndex, spec, extractors, idExtractor, groups, monitor) -> new Header.Entry(spec.rawEntry(), spec.name(), CsvInputIterator.typeFromSpec(spec.type()), null, extractors.string()), Header.NO_MONITOR);
                    if (Arrays.stream(entries).anyMatch(e -> e.type() != Type.PROPERTY && e.type() != Type.IGNORE)) {
                        return initialEolSkipped + firstLine.length;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 0;
        };
    }

    private static Type typeFromSpec(String specType) {
        Type type = Type.PROPERTY;
        if (specType != null) {
            type = (Type)((Object)TYPES.getIfAbsentValue((Object)specType.toUpperCase(Locale.ROOT), (Object)type));
        }
        return type;
    }

    public boolean next(CsvInputChunkProxy proxy) throws IOException {
        proxy.ensureInstantiated(this.realInputChunkSupplier, this.groupId);
        return proxy.fillFrom(this.chunker);
    }

    @Override
    public void close() throws IOException {
        this.chunker.close();
        this.decorator.close();
    }

    public String sourceDescription() {
        return this.stream.sourceDescription();
    }

    public long position() {
        return this.chunker.position();
    }

    public float compressionRatio() {
        return this.stream.compressionRatio();
    }

    static CharSeeker seeker(Source.Chunk chunk, Configuration config) {
        return new BufferedCharSeeker(Source.singleChunk((Source.Chunk)chunk), config);
    }
}

