/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.batchimport.api.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.storageengine.api.PropertyKeyValue;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class InputEntity
implements InputEntityVisitor {
    public static final Object[] NO_PROPERTIES = ArrayUtils.EMPTY_OBJECT_ARRAY;
    public static final String[] NO_LABELS = ArrayUtils.EMPTY_STRING_ARRAY;
    public static final int NULL_ID = -1;
    private final InputEntityVisitor delegate;
    public boolean hasPropertyId;
    public long propertyId;
    public boolean hasIntPropertyKeyIds;
    public final List<Object> properties = new ArrayList<Object>();
    public ByteBuffer encodedProperties;
    public boolean propertiesOffloaded;
    public boolean hasLongId;
    public long longId;
    public Object objectId;
    public Group idGroup;
    public final List<String> labels = new ArrayList<String>();
    public boolean hasLabelField;
    public long labelField;
    public boolean hasLongStartId;
    public long longStartId;
    public Object objectStartId;
    public Group startIdGroup;
    public boolean hasLongEndId;
    public long longEndId;
    public Object objectEndId;
    public Group endIdGroup;
    public boolean hasIntType;
    public int intType;
    public String stringType;
    private boolean end;

    public InputEntity(InputEntityVisitor delegate) {
        this.delegate = delegate;
        this.reset();
    }

    public InputEntity() {
        this(NULL);
    }

    public boolean propertyId(long nextProp) {
        this.checkClear();
        this.hasPropertyId = true;
        this.propertyId = nextProp;
        return this.delegate.propertyId(nextProp);
    }

    public boolean properties(ByteBuffer properties, boolean offloaded) {
        this.checkClear();
        this.encodedProperties = properties;
        this.propertiesOffloaded = offloaded;
        return this.delegate.properties(properties, offloaded);
    }

    public boolean property(String key, Object value) {
        this.checkClear();
        this.properties.add(key);
        this.properties.add(value);
        return this.delegate.property(key, value);
    }

    public boolean property(int propertyKeyId, Object value) {
        this.checkClear();
        this.hasIntPropertyKeyIds = true;
        this.properties.add(propertyKeyId);
        this.properties.add(value);
        return this.delegate.property(propertyKeyId, value);
    }

    public boolean property(String property) {
        return this.delegate.property(property);
    }

    public boolean id(long id) {
        this.checkClear();
        this.hasLongId = true;
        this.longId = id;
        return this.delegate.id(id);
    }

    public boolean id(Object id, Group group) {
        this.checkClear();
        this.objectId = id;
        this.idGroup = group;
        return this.delegate.id(id, group);
    }

    public boolean id(Object id, Group group, IdSequence idSequence) {
        this.checkClear();
        this.objectId = id;
        this.idGroup = group;
        return this.delegate.id(id, group, idSequence);
    }

    public boolean labels(String[] labels) {
        this.checkClear();
        Collections.addAll(this.labels, labels);
        return this.delegate.labels(labels);
    }

    public boolean labelField(long labelField) {
        this.checkClear();
        this.hasLabelField = true;
        this.labelField = labelField;
        return this.delegate.labelField(labelField);
    }

    public boolean startId(long id) {
        this.checkClear();
        this.hasLongStartId = true;
        this.longStartId = id;
        return this.delegate.startId(id);
    }

    public boolean startId(Object id, Group group) {
        this.checkClear();
        this.objectStartId = id;
        this.startIdGroup = group;
        return this.delegate.startId(id, group);
    }

    public boolean endId(long id) {
        this.checkClear();
        this.hasLongEndId = true;
        this.longEndId = id;
        return this.delegate.endId(id);
    }

    public boolean endId(Object id, Group group) {
        this.checkClear();
        this.objectEndId = id;
        this.endIdGroup = group;
        return this.delegate.endId(id, group);
    }

    public boolean type(int type) {
        this.checkClear();
        this.hasIntType = true;
        this.intType = type;
        return this.delegate.type(type);
    }

    public boolean type(String type) {
        this.checkClear();
        this.stringType = type;
        return this.delegate.type(type);
    }

    public void endOfEntity() throws IOException {
        this.end = true;
        this.delegate.endOfEntity();
    }

    public boolean isComplete() {
        return this.end;
    }

    public String[] labels() {
        return this.labels.toArray(new String[0]);
    }

    public Object[] properties() {
        return this.properties.toArray();
    }

    public Map<String, Object> propertiesAsMap() {
        Preconditions.checkState((!this.hasIntPropertyKeyIds ? 1 : 0) != 0, (String)"This instance doesn't have String keys");
        HashMap<String, Object> map = new HashMap<String, Object>();
        int propertyCount = this.propertyCount();
        for (int i = 0; i < propertyCount; ++i) {
            map.put((String)this.propertyKey(i), this.propertyValue(i));
        }
        return map;
    }

    public Map<String, Value> propertiesAsValueMap() {
        Preconditions.checkState((!this.hasIntPropertyKeyIds ? 1 : 0) != 0, (String)"This instance doesn't have String keys");
        HashMap<String, Value> map = new HashMap<String, Value>();
        int propertyCount = this.propertyCount();
        for (int i = 0; i < propertyCount; ++i) {
            Value v;
            Object value = this.propertyValue(i);
            map.put((String)this.propertyKey(i), value instanceof Value ? (v = (Value)value) : Values.of((Object)value));
        }
        return map;
    }

    public Iterable<StorageProperty> asStorageProperties(final ToIntFunction<String> propertyKeyIdLookup) {
        return () -> new PrefetchingIterator<StorageProperty>(){
            private final int count;
            private int cursor;
            {
                this.count = InputEntity.this.propertyCount();
            }

            protected StorageProperty fetchNextOrNull() {
                if (this.cursor < this.count) {
                    Value value;
                    int propertyKeyId = propertyKeyIdLookup.applyAsInt((String)InputEntity.this.propertyKey(this.cursor));
                    Object valueObject = InputEntity.this.propertyValue(this.cursor);
                    ++this.cursor;
                    return new PropertyKeyValue(propertyKeyId, valueObject instanceof Value ? (value = (Value)valueObject) : Values.of((Object)valueObject));
                }
                return null;
            }
        };
    }

    public Object id() {
        return this.hasLongId ? Long.valueOf(this.longId) : this.objectId;
    }

    public Object endId() {
        return this.hasLongEndId ? Long.valueOf(this.longEndId) : this.objectEndId;
    }

    public Object startId() {
        return this.hasLongStartId ? Long.valueOf(this.longStartId) : this.objectStartId;
    }

    public Object type() {
        return this.stringType != null ? this.stringType : Integer.valueOf(this.intType);
    }

    public long longStartId(IdMapper.Getter idLookup) {
        return this.extractNodeId(this.hasLongStartId, this.longStartId, this.objectStartId, this.startIdGroup, idLookup);
    }

    public long longEndId(IdMapper.Getter idLookup) {
        return this.extractNodeId(this.hasLongEndId, this.longEndId, this.objectEndId, this.endIdGroup, idLookup);
    }

    public int intType(ToIntFunction<String> idLookup) {
        if (this.hasIntType) {
            return this.intType;
        }
        if (this.stringType != null) {
            return idLookup.applyAsInt(this.stringType);
        }
        return -1;
    }

    private long extractNodeId(boolean hasLongId, long longId, Object objectId, Group idGroup, IdMapper.Getter idLookup) {
        if (hasLongId) {
            return longId;
        }
        if (objectId != null) {
            return idLookup.get(objectId, idGroup);
        }
        return -1L;
    }

    private void checkClear() {
        if (this.end) {
            this.reset();
        }
    }

    public void reset() {
        this.end = false;
        this.hasPropertyId = false;
        this.propertyId = -1L;
        this.hasIntPropertyKeyIds = false;
        this.properties.clear();
        this.encodedProperties = null;
        this.propertiesOffloaded = false;
        this.hasLongId = false;
        this.longId = -1L;
        this.objectId = null;
        this.idGroup = null;
        this.labels.clear();
        this.hasLabelField = false;
        this.labelField = -1L;
        this.hasLongStartId = false;
        this.longStartId = -1L;
        this.objectStartId = null;
        this.startIdGroup = null;
        this.hasLongEndId = false;
        this.longEndId = -1L;
        this.objectEndId = null;
        this.endIdGroup = null;
        this.hasIntType = false;
        this.intType = -1;
        this.stringType = null;
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public int propertyCount() {
        return this.properties.size() / 2;
    }

    public Object propertyKey(int i) {
        return this.properties.get(i * 2);
    }

    public Object propertyValue(int i) {
        return this.properties.get(i * 2 + 1);
    }

    public void replayOnto(InputEntityVisitor visitor) throws IOException {
        if (this.hasPropertyId) {
            visitor.propertyId(this.propertyId);
        } else if (!this.properties.isEmpty()) {
            int propertyCount = this.propertyCount();
            for (int i = 0; i < propertyCount; ++i) {
                if (this.hasIntPropertyKeyIds) {
                    visitor.property(((Integer)this.propertyKey(i)).intValue(), this.propertyValue(i));
                    continue;
                }
                visitor.property((String)this.propertyKey(i), this.propertyValue(i));
            }
        }
        if (this.hasLongId) {
            visitor.id(this.longId);
        } else if (this.objectId != null) {
            visitor.id(this.objectId, this.idGroup);
        }
        if (this.hasLabelField) {
            visitor.labelField(this.labelField);
        } else if (!this.labels.isEmpty()) {
            visitor.labels(this.labels.toArray(new String[0]));
        }
        if (this.hasLongStartId) {
            visitor.startId(this.longStartId);
        } else if (this.objectStartId != null) {
            visitor.startId(this.objectStartId, this.startIdGroup);
        }
        if (this.hasLongEndId) {
            visitor.endId(this.longEndId);
        } else if (this.objectEndId != null) {
            visitor.endId(this.objectEndId, this.endIdGroup);
        }
        if (this.hasIntType) {
            visitor.type(this.intType);
        } else if (this.stringType != null) {
            visitor.type(this.stringType);
        }
        visitor.endOfEntity();
    }
}

