/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.StageExecution;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.staging.WeightedStep;
import org.neo4j.internal.batchimport.stats.Keys;

public class DynamicProcessorAssigner
extends ExecutionMonitor.Adapter {
    private final Configuration config;
    private final Map<Step<?>, Long> lastChangedProcessors = new HashMap();
    private final int availableProcessors;

    public DynamicProcessorAssigner(Configuration config) {
        super(1L, TimeUnit.SECONDS);
        this.config = config;
        this.availableProcessors = config.maxNumberOfWorkerThreads();
    }

    @Override
    public void start(StageExecution execution) {
        this.lastChangedProcessors.clear();
    }

    @Override
    public void check(StageExecution execution) {
        if (execution.stillExecuting()) {
            int permits = this.availableProcessors - DynamicProcessorAssigner.countActiveProcessors(execution);
            if (permits > 0) {
                permits -= this.assignProcessors(execution, permits);
            }
            if (permits == 0) {
                this.moveProcessorFromOverlyAssigned(execution);
            }
        }
    }

    private int assignProcessors(StageExecution execution, int permits) {
        WeightedStep bottleNeck = execution.stepsOrderedBy(Keys.avg_processing_time, false).iterator().next();
        Step<?> bottleNeckStep = bottleNeck.step();
        long doneBatches = bottleNeckStep.longStat(Keys.done_batches);
        if (bottleNeck.weight().floatValue() > 1.0f && this.batchesPassedSinceLastChange(bottleNeckStep, doneBatches) >= (long)this.config.movingAverageSize()) {
            int optimalProcessorIncrement = Integer.min(Math.max(1, (int)bottleNeck.weight().floatValue() - 1), permits);
            int before = bottleNeckStep.processors(0);
            int after = bottleNeckStep.processors(Math.max(optimalProcessorIncrement, permits / 10));
            if (after > before) {
                this.lastChangedProcessors.put(bottleNeckStep, doneBatches);
            }
            return after - before;
        }
        return 0;
    }

    private void moveProcessorFromOverlyAssigned(StageExecution execution) {
        List<WeightedStep> steps = execution.stepsOrderedBy(Keys.avg_processing_time, true);
        for (int i = 0; i < steps.size() - 1; ++i) {
            long doneBatches;
            float factorWithDecrementedProcessorCount;
            WeightedStep faster = steps.get(i);
            Step<?> fasterStep = faster.step();
            WeightedStep slower = steps.get(i + 1);
            Step<?> slowerStep = slower.step();
            int numberOfProcessors = faster.step().processors(0);
            if (numberOfProcessors == 1 || slowerStep.processors(0) == slowerStep.maxProcessors() || !((factorWithDecrementedProcessorCount = faster.weight().floatValue() * (float)numberOfProcessors / (float)(numberOfProcessors - 1)) < 0.8f) || this.batchesPassedSinceLastChange(fasterStep, doneBatches = fasterStep.longStat(Keys.done_batches)) < (long)this.config.movingAverageSize() || fasterStep.processors(-1) >= numberOfProcessors) continue;
            this.lastChangedProcessors.put(fasterStep, doneBatches);
            slowerStep.processors(1);
            this.lastChangedProcessors.put(slowerStep, doneBatches);
            return;
        }
    }

    private static int countActiveProcessors(StageExecution execution) {
        return execution.stillExecuting() ? StreamSupport.stream(execution.steps().spliterator(), false).mapToInt(step -> step.processors(0)).sum() : 0;
    }

    private long batchesPassedSinceLastChange(Step<?> step, long doneBatches) {
        return this.lastChangedProcessors.containsKey(step) ? doneBatches - this.lastChangedProcessors.get(step) : (long)this.config.movingAverageSize();
    }
}

