/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.PopulationWorkJobScheduler;
import org.neo4j.internal.batchimport.PropertyValueLookup;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.IOUtils;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.memory.UnsafeDirectByteBufferAllocator;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryConflictHandler;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracker;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexIdMapper
implements IdMapper {
    private final Map<String, IndexAccessor> accessors;
    private final IndexProviderMap tempIndexes;
    private final TokenNameLookup tokenNameLookup;
    private final Map<String, IndexDescriptor> indexDescriptors;
    private final PopulationWorkJobScheduler workScheduler;
    private final ImmutableSet<OpenOption> openOptions;
    private final Configuration configuration;
    private final PageCacheTracer pageCacheTracer;
    private final IndexStatisticsStore indexStatisticsStore;
    private final ReadableGroups groups;
    private final ThreadLocal<Map<String, Index>> threadLocal;
    private final List<Index> indexes = new CopyOnWriteArrayList<Index>();
    private final Map<String, Populator> populators = new HashMap<String, Populator>();
    private final ByteBufferFactory bufferFactory;
    private final StorageEngineIndexingBehaviour indexingBehaviour;
    private final MutableLongSet duplicateNodeIds = LongSets.mutable.empty().asSynchronized();
    private final LongAdder numAdded = new LongAdder();

    public IndexIdMapper(Map<String, IndexAccessor> accessors, IndexProviderMap tempIndexes, TokenNameLookup tokenNameLookup, Map<String, IndexDescriptor> indexDescriptors, PopulationWorkJobScheduler workScheduler, ImmutableSet<OpenOption> openOptions, Configuration configuration, PageCacheTracer pageCacheTracer, IndexStatisticsStore indexStatisticsStore, ReadableGroups groups, StorageEngineIndexingBehaviour indexingBehaviour) throws IOException {
        this.accessors = accessors;
        this.tempIndexes = tempIndexes;
        this.tokenNameLookup = tokenNameLookup;
        this.indexDescriptors = indexDescriptors;
        this.workScheduler = workScheduler;
        this.openOptions = openOptions;
        this.configuration = configuration;
        this.pageCacheTracer = pageCacheTracer;
        this.indexStatisticsStore = indexStatisticsStore;
        this.groups = groups;
        this.threadLocal = ThreadLocal.withInitial(HashMap::new);
        this.bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, ((Long)Config.defaults().get(GraphDatabaseInternalSettings.index_populator_block_size)).intValue());
        this.indexingBehaviour = indexingBehaviour;
        for (Map.Entry<String, IndexAccessor> entry : accessors.entrySet()) {
            IndexDescriptor descriptor = indexDescriptors.get(entry.getKey());
            IndexProvider indexProvider = tempIndexes.lookup(descriptor.getIndexProvider());
            IndexPopulator populator = indexProvider.getPopulator(descriptor, new IndexSamplingConfig(Config.defaults()), this.bufferFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE, tokenNameLookup, openOptions, indexingBehaviour);
            populator.create();
            this.populators.put(entry.getKey(), new Populator(populator, descriptor));
        }
    }

    @Override
    public void put(Object inputId, long actualId, Group group) {
        Populator populator = this.populators.get(group.name());
        ValueIndexEntryUpdate update = IndexEntryUpdate.add((long)actualId, (SchemaDescriptorSupplier)populator.descriptor, (Value[])new Value[]{Values.of((Object)inputId)});
        try {
            populator.populator.add(Collections.singleton(update), CursorContext.NULL_CONTEXT);
            populator.populator.includeSample((IndexEntryUpdate)update);
            this.numAdded.increment();
        }
        catch (IndexEntryConflictException e) {
            throw new RuntimeException(e);
        }
    }

    private Index index(Group group) {
        return this.threadLocal.get().computeIfAbsent(group.name(), groupName -> {
            IndexAccessor accessor = this.accessors.get(groupName);
            ValueIndexReader reader = accessor.newValueReader(IndexUsageTracker.NO_USAGE_TRACKER);
            IndexDescriptor schemaDescriptor = this.indexDescriptors.get(groupName);
            Index index = new Index(reader, schemaDescriptor.schema());
            this.indexes.add(index);
            return index;
        });
    }

    @Override
    public boolean needsPreparation() {
        return true;
    }

    public void completeBuild(Collector collector, Consumer<Runnable> scheduler) {
        for (Map.Entry<String, Populator> entry : this.populators.entrySet()) {
            scheduler.accept(() -> {
                IndexEntryConflictHandler conflictHandler = this.conflictHandler(collector, entry);
                try {
                    Populator populator = (Populator)entry.getValue();
                    populator.populator.scanCompleted(PhaseTracker.nullInstance, (IndexPopulator.PopulationWorkScheduler)this.workScheduler, conflictHandler, CursorContext.NULL_CONTEXT);
                    this.indexStatisticsStore.setSampleStats(populator.descriptor.getId(), populator.populator.sample(CursorContext.NULL_CONTEXT));
                    populator.populator.close(true, CursorContext.NULL_CONTEXT);
                }
                catch (IndexEntryConflictException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private IndexEntryConflictHandler conflictHandler(Collector collector, Map.Entry<String, Populator> entry) {
        return (firstEntityId, otherEntityId, values) -> {
            this.duplicateNodeIds.add(otherEntityId);
            collector.collectDuplicateNode(values[0].asObjectCopy(), otherEntityId, this.groups.get((String)entry.getKey()));
            return IndexEntryConflictHandler.IndexEntryConflictAction.DELETE;
        };
    }

    public LongSet validate(Collector collector) {
        for (Map.Entry<String, Populator> entry : this.populators.entrySet()) {
            IndexEntryConflictHandler conflictHandler = this.conflictHandler(collector, entry);
            try {
                Populator populator = entry.getValue();
                IndexProvider indexProvider = this.tempIndexes.lookup(populator.descriptor.getIndexProvider());
                IndexAccessor newNodesIndex = indexProvider.getOnlineAccessor(populator.descriptor, new IndexSamplingConfig(Config.defaults()), this.tokenNameLookup, this.openOptions, this.indexingBehaviour);
                try {
                    IndexAccessor accessor = this.accessors.get(entry.getKey());
                    accessor.validate(newNodesIndex, true, conflictHandler, null, this.configuration.maxNumberOfWorkerThreads(), this.workScheduler.jobScheduler());
                }
                finally {
                    if (newNodesIndex == null) continue;
                    newNodesIndex.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.duplicateNodeIds;
    }

    @Override
    public void prepare(PropertyValueLookup inputIdLookup, Collector collector, ProgressMonitorFactory progressMonitorFactory) {
        for (Map.Entry<String, Populator> entry : this.populators.entrySet()) {
            try {
                IndexDescriptor descriptor = entry.getValue().descriptor;
                IndexProvider indexProvider = this.tempIndexes.lookup(descriptor.getIndexProvider());
                IndexAccessor newNodesIndex = indexProvider.getOnlineAccessor(descriptor, new IndexSamplingConfig(Config.defaults()), this.tokenNameLookup, this.openOptions, this.indexingBehaviour);
                try {
                    ProgressListener progress = progressMonitorFactory.singlePart("Prepare ID mapper", this.numAdded.sum());
                    try {
                        IndexAccessor accessor = this.accessors.get(entry.getKey());
                        accessor.insertFrom(newNodesIndex, null, true, IndexEntryConflictHandler.THROW, id -> !this.duplicateNodeIds.contains(id), this.configuration.maxNumberOfWorkerThreads(), this.workScheduler.jobScheduler(), progress);
                    }
                    finally {
                        if (progress == null) continue;
                        progress.close();
                    }
                }
                finally {
                    if (newNodesIndex == null) continue;
                    newNodesIndex.close();
                }
            }
            catch (IndexEntryConflictException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Override
    public IdMapper.Getter newGetter() {
        return new IdMapper.Getter(){

            @Override
            public long get(Object inputId, Group group) {
                long l;
                NodeValueIterator client = new NodeValueIterator();
                try {
                    Index index = IndexIdMapper.this.index(group);
                    index.reader.query((IndexProgressor.EntityValueClient)client, QueryContext.NULL_CONTEXT, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)index.schemaDescriptor.getPropertyId(), (Object)inputId)});
                    l = client.hasNext() ? client.next() : -1L;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IndexNotApplicableKernelException e) {
                        throw new RuntimeException(e);
                    }
                }
                client.close();
                return l;
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{() -> IOUtils.closeAllUnchecked(this.indexes), () -> {
            for (IndexAccessor accessor : this.accessors.values()) {
                FileFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush();
                try {
                    accessor.force(flushEvent, CursorContext.NULL_CONTEXT);
                }
                finally {
                    if (flushEvent == null) continue;
                    flushEvent.close();
                }
            }
        }, () -> IOUtils.closeAllUnchecked(this.accessors.values()), this.bufferFactory});
    }

    public void additionalViolatingNodes(LongSet violatingNodes) {
        this.duplicateNodeIds.addAll((LongIterable)violatingNodes);
    }

    @Override
    public LongIterator leftOverDuplicateNodesIds() {
        return this.duplicateNodeIds.toSortedList().longIterator();
    }

    @Override
    public MemoryStatsVisitor.Visitable memoryEstimation(long numberOfNodes) {
        return visitor -> {};
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
    }

    private record Populator(IndexPopulator populator, IndexDescriptor descriptor) {
    }

    private record Index(ValueIndexReader reader, SchemaDescriptor schemaDescriptor) implements Closeable
    {
        @Override
        public void close() throws IOException {
            IOUtils.closeAll((AutoCloseable[])new ValueIndexReader[]{this.reader});
        }
    }
}

