/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.eclipse.collections.impl.stack.mutable.primitive.LongArrayStack;
import org.neo4j.internal.batchimport.Utils;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.idmapping.string.EncodingIdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.string.Radix;
import org.neo4j.internal.batchimport.cache.idmapping.string.RadixCalculator;
import org.neo4j.internal.batchimport.cache.idmapping.string.Tracker;
import org.neo4j.internal.batchimport.cache.idmapping.string.Workers;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.helpers.progress.ProgressListener;

public class ParallelSort {
    private final RadixCalculator radixCalculator;
    private final LongArray dataCache;
    private final long highestSetIndex;
    private final Tracker tracker;
    private final int threads;
    private final Radix radix;
    private final long highestSetTrackerIndex;
    private final ProgressListener progress;
    private final Comparator comparator;
    public static final Comparator DEFAULT = new Comparator(){

        @Override
        public boolean lt(long left, long pivot) {
            return Utils.unsignedCompare(left, pivot, Utils.CompareType.LT);
        }

        @Override
        public boolean ge(long right, long pivot) {
            return Utils.unsignedCompare(right, pivot, Utils.CompareType.GE);
        }

        @Override
        public long dataValue(long dataValue) {
            return dataValue;
        }
    };

    public ParallelSort(Radix radix, LongArray dataCache, long highestSetIndex, long highestSetTrackerIndex, Tracker tracker, int threads, ProgressListener progress, Comparator comparator) {
        this.highestSetTrackerIndex = highestSetTrackerIndex;
        this.progress = progress;
        this.comparator = comparator;
        this.radix = radix;
        this.radixCalculator = radix.calculator();
        this.dataCache = dataCache;
        this.highestSetIndex = highestSetIndex;
        this.tracker = tracker;
        this.threads = threads;
    }

    public synchronized SortBucket[] run() throws InterruptedException {
        SortBucket[] sortBuckets = this.sortRadix();
        int threadsNeeded = 0;
        for (int i = 0; i < this.threads && sortBuckets[i].count != 0L; ++i) {
            ++threadsNeeded;
        }
        Workers<SortWorker> sortWorkers = new Workers<SortWorker>("SortWorker");
        for (int i = 0; i < threadsNeeded && sortBuckets[i].count != 0L; ++i) {
            sortWorkers.start(new SortWorker(sortBuckets[i].baseIndex, sortBuckets[i].count));
        }
        try (ProgressListener progressListener = this.progress;){
            sortWorkers.awaitAndThrowOnError();
        }
        return sortBuckets;
    }

    private SortBucket[] sortRadix() throws InterruptedException {
        SortBucket[] sortBuckets = new SortBucket[this.threads];
        for (int i = 0; i < sortBuckets.length; ++i) {
            sortBuckets[i] = new SortBucket();
        }
        int[] bucketRange = new int[this.threads];
        Workers<TrackerInitializer> initializers = new Workers<TrackerInitializer>("TrackerInitializer");
        long dataSize = this.highestSetTrackerIndex + 1L;
        long bucketSize = dataSize / (long)this.threads;
        long count = 0L;
        long fullCount = 0L;
        long[] radixIndexCount = this.radix.getRadixIndexCounts();
        int threadIndex = 0;
        for (int i = 0; i < radixIndexCount.length && threadIndex < this.threads; ++i) {
            if (count + radixIndexCount[i] > bucketSize) {
                bucketRange[threadIndex] = count == 0L ? i : i - 1;
                sortBuckets[threadIndex].baseIndex = fullCount;
                if (count != 0L) {
                    sortBuckets[threadIndex].count = count;
                    fullCount += count;
                    this.progress.add(count);
                    count = radixIndexCount[i];
                } else {
                    sortBuckets[threadIndex].count = radixIndexCount[i];
                    fullCount += radixIndexCount[i];
                    this.progress.add(radixIndexCount[i]);
                }
                initializers.start(new TrackerInitializer(threadIndex, sortBuckets[threadIndex], threadIndex > 0 ? bucketRange[threadIndex - 1] : -1, bucketRange[threadIndex]));
                ++threadIndex;
            } else {
                count += radixIndexCount[i];
            }
            if (threadIndex != this.threads - 1 && i != radixIndexCount.length - 1) continue;
            bucketRange[threadIndex] = radixIndexCount.length;
            sortBuckets[threadIndex].baseIndex = fullCount;
            sortBuckets[threadIndex].count = dataSize - fullCount;
            initializers.start(new TrackerInitializer(threadIndex, sortBuckets[threadIndex], threadIndex > 0 ? bucketRange[threadIndex - 1] : -1, bucketRange[threadIndex]));
            break;
        }
        this.progress.close();
        Throwable error = initializers.await();
        long[] bucketIndex = new long[this.threads];
        int i = 0;
        for (TrackerInitializer initializer : initializers) {
            bucketIndex[i++] = initializer.bucketIndex;
        }
        if (error != null) {
            throw new AssertionError(error.getMessage() + "\n" + ParallelSort.dumpBuckets(sortBuckets, bucketRange, bucketIndex), error);
        }
        return sortBuckets;
    }

    private static String dumpBuckets(SortBucket[] sortBuckets, int[] bucketRange, long[] bucketIndex) {
        StringBuilder builder = new StringBuilder();
        builder.append("rangeParams:\n");
        for (SortBucket bucket : sortBuckets) {
            builder.append("  ").append(bucket).append("\n");
        }
        builder.append("bucketRange:\n");
        for (int range : bucketRange) {
            builder.append("  ").append(range).append("\n");
        }
        builder.append("bucketIndex:\n");
        for (long index : bucketIndex) {
            builder.append("  ").append(index).append("\n");
        }
        return builder.toString();
    }

    public static interface Comparator {
        public boolean lt(long var1, long var3);

        public boolean ge(long var1, long var3);

        public long dataValue(long var1);
    }

    static class SortBucket {
        int highRadixRange;
        long baseIndex;
        long count;

        SortBucket() {
        }

        public String toString() {
            return "SortBucket{highRadixRange=" + this.highRadixRange + ", baseIndex=" + this.baseIndex + ", count=" + this.count + "}";
        }
    }

    private class SortWorker
    implements Runnable {
        private final long start;
        private final long size;
        private int threadLocalProgress;
        private final long[] pivotChoice = new long[10];
        private final ThreadLocalRandom random = ThreadLocalRandom.current();

        SortWorker(long startRange, long size) {
            this.start = startRange;
            this.size = size;
        }

        void incrementProgress(long diff) {
            this.threadLocalProgress = (int)((long)this.threadLocalProgress + diff);
            if (this.threadLocalProgress >= 10000) {
                this.reportProgress();
            }
        }

        private void reportProgress() {
            ParallelSort.this.progress.add((long)this.threadLocalProgress);
            this.threadLocalProgress = 0;
        }

        @Override
        public void run() {
            this.qsort(this.start, this.start + this.size);
            this.reportProgress();
        }

        private long partition(long leftIndex, long rightIndex, long pivotIndex) {
            long li = leftIndex;
            long ri = rightIndex - 2L;
            long pi = pivotIndex;
            long pivot = EncodingIdMapper.clearCollision(ParallelSort.this.dataCache.get(ParallelSort.this.tracker.get(pi)));
            ParallelSort.this.tracker.swap(pi, rightIndex - 1L);
            long left = EncodingIdMapper.clearCollision(ParallelSort.this.dataCache.get(ParallelSort.this.tracker.get(li)));
            long right = EncodingIdMapper.clearCollision(ParallelSort.this.dataCache.get(ParallelSort.this.tracker.get(ri)));
            while (li < ri) {
                if (ParallelSort.this.comparator.lt(left, pivot)) {
                    left = EncodingIdMapper.clearCollision(ParallelSort.this.dataCache.get(ParallelSort.this.tracker.get(++li)));
                    continue;
                }
                if (ParallelSort.this.comparator.ge(right, pivot)) {
                    right = EncodingIdMapper.clearCollision(ParallelSort.this.dataCache.get(ParallelSort.this.tracker.get(--ri)));
                    continue;
                }
                ParallelSort.this.tracker.swap(li, ri);
                long temp = left;
                left = right;
                right = temp;
            }
            long partingIndex = ri;
            if (ParallelSort.this.comparator.lt(right, pivot)) {
                ++partingIndex;
            }
            ParallelSort.this.tracker.swap(rightIndex - 1L, partingIndex);
            return partingIndex;
        }

        private void qsort(long initialStart, long initialEnd) {
            LongArrayStack stack = new LongArrayStack();
            stack.push(initialStart);
            stack.push(initialEnd);
            while (!stack.isEmpty()) {
                long start;
                long end = stack.isEmpty() ? -1L : stack.pop();
                long diff = end - (start = stack.isEmpty() ? -1L : stack.pop());
                if (diff < 2L) {
                    this.incrementProgress(2L);
                    continue;
                }
                this.incrementProgress(1L);
                long pivot = start + this.random.nextLong(diff);
                pivot = this.informedPivot(start, end, pivot);
                pivot = this.partition(start, end, pivot);
                if (pivot > start) {
                    stack.push(start);
                    stack.push(pivot);
                }
                if (pivot + 1L >= end) continue;
                stack.push(pivot + 1L);
                stack.push(end);
            }
        }

        private long informedPivot(long start, long end, long randomIndex) {
            if (end - start < (long)this.pivotChoice.length) {
                return randomIndex;
            }
            long low = Math.max(start, randomIndex - 5L);
            long high = Math.min(low + 10L, end);
            int length = Numbers.safeCastLongToInt((long)(high - low));
            int j = 0;
            long i = low;
            while (i < high) {
                this.pivotChoice[j] = EncodingIdMapper.clearCollision(ParallelSort.this.dataCache.get(ParallelSort.this.tracker.get(i)));
                ++i;
                ++j;
            }
            Arrays.sort(this.pivotChoice, 0, length);
            long middle = this.pivotChoice[length / 2];
            for (long i2 = low; i2 <= high; ++i2) {
                if (EncodingIdMapper.clearCollision(ParallelSort.this.dataCache.get(ParallelSort.this.tracker.get(i2))) != middle) continue;
                return i2;
            }
            throw new IllegalStateException("The middle value somehow disappeared in front of our eyes");
        }
    }

    private class TrackerInitializer
    implements Runnable {
        private final SortBucket sortBucket;
        private final int lowRadixRangeExclusive;
        private final int highRadixRangeInclusive;
        private final int threadIndex;
        private long bucketIndex;

        TrackerInitializer(int threadIndex, SortBucket sortBucket, int lowRadixRangeExclusive, int highRadixRangeInclusive) {
            this.threadIndex = threadIndex;
            this.sortBucket = sortBucket;
            this.lowRadixRangeExclusive = lowRadixRangeExclusive;
            this.highRadixRangeInclusive = highRadixRangeInclusive;
        }

        @Override
        public void run() {
            for (long i = 0L; i <= ParallelSort.this.highestSetIndex; ++i) {
                int rIndex = ParallelSort.this.radixCalculator.radixOf(ParallelSort.this.comparator.dataValue(ParallelSort.this.dataCache.get(i)));
                if (rIndex <= this.lowRadixRangeExclusive || rIndex > this.highRadixRangeInclusive) continue;
                long trackerIndex = this.sortBucket.baseIndex + this.bucketIndex++;
                assert (ParallelSort.this.tracker.get(trackerIndex) == -1L) : "Overlapping buckets i:" + i + ", k:" + this.threadIndex + ", index:" + trackerIndex;
                ParallelSort.this.tracker.set(trackerIndex, i);
                if (this.bucketIndex != this.sortBucket.count) continue;
                this.sortBucket.highRadixRange = this.highRadixRangeInclusive;
            }
        }
    }
}

