/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.MultiReadable;
import org.neo4j.internal.batchimport.InputIterator;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.InputChunk;
import org.neo4j.internal.batchimport.input.csv.CsvInputChunkProxy;
import org.neo4j.internal.batchimport.input.csv.CsvInputIterator;
import org.neo4j.internal.batchimport.input.csv.Data;
import org.neo4j.internal.batchimport.input.csv.DataFactory;
import org.neo4j.internal.batchimport.input.csv.Header;

public class CsvGroupInputIterator
implements InputIterator {
    private final Iterator<DataFactory> source;
    private final Header.Factory headerFactory;
    private final IdType idType;
    private final Configuration config;
    private final Collector badCollector;
    private final Groups groups;
    private final boolean autoSkipHeaders;
    private final Header.Monitor monitor;
    private CsvInputIterator current;
    private int groupId;

    public CsvGroupInputIterator(Iterator<DataFactory> source, Header.Factory headerFactory, IdType idType, Configuration config, Collector badCollector, Groups groups, boolean autoSkipHeaders, Header.Monitor monitor) {
        this.source = source;
        this.headerFactory = headerFactory;
        this.idType = idType;
        this.config = config;
        this.badCollector = badCollector;
        this.groups = groups;
        this.autoSkipHeaders = autoSkipHeaders;
        this.monitor = monitor;
    }

    public CsvInputChunkProxy newChunk() {
        return new CsvInputChunkProxy();
    }

    static Extractors extractors(Configuration config) {
        return new Extractors(config.arrayDelimiter(), config.emptyQuotedStringsAsNull());
    }

    public synchronized boolean next(InputChunk chunk) throws IOException {
        while (true) {
            if (this.current == null) {
                if (!this.source.hasNext()) {
                    return false;
                }
                Data data = this.source.next().create(this.config);
                this.current = new CsvInputIterator((CharReadable)new MultiReadable(data.stream()), data.decorator(), this.headerFactory, this.idType, this.config, this.groups, this.badCollector, CsvGroupInputIterator.extractors(this.config), this.groupId++, this.autoSkipHeaders, this.monitor);
            }
            if (this.current.next((CsvInputChunkProxy)chunk)) {
                return true;
            }
            this.current.close();
            this.current = null;
        }
    }

    public void close() {
        try {
            if (this.current != null) {
                this.current.close();
            }
            this.current = null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

