/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.IOException;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.Chunker;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Source;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.csv.CsvInputParser;
import org.neo4j.internal.batchimport.input.csv.Decorator;
import org.neo4j.internal.batchimport.input.csv.EagerCsvInputChunk;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.batchimport.input.csv.InputEntityArray;

public class EagerParserChunker
implements Chunker {
    private final CharSeeker seeker;
    private final CsvInputParser parser;
    private final int chunkSize;
    private final Decorator decorator;

    public EagerParserChunker(CharReadable reader, IdType idType, Header header, Collector badCollector, Extractors extractors, int chunkSize, Configuration config, Decorator decorator) {
        this.chunkSize = chunkSize;
        this.decorator = decorator;
        this.seeker = CharSeekers.charSeeker((CharReadable)reader, (Configuration)config, (boolean)true);
        this.parser = new CsvInputParser(this.seeker, config.delimiter(), idType, header, badCollector, extractors);
    }

    public boolean nextChunk(Source.Chunk chunk) throws IOException {
        int cursor;
        InputEntityArray entities = new InputEntityArray(this.chunkSize);
        InputEntityVisitor decorated = (InputEntityVisitor)this.decorator.apply(entities);
        for (cursor = 0; cursor < this.chunkSize && this.parser.next(decorated); ++cursor) {
        }
        if (cursor > 0) {
            ((EagerCsvInputChunk)chunk).initialize(entities.toArray());
            return true;
        }
        return false;
    }

    public long position() {
        return this.seeker.position();
    }

    public void close() throws IOException {
        this.parser.close();
    }

    public Source.Chunk newChunk() {
        throw new UnsupportedOperationException();
    }
}

