/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.idmapping.string.CollisionValues;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.string.UTF8;

public class StringCollisionValues
implements CollisionValues {
    private final long chunkSize;
    private final ByteArray cache;
    private long offset;
    private ByteArray current;

    public StringCollisionValues(NumberArrayFactory factory, long length, MemoryTracker memoryTracker) {
        int remainder = (int)(length % 8192L);
        if (remainder != 0) {
            length += (long)(8192 - remainder);
        }
        this.chunkSize = Long.max(length, 8192L);
        this.cache = factory.newDynamicByteArray(this.chunkSize, new byte[1], memoryTracker);
        this.current = (ByteArray)this.cache.at(0L);
    }

    @Override
    public long add(Object id) {
        String string = (String)id;
        byte[] bytes = UTF8.encode((String)string);
        int length = bytes.length;
        if (length > 65535) {
            throw new IllegalArgumentException(string);
        }
        long startOffset = this.offset;
        this.cache.setByte(this.offset++, 0, (byte)length);
        this.cache.setByte(this.offset++, 0, (byte)(length >>> 8));
        this.current = (ByteArray)this.cache.at(this.offset);
        int i = 0;
        while (i < length) {
            int bytesLeftToWrite = length - i;
            int bytesLeftInChunk = (int)(this.chunkSize - this.offset % this.chunkSize);
            int bytesToWriteInThisChunk = Integer.min(bytesLeftToWrite, bytesLeftInChunk);
            for (int j = 0; j < bytesToWriteInThisChunk; ++j) {
                this.current.setByte(this.offset++, 0, bytes[i++]);
            }
            if (length <= i) continue;
            this.current = (ByteArray)this.cache.at(this.offset);
        }
        return startOffset;
    }

    @Override
    public Object get(long offset) {
        int length = this.cache.getByte(offset++, 0) & 0xFF;
        long l = offset++;
        ByteArray array = (ByteArray)this.cache.at(offset);
        byte[] bytes = new byte[length |= (this.cache.getByte(l, 0) & 0xFF) << 8];
        int i = 0;
        while (i < length) {
            int bytesLeftToRead = length - i;
            int bytesLeftInChunk = (int)(this.chunkSize - offset % this.chunkSize);
            int bytesToReadInThisChunk = Integer.min(bytesLeftToRead, bytesLeftInChunk);
            for (int j = 0; j < bytesToReadInThisChunk; ++j) {
                bytes[i++] = array.getByte(offset++, 0);
            }
            if (length <= i) continue;
            array = (ByteArray)this.cache.at(offset);
        }
        return UTF8.decode((byte[])bytes);
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        this.cache.acceptMemoryStatsVisitor(visitor);
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

