/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.DynamicByteArray;
import org.neo4j.internal.batchimport.cache.DynamicIntArray;
import org.neo4j.internal.batchimport.cache.DynamicLongArray;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.LongArray;

public interface NumberArrayFactory {
    default public IntArray newIntArray(long length, int defaultValue) {
        return this.newIntArray(length, defaultValue, 0L);
    }

    public IntArray newIntArray(long var1, int var3, long var4);

    public IntArray newDynamicIntArray(long var1, int var3);

    default public LongArray newLongArray(long length, long defaultValue) {
        return this.newLongArray(length, defaultValue, 0L);
    }

    public LongArray newLongArray(long var1, long var3, long var5);

    public LongArray newDynamicLongArray(long var1, long var3);

    default public ByteArray newByteArray(long length, byte[] defaultValue) {
        return this.newByteArray(length, defaultValue, 0L);
    }

    public ByteArray newByteArray(long var1, byte[] var3, long var4);

    public ByteArray newDynamicByteArray(long var1, byte[] var3);

    public static abstract class Adapter
    implements NumberArrayFactory {
        @Override
        public IntArray newDynamicIntArray(long chunkSize, int defaultValue) {
            return new DynamicIntArray((NumberArrayFactory)this, chunkSize, defaultValue);
        }

        @Override
        public LongArray newDynamicLongArray(long chunkSize, long defaultValue) {
            return new DynamicLongArray((NumberArrayFactory)this, chunkSize, defaultValue);
        }

        @Override
        public ByteArray newDynamicByteArray(long chunkSize, byte[] defaultValue) {
            return new DynamicByteArray((NumberArrayFactory)this, chunkSize, defaultValue);
        }
    }

    public static class AllocationFailure {
        private final Throwable failure;
        private final NumberArrayFactory factory;

        AllocationFailure(Throwable failure, NumberArrayFactory factory) {
            this.failure = failure;
            this.factory = factory;
        }

        public Throwable getFailure() {
            return this.failure;
        }

        public NumberArrayFactory getFactory() {
            return this.factory;
        }
    }

    public static interface Monitor {
        public void allocationSuccessful(long var1, NumberArrayFactory var3, Iterable<AllocationFailure> var4);
    }
}

