/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.PageCacheNumberArray;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;

public class PageCacheLongArray
extends PageCacheNumberArray<LongArray>
implements LongArray {
    PageCacheLongArray(PagedFile pagedFile, long length, long defaultValue, long base) throws IOException {
        super(pagedFile, 8, length, defaultValue, base);
    }

    @Override
    public long get(long index) {
        long l;
        block9: {
            long pageId = this.pageId(index);
            int offset = this.offset(index);
            PageCursor cursor = this.pagedFile.io(pageId, 1);
            try {
                long result;
                cursor.next();
                do {
                    result = cursor.getLong(offset);
                } while (cursor.shouldRetry());
                this.checkBounds(cursor);
                l = result;
                if (cursor == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            cursor.close();
        }
        return l;
    }

    @Override
    public void set(long index, long value) {
        long pageId = this.pageId(index);
        int offset = this.offset(index);
        try (PageCursor cursor = this.pagedFile.io(pageId, 6);){
            cursor.next();
            cursor.putLong(offset, value);
            this.checkBounds(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

