/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.OffHeapRegularNumberArray;
import org.neo4j.internal.unsafe.UnsafeUtil;

public class OffHeapLongArray
extends OffHeapRegularNumberArray<LongArray>
implements LongArray {
    private final long defaultValue;

    public OffHeapLongArray(long length, long defaultValue, long base) {
        super(length, 3, base);
        this.defaultValue = defaultValue;
        this.clear();
    }

    @Override
    public long get(long index) {
        return UnsafeUtil.getLong((long)this.addressOf(index));
    }

    @Override
    public void set(long index, long value) {
        UnsafeUtil.putLong((long)this.addressOf(index), (long)value);
    }

    @Override
    public void clear() {
        if (this.isByteUniform(this.defaultValue)) {
            UnsafeUtil.setMemory((long)this.address, (long)(this.length << this.shift), (byte)((byte)this.defaultValue));
        } else {
            long i = 0L;
            long adr = this.address;
            while (i < this.length) {
                UnsafeUtil.putLong((long)adr, (long)this.defaultValue);
                ++i;
                adr += (long)this.itemSize;
            }
        }
    }

    public long getAndAdd(long index, long delta) {
        return UnsafeUtil.getAndAddLong(null, (long)this.addressOf(index), (long)delta);
    }
}

