/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.util.function.ToIntFunction;
import org.neo4j.internal.batchimport.input.InputEntity;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class Inputs {
    private Inputs() {
    }

    public static int calculatePropertySize(InputEntity entity, ToIntFunction<Value[]> valueSizeCalculator) {
        int size = 0;
        int propertyCount = entity.propertyCount();
        if (propertyCount > 0) {
            Value[] values = new Value[propertyCount];
            for (int i = 0; i < propertyCount; ++i) {
                Object propertyValue = entity.propertyValue(i);
                values[i] = propertyValue instanceof Value ? (Value)propertyValue : Values.of((Object)propertyValue);
            }
            size += valueSizeCalculator.applyAsInt(values);
        }
        return size;
    }
}

