/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.neo4j.internal.batchimport.cache.BaseNumberArray;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NumberArray;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.unsafe.UnsafeUtil;

public abstract class OffHeapNumberArray<N extends NumberArray<N>>
extends BaseNumberArray<N> {
    private final long allocatedAddress;
    protected final long address;
    protected final long length;
    private final long allocatedBytes;
    private boolean closed;

    protected OffHeapNumberArray(long length, int itemSize, long base) {
        super(itemSize, base);
        UnsafeUtil.assertHasUnsafe();
        this.length = length;
        long dataSize = length * (long)itemSize;
        if (UnsafeUtil.allowUnalignedMemoryAccess || !Numbers.isPowerOfTwo((long)itemSize)) {
            this.allocatedBytes = dataSize;
            this.allocatedAddress = this.address = UnsafeUtil.allocateMemory((long)this.allocatedBytes);
        } else {
            this.allocatedBytes = dataSize + (long)itemSize - 1L;
            this.allocatedAddress = UnsafeUtil.allocateMemory((long)this.allocatedBytes);
            this.address = UnsafeUtil.alignedMemory((long)this.allocatedAddress, (int)itemSize);
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        visitor.offHeapUsage(this.allocatedBytes);
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.length > 0L) {
                UnsafeUtil.free((long)this.allocatedAddress, (long)this.allocatedBytes);
            }
            this.closed = true;
        }
    }
}

