/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.csv;

import java.io.IOException;
import java.util.Objects;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.InputEntityVisitor;
import org.neo4j.csv.reader.AutoReadingSource;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.Chunker;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.HeaderSkipper;
import org.neo4j.csv.reader.SectionedCharBuffer;
import org.neo4j.csv.reader.Source;
import org.neo4j.internal.batchimport.input.csv.CsvInputIterator;
import org.neo4j.internal.batchimport.input.csv.CsvInputParser;
import org.neo4j.internal.batchimport.input.csv.Decorator;
import org.neo4j.internal.batchimport.input.csv.EagerCsvInputChunk;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.batchimport.input.csv.InputEntityArray;

public class EagerParserChunker
implements Chunker {
    private final CharSeeker seeker;
    private final CsvInputParser parser;
    private final int chunkSize;
    private final Decorator decorator;

    public EagerParserChunker(CharReadable reader, IdType idType, Header header, Collector badCollector, Extractors extractors, int chunkSize, Configuration config, Decorator decorator, boolean autoSkipHeaders, boolean delimitIds) {
        this.chunkSize = chunkSize;
        this.decorator = decorator;
        this.seeker = CharSeekers.charSeeker((CharReadable)reader, (Configuration)config, (boolean)true, (r, c) -> autoSkipHeaders ? new AutoSkipHeaderSource((CharReadable)r, (Configuration)c, idType, header) : new AutoReadingSource(r, c.bufferSize()));
        this.parser = new CsvInputParser(this.seeker, config.delimiter(), idType, header, badCollector, extractors, delimitIds);
    }

    public boolean nextChunk(Source.Chunk chunk) throws IOException {
        int cursor;
        InputEntityArray entities = new InputEntityArray(this.chunkSize);
        InputEntityVisitor decorated = (InputEntityVisitor)this.decorator.apply(entities);
        for (cursor = 0; cursor < this.chunkSize && this.parser.next(decorated); ++cursor) {
        }
        if (cursor > 0) {
            ((EagerCsvInputChunk)chunk).initialize(entities.toArray());
            return true;
        }
        return false;
    }

    public long position() {
        return this.seeker.position();
    }

    public void close() throws IOException {
        this.parser.close();
    }

    public Source.Chunk newChunk() {
        throw new UnsupportedOperationException();
    }

    private static class AutoSkipHeaderSource
    implements Source {
        private final CharReadable reader;
        private final HeaderSkipper headerSkipper;
        private SectionedCharBuffer charBuffer;
        private String sourceDescription;

        public AutoSkipHeaderSource(CharReadable reader, Configuration configuration, IdType idType, Header header) {
            this.reader = reader;
            this.charBuffer = new SectionedCharBuffer(configuration.bufferSize());
            this.headerSkipper = CsvInputIterator.headerSkip(header, true, configuration, idType);
        }

        public Source.Chunk nextChunk(int seekStartPos) throws IOException {
            this.charBuffer = this.reader.read(this.charBuffer, seekStartPos == -1 ? this.charBuffer.pivot() : seekStartPos);
            int back = this.charBuffer.back();
            int length = this.charBuffer.available();
            int startPosition = this.charBuffer.pivot();
            String newSourceDescription = this.reader.sourceDescription();
            if (!Objects.equals(this.sourceDescription, newSourceDescription)) {
                int charsSkipped = this.headerSkipper.skipHeader(this.charBuffer.array(), this.charBuffer.back(), this.charBuffer.available());
                if (charsSkipped > 0) {
                    back += charsSkipped;
                    length -= charsSkipped;
                    startPosition += charsSkipped;
                }
                this.sourceDescription = newSourceDescription;
            }
            return new Source.GivenChunk(this.charBuffer.array(), length, this.charBuffer.pivot(), this.reader.sourceDescription(), startPosition, back);
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }
}

