/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.batchimport.api.input.ApplicationMode;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.batchimport.api.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.InputEntity;
import org.neo4j.internal.id.IdSequence;

public abstract class BatchedInputEntityVisitor
implements InputEntityVisitor {
    private final int batchSize;
    private final List<InputEntity> batch = new ArrayList<InputEntity>();
    private InputEntity current = new InputEntity();

    protected BatchedInputEntityVisitor(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean propertyId(long nextProp) {
        return this.current.propertyId(nextProp);
    }

    public boolean properties(ByteBuffer properties, boolean offloaded) {
        return this.current.properties(properties, offloaded);
    }

    public boolean property(String key, Object value, boolean identifier) {
        return this.current.property(key, value, identifier);
    }

    public boolean property(int propertyKeyId, Object value, boolean identifier) {
        return this.current.property(propertyKeyId, value, identifier);
    }

    public boolean removedProperties(String[] keys) {
        return this.current.removedProperties(keys);
    }

    public boolean removedProperties(int[] keys) {
        return this.current.removedProperties(keys);
    }

    public boolean id(long id) {
        return this.current.id(id);
    }

    public boolean id(Object id, Group group) {
        return this.current.id(id, group);
    }

    public boolean id(Object id, Group group, IdSequence idSequence) {
        return this.current.id(id, group, idSequence);
    }

    public boolean labels(String[] labels) {
        return this.current.labels(labels);
    }

    public boolean labels(int[] labels) {
        return this.current.labels(labels);
    }

    public boolean removedLabels(String[] labels) {
        return this.current.removedLabels(labels);
    }

    public boolean removedLabels(int[] labels) {
        return this.current.removedLabels(labels);
    }

    public boolean labelField(long labelField) {
        return this.current.labelField(labelField);
    }

    public boolean startId(long id) {
        return this.current.startId(id);
    }

    public boolean startId(Object id, Group group) {
        return this.current.startId(id, group);
    }

    public boolean endId(long id) {
        return this.current.endId(id);
    }

    public boolean endId(Object id, Group group) {
        return this.current.endId(id, group);
    }

    public boolean type(int type) {
        return this.current.type(type);
    }

    public boolean type(String type) {
        return this.current.type(type);
    }

    public boolean applicationMode(ApplicationMode mode) {
        return this.current.applicationMode(mode);
    }

    public void endOfEntity() throws IOException {
        this.batch.add(this.current);
        this.current = new InputEntity();
        if (this.batch.size() >= this.batchSize) {
            this.handle(this.batch.toArray(new InputEntity[0]));
            this.batch.clear();
        }
    }

    public void reset() {
        this.current = new InputEntity();
    }

    public void close() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        if (!this.batch.isEmpty()) {
            InputEntity[] entities = this.batch.toArray(new InputEntity[0]);
            this.batch.clear();
            this.handle(entities);
        }
    }

    protected abstract void handle(InputEntity[] var1) throws IOException;
}

