/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import org.neo4j.internal.batchimport.cache.BaseDynamicArray;
import org.neo4j.internal.batchimport.cache.BufferFactory;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.memory.MemoryTracker;

class LongArrayImpl
extends BaseDynamicArray
implements LongArray {
    private static final VarHandle VH_LONG_BYTE_BUFFER = MethodHandles.byteBufferViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);

    LongArrayImpl(long maxNumberOfElements, int elementsPerChunk, byte defaultValue, BufferFactory bufferFactory, MemoryTracker memoryTracker) {
        super(maxNumberOfElements, 8, elementsPerChunk, defaultValue, bufferFactory, memoryTracker);
    }

    @Override
    public long get(long index) {
        return VH_LONG_BYTE_BUFFER.get(this.getBuffer(index), this.offset(index));
    }

    @Override
    public void set(long index, long value) {
        VH_LONG_BYTE_BUFFER.set(this.getBuffer(index), this.offset(index), value);
    }

    @Override
    public boolean compareAndSet(long index, long expected, long value) {
        return VH_LONG_BYTE_BUFFER.compareAndSet(this.getBuffer(index), this.offset(index), expected, value);
    }

    @Override
    public long compareAndExchange(long index, long expected, long value) {
        return VH_LONG_BYTE_BUFFER.compareAndExchange(this.getBuffer(index), this.offset(index), expected, value);
    }

    @Override
    public void getAndAdd(long index, long delta) {
        VH_LONG_BYTE_BUFFER.getAndAdd(this.getBuffer(index), this.offset(index), delta);
    }

    @Override
    protected int offset(long index) {
        return (int)(index & (long)this.bufferMask) << 3;
    }
}

