/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.nio.ByteBuffer;
import java.util.List;
import org.eclipse.collections.api.factory.primitive.IntObjectMaps;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.neo4j.batchimport.api.input.ApplicationMode;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

public interface SchemaMonitor
extends AutoCloseable {
    public static final ExistingPropertyKeysLookup NO_EXISTING_PROPERTY_KEYS_LOOKUP = (entityId, keysToLookup) -> IntSets.immutable.empty();
    public static final ViolationVisitor NO_VIOLATION_VISITOR = (entity, constraintDescription) -> {};
    public static final SchemaMonitor NO_MONITOR = new SchemaMonitor(){

        @Override
        public boolean handle(Entity entity, ExistingPropertyKeysLookup existingPropertyKeysLookup, ViolationVisitor violationVisitor, UniquenessIndexUpdatesListener uniquenessIndexUpdatesListener) {
            return true;
        }

        @Override
        public void indexUpdate(IndexEntryUpdate indexUpdate) {
        }

        @Override
        public boolean directIndexUpdate(IndexEntryUpdate indexUpdate) {
            return true;
        }

        @Override
        public boolean checkUniqueness(ValueIndexEntryUpdate[] checks) {
            return true;
        }

        @Override
        public void close() {
        }
    };
    public static final UniquenessIndexUpdatesListener EMPTY_UNIQUENESS_UPDATES_LISTENER = new UniquenessIndexUpdatesListener(){

        @Override
        public boolean shouldApply(ValueIndexEntryUpdate update) {
            return true;
        }

        @Override
        public void updates(List<ValueIndexEntryUpdate> updates) {
        }

        @Override
        public void endEntity() {
        }
    };

    public boolean handle(Entity var1, ExistingPropertyKeysLookup var2, ViolationVisitor var3, UniquenessIndexUpdatesListener var4);

    default public boolean[] handle(Entity[] entities, ExistingPropertyKeysLookup existingPropertyKeysLookup, ViolationVisitor violationVisitor, UniquenessIndexUpdatesListener uniquenessIndexUpdatesListener) {
        boolean[] result = new boolean[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            Entity entity = entities[i];
            result[i] = entity != null && this.handle(entity, existingPropertyKeysLookup, violationVisitor, uniquenessIndexUpdatesListener);
        }
        return result;
    }

    public void indexUpdate(IndexEntryUpdate var1);

    public boolean directIndexUpdate(IndexEntryUpdate var1);

    public boolean checkUniqueness(ValueIndexEntryUpdate[] var1);

    @Override
    public void close();

    public static class Entity {
        public final Object inputId;
        public long entityId;
        public final List<StorageProperty> properties;
        public final List<StorageProperty> identifyingProperties;
        public final ByteBuffer encodedProperties;
        public final boolean encodedPropertiesOffloaded;
        public final IntSet removedProperties;
        public final IntSet existingEntityTokens;
        public final IntSet entityTokens;
        public final IntSet removedEntityTokens;
        public final ApplicationMode mode;
        private IntObjectMap<Value> propertiesMap;
        private int[] sortedEntityTokens;
        private int[] sortedExistingEntityTokens;
        private IntSet identifierPropertyKeys;

        public Entity(Object inputId, long entityId, List<StorageProperty> properties, List<StorageProperty> identifyingProperties, ByteBuffer encodedProperties, boolean encodedPropertiesOffloaded, IntSet removedProperties, IntSet existingEntityTokens, IntSet entityTokens, IntSet removedEntityTokens, ApplicationMode mode) {
            this.inputId = inputId;
            this.entityId = entityId;
            this.properties = properties;
            this.identifyingProperties = identifyingProperties;
            this.encodedProperties = encodedProperties;
            this.encodedPropertiesOffloaded = encodedPropertiesOffloaded;
            this.removedProperties = removedProperties;
            this.existingEntityTokens = existingEntityTokens;
            this.entityTokens = entityTokens;
            this.removedEntityTokens = removedEntityTokens;
            this.mode = mode;
        }

        public IntObjectMap<Value> propertiesMap() {
            if (this.propertiesMap == null) {
                MutableIntObjectMap map = IntObjectMaps.mutable.ofInitialCapacity(this.properties.size());
                for (StorageProperty property : this.properties) {
                    map.put(property.propertyKeyId(), (Object)property.value());
                }
                this.propertiesMap = map;
            }
            return this.propertiesMap;
        }

        int[] sortedEntityTokens() {
            if (this.sortedEntityTokens == null) {
                this.sortedEntityTokens = this.entityTokens.toSortedArray();
            }
            return this.sortedEntityTokens;
        }

        int[] sortedExistingEntityTokens() {
            if (this.sortedExistingEntityTokens == null) {
                this.sortedExistingEntityTokens = this.existingEntityTokens.toSortedArray();
            }
            return this.sortedExistingEntityTokens;
        }

        IntSet identifierPropertyKeys() {
            if (this.identifierPropertyKeys == null) {
                MutableIntSet keys = IntSets.mutable.withInitialCapacity(this.identifyingProperties.size());
                for (StorageProperty identifyingProperty : this.identifyingProperties) {
                    keys.add(identifyingProperty.propertyKeyId());
                }
                this.identifierPropertyKeys = keys;
            }
            return this.identifierPropertyKeys;
        }

        public Entity newWithEntityId(long entityId) {
            return new Entity(this.inputId, entityId, this.properties, this.identifyingProperties, this.encodedProperties, this.encodedPropertiesOffloaded, this.removedProperties, this.existingEntityTokens, this.entityTokens, this.removedEntityTokens, this.mode);
        }
    }

    public static interface ExistingPropertyKeysLookup {
        public IntSet lookupPropertyKeys(long var1, IntSet var3);
    }

    public static interface ViolationVisitor {
        public void accept(Entity var1, String var2);
    }

    public static interface UniquenessIndexUpdatesListener {
        public boolean shouldApply(ValueIndexEntryUpdate var1);

        public void updates(List<ValueIndexEntryUpdate> var1);

        public void endEntity();
    }

    public static class Relationship
    extends Entity {
        public final long startNodeId;
        public final long endNodeId;
        public final Object startId;
        public final Object endId;

        public Relationship(long entityId, List<StorageProperty> properties, List<StorageProperty> identifyingProperties, ByteBuffer encodedProperties, boolean encodedPropertiesOffloaded, IntSet removedProperties, IntSet existingEntityTokens, IntSet entityTokens, IntSet removedEntityTokens, ApplicationMode mode, long startNodeId, long endNodeId, Object startId, Object endId) {
            super(null, entityId, properties, identifyingProperties, encodedProperties, encodedPropertiesOffloaded, removedProperties, existingEntityTokens, entityTokens, removedEntityTokens, mode);
            this.startNodeId = startNodeId;
            this.endNodeId = endNodeId;
            this.startId = startId;
            this.endId = endId;
        }

        public int relationshipType() {
            return this.entityTokens.intIterator().next();
        }

        public Relationship newRelationshipWithId(long relationshipId) {
            return new Relationship(relationshipId, this.properties, this.identifyingProperties, this.encodedProperties, this.encodedPropertiesOffloaded, this.removedProperties, this.existingEntityTokens, this.entityTokens, this.removedEntityTokens, this.mode, this.startNodeId, this.endNodeId, this.startId, this.endId);
        }

        public Relationship newWithEntityIds(long relationshipId, long startNodeId, long endNodeId) {
            return new Relationship(relationshipId, this.properties, this.identifyingProperties, this.encodedProperties, this.encodedPropertiesOffloaded, this.removedProperties, this.existingEntityTokens, this.entityTokens, this.removedEntityTokens, this.mode, startNodeId, endNodeId, this.startId, this.endId);
        }
    }
}

