/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.batchimport.api.input.ApplicationMode;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.internal.batchimport.ImportIndexBuilder;
import org.neo4j.internal.batchimport.ImportPropertyConstraintEnforcer;
import org.neo4j.internal.batchimport.PopulationWorkJobScheduler;
import org.neo4j.internal.batchimport.SchemaMonitor;
import org.neo4j.internal.batchimport.SchemaMonitors;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.TypeRepresentation;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

public class OtherAffectedSchemaMonitors
implements SchemaMonitors {
    private final SchemaCache schemaCache;
    private final EntityType entityType;
    private final LongToLongFunction indexedEntityIdConverter;
    private final boolean generateNonUniqueIndexUpdates;
    private final ImportPropertyConstraintEnforcer propertyConstraints;
    private final ImportIndexBuilder indexBuilder;

    public OtherAffectedSchemaMonitors(FileSystemAbstraction fileSystem, IndexProviderMap indexProviderMap, IndexProviderMap tempIndexes, SchemaCache schemaCache, TokenNameLookup tokenNameLookup, EntityType entityType, ImmutableSet<OpenOption> openOptions, PopulationWorkJobScheduler workScheduler, LongToLongFunction indexedEntityIdConverter, LongToLongFunction entityIdFromIndexIdConverter, Configuration configuration, IndexStatisticsStore indexStatisticsStore, StorageEngineIndexingBehaviour indexingBehaviour, boolean generateNonUniqueIndexUpdates, Predicate<IndexDescriptor> excludedIndexes, Config config, IndexPopulator.Configuration indexPopulatorConfiguration) {
        this.schemaCache = schemaCache;
        this.entityType = entityType;
        this.indexedEntityIdConverter = indexedEntityIdConverter;
        this.generateNonUniqueIndexUpdates = generateNonUniqueIndexUpdates;
        this.propertyConstraints = new ImportPropertyConstraintEnforcer(schemaCache, entityType);
        this.indexBuilder = new ImportIndexBuilder(fileSystem, indexProviderMap, tempIndexes, tokenNameLookup, openOptions, workScheduler, (LongToLongFunction & Serializable)id -> id, entityIdFromIndexIdConverter, configuration, indexStatisticsStore, indexingBehaviour, excludedIndexes, config, indexPopulatorConfiguration);
    }

    @Override
    public SchemaMonitor get() {
        return new OtherAffectedSchemaMonitor();
    }

    @Override
    public LongSet validate(Collector collector, ProgressMonitorFactory progressMonitorFactory) throws IOException {
        return this.indexBuilder.validate(collector, progressMonitorFactory);
    }

    @Override
    public void writeToTarget(LongPredicate violatingIdMapperEntityIds, LongSet otherViolatingEntityIds, ProgressMonitorFactory progressMonitorFactory) {
        this.indexBuilder.writeToTarget(violatingIdMapperEntityIds, otherViolatingEntityIds, progressMonitorFactory);
    }

    @Override
    public void close() throws IOException {
        this.indexBuilder.close();
    }

    @Override
    public LongSet affectedIndexes() {
        return this.indexBuilder.affectedIndexes();
    }

    @Override
    public Optional<IndexAccessor> openIndexAccessor(long indexId) throws IOException {
        return this.indexBuilder.openIndexAccessor(indexId);
    }

    @Override
    public Optional<IndexDescriptor> indexDescriptor(long indexId) {
        return this.indexBuilder.indexDescriptor(indexId);
    }

    private class OtherAffectedSchemaMonitor
    implements SchemaMonitor {
        private OtherAffectedSchemaMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handle(SchemaMonitor.Entity entity, SchemaMonitor.ExistingPropertyKeysLookup existingPropertyKeysLookup, SchemaMonitor.ViolationVisitor violationVisitor, SchemaMonitor.UniquenessIndexUpdatesListener uniquenessIndexUpdatesListener) {
            try {
                ApplicationMode mode = entity.mode;
                if (mode == null || mode == ApplicationMode.CREATE) {
                    boolean propertyExistenceOk = this.checkPropertyExistenceConstraintsOnCreate(entity, violationVisitor);
                    boolean propertyTypesOk = this.checkPropertyTypeConstraints(entity, violationVisitor);
                    if (propertyExistenceOk && propertyTypesOk && OtherAffectedSchemaMonitors.this.generateNonUniqueIndexUpdates) {
                        this.generateIndexUpdatesForCreatedEntity(entity);
                    }
                    boolean bl = propertyExistenceOk && propertyTypesOk;
                    return bl;
                }
                if (mode == ApplicationMode.UPDATE) {
                    boolean propertyExistenceOk = this.checkPropertyExistenceConstraintsOnUpdate(entity, existingPropertyKeysLookup, violationVisitor);
                    boolean propertyTypesOk = this.checkPropertyTypeConstraints(entity, violationVisitor);
                    if (propertyExistenceOk && propertyTypesOk) {
                        boolean bl = this.generateAndValidateUniquenessIndexUpdates(entity, violationVisitor, uniquenessIndexUpdatesListener);
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                uniquenessIndexUpdatesListener.endEntity();
            }
        }

        private boolean checkPropertyExistenceConstraintsOnUpdate(SchemaMonitor.Entity entity, SchemaMonitor.ExistingPropertyKeysLookup existingPropertyKeysLookup, SchemaMonitor.ViolationVisitor violationVisitor) {
            IntSet affectedLabels;
            IntSet mandatoryPropertyKeys;
            if (!entity.entityTokens.isEmpty() && !(mandatoryPropertyKeys = OtherAffectedSchemaMonitors.this.propertyConstraints.mandatoryPropertyKeys(entity.sortedEntityTokens())).isEmpty()) {
                MutableIntSet mandatoryPropertyKeysLeftToCheck = IntSets.mutable.ofAll((IntIterable)mandatoryPropertyKeys);
                entity.propertiesMap().keySet().forEach(arg_0 -> ((MutableIntSet)mandatoryPropertyKeysLeftToCheck).remove(arg_0));
                if (!mandatoryPropertyKeysLeftToCheck.isEmpty()) {
                    IntSet existingRemainingKeys = existingPropertyKeysLookup.lookupPropertyKeys(entity.entityId, (IntSet)mandatoryPropertyKeysLeftToCheck);
                    existingRemainingKeys.forEach((IntProcedure & Serializable)key -> {
                        if (!entity.removedProperties.contains(key)) {
                            mandatoryPropertyKeysLeftToCheck.remove(key);
                        }
                    });
                }
                if (!mandatoryPropertyKeysLeftToCheck.isEmpty()) {
                    violationVisitor.accept(entity, "a property existence constraint");
                    return false;
                }
            }
            if (!entity.removedProperties.isEmpty() && !(affectedLabels = OtherAffectedSchemaMonitors.this.propertyConstraints.entityTokensRelatedToPropertyKeys(entity.removedProperties.toArray())).isEmpty()) {
                MutableIntSet affectedLabelsLeftToCheck = IntSets.mutable.ofAll((IntIterable)affectedLabels);
                affectedLabelsLeftToCheck.removeAll((IntIterable)entity.removedEntityTokens);
                if (affectedLabelsLeftToCheck.containsAny((IntIterable)entity.existingEntityTokens) || affectedLabelsLeftToCheck.containsAny((IntIterable)entity.entityTokens)) {
                    violationVisitor.accept(entity, "a property existence constraint");
                    return false;
                }
            }
            return true;
        }

        @Override
        public void indexUpdate(IndexEntryUpdate indexUpdate) {
            if (indexUpdate.indexKey().isUnique() && indexUpdate.updateMode() == UpdateMode.CHANGED) {
                indexUpdate = this.asRemoval(indexUpdate);
            }
            OtherAffectedSchemaMonitors.this.indexBuilder.add(indexUpdate);
        }

        @Override
        public boolean directIndexUpdate(IndexEntryUpdate indexUpdate) {
            return OtherAffectedSchemaMonitors.this.indexBuilder.addDirect(indexUpdate);
        }

        @Override
        public boolean checkUniqueness(ValueIndexEntryUpdate[] checks) {
            return OtherAffectedSchemaMonitors.this.indexBuilder.checkUniqueness(checks);
        }

        @Override
        public void close() {
            OtherAffectedSchemaMonitors.this.indexBuilder.flushOnSchemaMonitorClose();
        }

        private void generateIndexUpdatesForCreatedEntity(SchemaMonitor.Entity entity) {
            int[] propertyKeyTokens = entity.propertiesMap().keySet().toSortedArray();
            Set indexes = OtherAffectedSchemaMonitors.this.schemaCache.getValueIndexesRelatedTo(entity.sortedEntityTokens(), ArrayUtils.EMPTY_INT_ARRAY, propertyKeyTokens, true, OtherAffectedSchemaMonitors.this.entityType);
            for (IndexDescriptor index : indexes) {
                OtherAffectedSchemaMonitors.this.indexBuilder.add((IndexEntryUpdate)this.constructIndexUpdate(entity, index));
            }
        }

        private boolean generateAndValidateUniquenessIndexUpdates(SchemaMonitor.Entity entity, SchemaMonitor.ViolationVisitor violationVisitor, SchemaMonitor.UniquenessIndexUpdatesListener uniquenessIndexUpdatesListener) {
            IntObjectMap<Value> properties = entity.propertiesMap();
            IntSet identifierPropertyKeys = entity.identifierPropertyKeys();
            int[] propertyKeyTokens = identifierPropertyKeys.isEmpty() ? properties.keySet().toSortedArray() : properties.keySet().reject(arg_0 -> ((IntSet)identifierPropertyKeys).contains(arg_0)).toSortedArray();
            MutableIntSet allEntityTokens = IntSets.mutable.ofAll((IntIterable)entity.existingEntityTokens);
            allEntityTokens.addAll((IntIterable)entity.entityTokens);
            Set indexes = OtherAffectedSchemaMonitors.this.schemaCache.getValueIndexesRelatedTo(allEntityTokens.toSortedArray(), ArrayUtils.EMPTY_INT_ARRAY, propertyKeyTokens, true, OtherAffectedSchemaMonitors.this.entityType);
            if (!indexes.isEmpty()) {
                ArrayList<ValueIndexEntryUpdate> appliedAdditions = new ArrayList<ValueIndexEntryUpdate>();
                boolean failed = false;
                for (IndexDescriptor index : indexes) {
                    ValueIndexEntryUpdate indexUpdate;
                    if (!index.isUnique() || !uniquenessIndexUpdatesListener.shouldApply(indexUpdate = this.constructIndexUpdate(entity, index))) continue;
                    if (OtherAffectedSchemaMonitors.this.indexBuilder.addDirect((IndexEntryUpdate)indexUpdate)) {
                        appliedAdditions.add(indexUpdate);
                        continue;
                    }
                    failed = true;
                    violationVisitor.accept(entity, index.toString());
                    break;
                }
                if (failed) {
                    for (ValueIndexEntryUpdate updateToUndo : appliedAdditions) {
                        boolean removed = OtherAffectedSchemaMonitors.this.indexBuilder.addDirect((IndexEntryUpdate)this.asRemoval((IndexEntryUpdate)updateToUndo));
                        assert (removed);
                    }
                    return false;
                }
                uniquenessIndexUpdatesListener.updates(appliedAdditions);
            }
            return true;
        }

        private ValueIndexEntryUpdate asRemoval(IndexEntryUpdate update) {
            ValueIndexEntryUpdate valueUpdate = (ValueIndexEntryUpdate)update;
            return ValueIndexEntryUpdate.remove((long)update.getEntityId(), (IndexDescriptor)update.indexKey(), (Value[])valueUpdate.beforeValues());
        }

        private ValueIndexEntryUpdate constructIndexUpdate(SchemaMonitor.Entity entity, IndexDescriptor index) {
            int[] propertyIds = index.schema().getPropertyIds();
            Value[] values = new Value[propertyIds.length];
            for (int i = 0; i < propertyIds.length; ++i) {
                values[i] = (Value)entity.propertiesMap().get(propertyIds[i]);
            }
            return ValueIndexEntryUpdate.add((long)OtherAffectedSchemaMonitors.this.indexedEntityIdConverter.applyAsLong(entity.entityId), (IndexDescriptor)index, (Value[])values);
        }

        private boolean checkPropertyExistenceConstraintsOnCreate(SchemaMonitor.Entity entity, SchemaMonitor.ViolationVisitor violationVisitor) {
            if (OtherAffectedSchemaMonitors.this.propertyConstraints.hasPropertyExistenceConstraints()) {
                for (int entityToken : entity.sortedEntityTokens()) {
                    IntSet mandatoryPropertyKeys = OtherAffectedSchemaMonitors.this.propertyConstraints.mandatoryPropertyKeys(entityToken);
                    if (mandatoryPropertyKeys == null || entity.propertiesMap().keySet().containsAll((IntIterable)mandatoryPropertyKeys)) continue;
                    violationVisitor.accept(entity, "a property existence constraint");
                    return false;
                }
            }
            return true;
        }

        private boolean checkPropertyTypeConstraints(SchemaMonitor.Entity entity, SchemaMonitor.ViolationVisitor violationVisitor) {
            if (OtherAffectedSchemaMonitors.this.propertyConstraints.hasPropertyTypeConstraints()) {
                return this.checkPropertyTypeConstraints(entity, violationVisitor, entity.sortedEntityTokens()) && this.checkPropertyTypeConstraints(entity, violationVisitor, entity.sortedExistingEntityTokens());
            }
            return true;
        }

        private boolean checkPropertyTypeConstraints(SchemaMonitor.Entity entity, SchemaMonitor.ViolationVisitor violationVisitor, int[] tokens) {
            for (int token : tokens) {
                for (ImportPropertyConstraintEnforcer.PropertyAndType typeConstraint : OtherAffectedSchemaMonitors.this.propertyConstraints.propertyTypeConstraints(token)) {
                    Value value = (Value)entity.propertiesMap().get(typeConstraint.propertyKeyId());
                    if (!TypeRepresentation.disallows((PropertyTypeSet)typeConstraint.type(), (Value)value)) continue;
                    violationVisitor.accept(entity, "a property type constraint " + String.valueOf(value));
                    return false;
                }
            }
            return true;
        }
    }
}

