/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.parquet;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.InputEntityVisitor;
import org.neo4j.csv.reader.VectorExtractor;
import org.neo4j.exceptions.TemporalParseException;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.InputException;
import org.neo4j.internal.batchimport.input.parquet.ParquetColumn;
import org.neo4j.internal.batchimport.input.parquet.ParquetColumnType;
import org.neo4j.internal.batchimport.input.parquet.ParquetData;
import org.neo4j.internal.batchimport.input.parquet.ParquetDataReader;
import org.neo4j.internal.batchimport.input.parquet.ParquetInputChunk;
import org.neo4j.internal.batchimport.input.parquet.ParquetLogicalColumnType;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.storable.Vector;
import org.neo4j.values.storable.VectorValue;

class ParquetDataInputChunk
implements ParquetInputChunk {
    private ParquetData parquetDataFile;
    private Groups groups;
    private Supplier<ZoneId> defaultTimezoneSupplier;
    private String arrayDelimiter;
    private String vectorDelimiter;
    private IdType idType;
    private Iterator<List<Object>> iterator;
    private Collection<String> filteredLabelsOrTypes;
    private final Map<Object, Collection<String>> labelCache = new HashMap<Object, Collection<String>>();

    ParquetDataInputChunk() {
    }

    @Override
    public boolean readWith(ParquetDataReader reader) {
        try {
            this.iterator = reader.next();
            if (this.iterator == null) {
                return false;
            }
            this.parquetDataFile = reader.getParquetDataFile();
            this.groups = reader.getGroups();
            this.defaultTimezoneSupplier = reader.getDefaultTimezoneSupplier();
            this.arrayDelimiter = Pattern.quote(reader.getArrayDelimiter());
            this.vectorDelimiter = Pattern.quote(reader.getVectorDelimiter());
            this.idType = reader.getIdType();
            this.filteredLabelsOrTypes = this.filterEmptyLabelsAndTrim(this.parquetDataFile.labelsOrType());
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
    }

    public boolean next(InputEntityVisitor entityToHydrate) throws IOException {
        if (this.iterator == null || !this.iterator.hasNext()) {
            return false;
        }
        List<ParquetColumn> columns = this.parquetDataFile.columns();
        List<Object> readData = this.iterator.next();
        ArrayList<String> labels = new ArrayList<String>(this.filteredLabelsOrTypes);
        StringBuilder idValue = new StringBuilder();
        StringBuilder startIdValue = new StringBuilder();
        StringBuilder endIdValue = new StringBuilder();
        String type = this.filteredLabelsOrTypes.isEmpty() ? "" : this.filteredLabelsOrTypes.iterator().next();
        boolean isRelationshipEntity = false;
        for (int i = 0; i < readData.size(); ++i) {
            String typeColumnData;
            ParquetColumn parquetColumn = columns.get(i);
            Object readDatum = readData.get(i);
            if (readDatum == null || this.isEmptyString(readDatum) || parquetColumn.isIgnoredColumn()) continue;
            if (parquetColumn.isIdColumn()) {
                boolean isActualIdColumn;
                if (this.idType == IdType.STRING && (parquetColumn.columnIdType() == IdType.STRING || parquetColumn.columnIdType() == null)) {
                    if (!idValue.isEmpty()) {
                        idValue.append('\u0007');
                    }
                    idValue.append(this.resolveIdByType(readDatum, null));
                } else if (this.idType == IdType.INTEGER || parquetColumn.columnIdType() == IdType.INTEGER) {
                    entityToHydrate.id(this.resolveIdByType(readDatum, parquetColumn.columnIdType()), this.groups.get(this.parquetDataFile.groupName()));
                } else {
                    entityToHydrate.id(((Long)this.resolveIdByType(readDatum, parquetColumn.columnIdType())).longValue());
                }
                boolean bl = isActualIdColumn = this.idType == IdType.ACTUAL && parquetColumn.isIdColumn();
                if (!isActualIdColumn && parquetColumn.hasPropertyName()) {
                    entityToHydrate.property(parquetColumn.propertyName(), this.convertType(readDatum, parquetColumn), true);
                }
            }
            if (parquetColumn.isLabelColumn()) {
                labels.addAll(this.readLabelsFromEntry(readDatum));
            }
            if (parquetColumn.hasPropertyName() && parquetColumn.logicalColumnType() == ParquetLogicalColumnType.PROPERTY) {
                if (readDatum instanceof Map) {
                    Map rawDataMap;
                    Map dataMap = rawDataMap = (Map)readDatum;
                    for (Map.Entry entry : dataMap.entrySet()) {
                        entityToHydrate.property((String)entry.getKey(), this.convertType(entry.getValue(), parquetColumn), parquetColumn.isIdentifier());
                    }
                } else {
                    entityToHydrate.property(parquetColumn.propertyName(), this.convertType(readDatum, parquetColumn), parquetColumn.isIdentifier());
                }
            }
            if (parquetColumn.isStartId()) {
                if (this.idType == IdType.STRING && (parquetColumn.columnIdType() == IdType.STRING || parquetColumn.columnIdType() == null)) {
                    if (!startIdValue.isEmpty()) {
                        startIdValue.append('\u0007');
                    }
                    startIdValue.append(this.resolveIdByType(readDatum, null));
                } else {
                    entityToHydrate.startId(this.resolveIdByType(readDatum, null), this.groups.get(this.parquetDataFile.relationshipStartIdGroupName()));
                }
                isRelationshipEntity = true;
            }
            if (parquetColumn.isEndId()) {
                if (this.idType == IdType.STRING && (parquetColumn.columnIdType() == IdType.STRING || parquetColumn.columnIdType() == null)) {
                    if (!endIdValue.isEmpty()) {
                        endIdValue.append('\u0007');
                    }
                    endIdValue.append(this.resolveIdByType(readDatum, null));
                } else {
                    entityToHydrate.endId(this.resolveIdByType(readDatum, null), this.groups.get(this.parquetDataFile.relationshipEndIdGroupName()));
                }
                isRelationshipEntity = true;
            }
            if (!parquetColumn.isType() || !(readDatum instanceof String) || (typeColumnData = (String)readDatum).isBlank()) continue;
            type = typeColumnData;
        }
        if (!isRelationshipEntity && !labels.isEmpty()) {
            entityToHydrate.labels(labels.toArray(new String[0]));
        }
        if (isRelationshipEntity && type != null && !type.isBlank()) {
            entityToHydrate.type(type);
        }
        if (this.idType == IdType.STRING && !idValue.isEmpty()) {
            entityToHydrate.id((Object)idValue.toString(), this.groups.get(this.parquetDataFile.groupName()));
        }
        if (this.idType == IdType.STRING && !startIdValue.isEmpty()) {
            entityToHydrate.startId(this.resolveIdByType(startIdValue.toString(), null), this.groups.get(this.parquetDataFile.relationshipStartIdGroupName()));
        }
        if (this.idType == IdType.STRING && !endIdValue.isEmpty()) {
            entityToHydrate.endId(this.resolveIdByType(endIdValue.toString(), null), this.groups.get(this.parquetDataFile.relationshipStartIdGroupName()));
        }
        entityToHydrate.endOfEntity();
        return true;
    }

    private Object convertType(Object object, ParquetColumn parquetColumn) {
        try {
            if (parquetColumn.isRaw() && parquetColumn.primitiveType().getLogicalTypeAnnotation() == null) {
                return object;
            }
            if (parquetColumn.isArray() && !(object instanceof List)) {
                String[] parts = object.toString().split(this.arrayDelimiter);
                Object[] values = new Object[parts.length];
                ParquetColumn nonArrayType = parquetColumn.withoutArray();
                for (int i = 0; i < parts.length; ++i) {
                    values[i] = this.convertType(parts[i], nonArrayType);
                }
                return values;
            }
            if (parquetColumn.columnType() == ParquetColumnType.VECTOR) {
                return this.convertVectorType(object, parquetColumn);
            }
            if (object instanceof List) {
                return object;
            }
            return switch (parquetColumn.columnType()) {
                case ParquetColumnType.POINT -> {
                    if (parquetColumn.hasConfiguration()) {
                        PointValue parts = PointValue.parse((CharSequence)object.toString(), (CSVHeaderInformation)PointValue.parseHeaderInformation((CharSequence)parquetColumn.rawConfiguration()));
                        yield parts;
                    }
                    PointValue parts = PointValue.parse((CharSequence)object.toString());
                    yield parts;
                }
                case ParquetColumnType.DATE -> {
                    DateValue v1;
                    if (object instanceof Number) {
                        Number number = (Number)object;
                        v1 = DateValue.epochDate((long)number.intValue());
                    } else {
                        v1 = DateValue.parse((CharSequence)object.toString());
                    }
                    DateValue parts = v1;
                    yield parts;
                }
                case ParquetColumnType.TIME -> {
                    TimeValue v2;
                    if (object instanceof Number) {
                        Number number = (Number)object;
                        v2 = TimeValue.time((long)number.longValue(), (ZoneOffset)ZoneOffset.UTC);
                    } else {
                        v2 = TimeValue.parse((CharSequence)object.toString(), parquetColumn.getTimezone(this.defaultTimezoneSupplier), null);
                    }
                    TimeValue parts = v2;
                    yield parts;
                }
                case ParquetColumnType.DATE_TIME -> {
                    DateTimeValue parts = DateTimeValue.parse((CharSequence)object.toString(), parquetColumn.getTimezone(this.defaultTimezoneSupplier), null);
                    yield parts;
                }
                case ParquetColumnType.LOCAL_TIME -> {
                    LocalTimeValue parts = LocalTimeValue.parse((CharSequence)object.toString());
                    yield parts;
                }
                case ParquetColumnType.LOCAL_DATE_TIME -> {
                    if (object instanceof Long) {
                        LocalDateTimeValue parts = LocalDateTimeValue.localDateTime((long)((Long)object / 1000000L), (long)0L);
                        yield parts;
                    }
                    try {
                        LocalDateTimeValue parts = LocalDateTimeValue.parse((CharSequence)object.toString());
                        yield parts;
                    }
                    catch (TemporalParseException e) {
                        LocalDateTimeValue parts = LocalDateTimeValue.localDateTime((LocalDateTime)((ZonedDateTime)DateTimeValue.parse((CharSequence)object.toString(), () -> ZoneId.of(ZoneOffset.UTC.getId())).asObjectCopy()).toLocalDateTime());
                        yield parts;
                    }
                }
                case ParquetColumnType.DURATION -> {
                    DurationValue parts = DurationValue.parse((CharSequence)object.toString());
                    yield parts;
                }
                case ParquetColumnType.INT -> {
                    Integer parts = Integer.valueOf(object.toString());
                    yield parts;
                }
                case ParquetColumnType.SHORT -> {
                    Short parts = Short.valueOf(object.toString());
                    yield parts;
                }
                case ParquetColumnType.STRING -> {
                    String parts = object.toString();
                    yield parts;
                }
                case ParquetColumnType.LONG -> {
                    Long parts = Long.valueOf(object.toString());
                    yield parts;
                }
                case ParquetColumnType.BYTE -> {
                    Byte parts = Byte.parseByte(object.toString());
                    yield parts;
                }
                case ParquetColumnType.DOUBLE -> {
                    Double parts = Double.parseDouble(object.toString());
                    yield parts;
                }
                case ParquetColumnType.FLOAT -> {
                    Float parts = Float.valueOf(Float.parseFloat(object.toString()));
                    yield parts;
                }
                default -> {
                    Object parts;
                    yield parts = object;
                }
            };
        }
        catch (RuntimeException e) {
            throw new InputException("could not convert %s to %s: %s".formatted(new Object[]{object.toString(), parquetColumn.columnType(), e.getMessage()}), e);
        }
    }

    private VectorValue convertVectorType(Object object, ParquetColumn parquetColumn) {
        String[] parts = object.toString().split(this.vectorDelimiter);
        VectorExtractor.VectorCSVHeaderInformation headerInformation = VectorExtractor.parseHeaderInformation(parquetColumn.configuration());
        int dimensions = headerInformation.getDimensions();
        Vector.CoordinateType coordinateType = headerInformation.getCoordinateType();
        if (dimensions != parts.length) {
            throw new IllegalArgumentException("Header specified %d dimensions, but vector has %d dimensions: %s".formatted(dimensions, parts.length, object));
        }
        return switch (coordinateType) {
            default -> throw new MatchException(null, null);
            case Vector.CoordinateType.INTEGER8 -> {
                ParquetColumn innerColumn = parquetColumn.withColumnType(ParquetColumnType.resolve("byte"));
                byte[] values = new byte[dimensions];
                for (int i = 0; i < dimensions; ++i) {
                    values[i] = (Byte)this.convertType(parts[i], innerColumn);
                }
                yield Values.int8Vector((byte[])values);
            }
            case Vector.CoordinateType.INTEGER16 -> {
                ParquetColumn innerColumn = parquetColumn.withColumnType(ParquetColumnType.resolve("short"));
                short[] values = new short[dimensions];
                for (int i = 0; i < dimensions; ++i) {
                    values[i] = (Short)this.convertType(parts[i], innerColumn);
                }
                yield Values.int16Vector((short[])values);
            }
            case Vector.CoordinateType.INTEGER32 -> {
                ParquetColumn innerColumn = parquetColumn.withColumnType(ParquetColumnType.resolve("int"));
                int[] values = new int[parts.length];
                for (int i = 0; i < parts.length; ++i) {
                    values[i] = (Integer)this.convertType(parts[i], innerColumn);
                }
                yield Values.int32Vector((int[])values);
            }
            case Vector.CoordinateType.INTEGER64 -> {
                ParquetColumn innerColumn = parquetColumn.withColumnType(ParquetColumnType.resolve("long"));
                long[] values = new long[dimensions];
                for (int i = 0; i < dimensions; ++i) {
                    values[i] = (Long)this.convertType(parts[i], innerColumn);
                }
                yield Values.int64Vector((long[])values);
            }
            case Vector.CoordinateType.FLOAT32 -> {
                ParquetColumn innerColumn = parquetColumn.withColumnType(ParquetColumnType.resolve("float"));
                float[] values = new float[dimensions];
                for (int i = 0; i < dimensions; ++i) {
                    values[i] = ((Float)this.convertType(parts[i], innerColumn)).floatValue();
                }
                yield Values.float32Vector((float[])values);
            }
            case Vector.CoordinateType.FLOAT64 -> {
                ParquetColumn innerColumn = parquetColumn.withColumnType(ParquetColumnType.resolve("double"));
                double[] values = new double[dimensions];
                for (int i = 0; i < dimensions; ++i) {
                    values[i] = (Double)this.convertType(parts[i], innerColumn);
                }
                yield Values.float64Vector((double[])values);
            }
        };
    }

    private boolean isEmptyString(Object object) {
        String stringValue;
        return object instanceof String && (stringValue = (String)object).isEmpty();
    }

    private Object resolveIdByType(Object id, IdType columnIdType) {
        if (id instanceof String) {
            String stringId = (String)id;
            return stringId;
        }
        if (id instanceof Long) {
            Long longId = (Long)id;
            return longId;
        }
        if (id instanceof Integer) {
            Integer intId = (Integer)id;
            if (columnIdType == IdType.INTEGER) {
                return intId;
            }
            return intId.longValue();
        }
        throw new IllegalArgumentException("Cannot convert id of type " + String.valueOf(id.getClass()));
    }

    private Collection<String> filterEmptyLabelsAndTrim(Collection<String> labels) {
        return labels.stream().filter(s -> !s.isEmpty()).map(String::trim).collect(Collectors.toSet());
    }

    private Collection<String> readLabelsFromEntry(Object readDatum) {
        return this.labelCache.computeIfAbsent(readDatum, read -> this.filterEmptyLabelsAndTrim(Arrays.asList(read.toString().split(this.arrayDelimiter))));
    }
}

